/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation.okhttp3;

import com.newrelic.agent.android.instrumentation.HttpURLConnectionExtension;
import com.newrelic.agent.android.instrumentation.HttpsURLConnectionExtension;
import com.newrelic.agent.android.instrumentation.ReplaceCallSite;
import com.newrelic.agent.android.instrumentation.okhttp3.CallExtension;
import com.newrelic.agent.android.instrumentation.okhttp3.RequestBuilderExtension;
import com.newrelic.agent.android.instrumentation.okhttp3.ResponseBuilderExtension;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.OkUrlFactory;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Internal;
import okhttp3.internal.connection.StreamAllocation;

public class OkHttp3Instrumentation {
    private static final AgentLog log = AgentLogManager.getAgentLog();

    private OkHttp3Instrumentation() {
    }

    @ReplaceCallSite
    public static Request build(Request.Builder builder) {
        return new RequestBuilderExtension(builder).build();
    }

    @ReplaceCallSite
    public static Call newCall(OkHttpClient client, Request request) {
        return new CallExtension(client, request, client.newCall(request));
    }

    @ReplaceCallSite
    public static Response.Builder body(Response.Builder builder, ResponseBody body) {
        return new ResponseBuilderExtension(builder).body(body);
    }

    @ReplaceCallSite
    public static Response.Builder newBuilder(Response.Builder builder) {
        return new ResponseBuilderExtension(builder);
    }

    @ReplaceCallSite(isStatic=false, scope="okhttp3.OkUrlFactory")
    public static HttpURLConnection open(OkUrlFactory factory, URL url) {
        HttpURLConnection conn = factory.open(url);
        String protocol = url.getProtocol();
        if (protocol.equals("http")) {
            return new HttpURLConnectionExtension(conn);
        }
        if (protocol.equals("https") && conn instanceof HttpsURLConnection) {
            return new HttpsURLConnectionExtension((HttpsURLConnection)conn);
        }
        return new HttpURLConnectionExtension(conn);
    }

    @ReplaceCallSite
    public static void setCallWebSocket(Internal internal, Call call) {
        try {
            if (call instanceof CallExtension) {
                call = ((CallExtension)call).getImpl();
            }
            internal.setCallWebSocket(call);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    @ReplaceCallSite
    public static StreamAllocation callEngineGetStreamAllocation(Internal internal, Call call) {
        StreamAllocation streamAllocation = null;
        try {
            if (call instanceof CallExtension) {
                call = ((CallExtension)call).getImpl();
            }
            streamAllocation = internal.callEngineGetStreamAllocation(call);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return streamAllocation;
    }
}

