/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.logging;

import android.util.Log;
import com.newrelic.agent.android.logging.AgentLog;

public class AndroidAgentLog
implements AgentLog {
    private static final String TAG = "com.newrelic.agent.android";
    private int level = 3;

    public void debug(String message) {
        if (this.level == 5) {
            Log.d((String)TAG, (String)message);
        }
    }

    public void verbose(String message) {
        if (this.level >= 4) {
            Log.v((String)TAG, (String)message);
        }
    }

    public void info(String message) {
        if (this.level >= 3) {
            Log.i((String)TAG, (String)message);
        }
    }

    public void warning(String message) {
        if (this.level >= 2) {
            Log.w((String)TAG, (String)message);
        }
    }

    public void error(String message) {
        if (this.level >= 1) {
            Log.e((String)TAG, (String)message);
        }
    }

    public void error(String message, Throwable cause) {
        if (this.level >= 1) {
            Log.e((String)TAG, (String)message, (Throwable)cause);
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        if (level > 5 || level < 1) {
            throw new IllegalArgumentException("Log level is not between ERROR and DEBUG");
        }
        this.level = level;
    }
}

