/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Looper;
import android.os.StatFs;
import android.text.TextUtils;
import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.AgentImpl;
import com.newrelic.agent.android.AgentInitializationException;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.InstantApps;
import com.newrelic.agent.android.Measurements;
import com.newrelic.agent.android.NullAgentImpl;
import com.newrelic.agent.android.SavedState;
import com.newrelic.agent.android.analytics.AnalyticsAttribute;
import com.newrelic.agent.android.analytics.AnalyticsAttributeStore;
import com.newrelic.agent.android.analytics.AnalyticsControllerImpl;
import com.newrelic.agent.android.analytics.EventManager;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.api.v1.ConnectionEvent;
import com.newrelic.agent.android.api.v1.ConnectionListener;
import com.newrelic.agent.android.api.v1.DeviceForm;
import com.newrelic.agent.android.api.v2.TraceMachineInterface;
import com.newrelic.agent.android.background.ApplicationStateEvent;
import com.newrelic.agent.android.background.ApplicationStateListener;
import com.newrelic.agent.android.background.ApplicationStateMonitor;
import com.newrelic.agent.android.crash.CrashStore;
import com.newrelic.agent.android.distributedtracing.UserActionFacade;
import com.newrelic.agent.android.distributedtracing.UserActionType;
import com.newrelic.agent.android.harvest.AgentHealth;
import com.newrelic.agent.android.harvest.ApplicationInformation;
import com.newrelic.agent.android.harvest.ConnectInformation;
import com.newrelic.agent.android.harvest.DeviceInformation;
import com.newrelic.agent.android.harvest.EnvironmentInformation;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.HarvestConfiguration;
import com.newrelic.agent.android.harvest.HarvestData;
import com.newrelic.agent.android.harvest.HarvestLifecycleAware;
import com.newrelic.agent.android.instrumentation.MetricCategory;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.measurement.consumer.MeasurementConsumer;
import com.newrelic.agent.android.metric.MetricUnit;
import com.newrelic.agent.android.payload.PayloadController;
import com.newrelic.agent.android.payload.PayloadStore;
import com.newrelic.agent.android.sample.MachineMeasurementConsumer;
import com.newrelic.agent.android.sample.Sampler;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.stores.SharedPrefsAnalyticsAttributeStore;
import com.newrelic.agent.android.stores.SharedPrefsCrashStore;
import com.newrelic.agent.android.stores.SharedPrefsPayloadStore;
import com.newrelic.agent.android.tracing.TraceMachine;
import com.newrelic.agent.android.util.ActivityLifecycleBackgroundListener;
import com.newrelic.agent.android.util.AndroidEncoder;
import com.newrelic.agent.android.util.Connectivity;
import com.newrelic.agent.android.util.Encoder;
import com.newrelic.agent.android.util.PersistentUUID;
import com.newrelic.agent.android.util.Reachability;
import com.newrelic.agent.android.util.UiBackgroundListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AndroidAgentImpl
implements AgentImpl,
ConnectionListener,
ApplicationStateListener,
TraceMachineInterface {
    private static final float LOCATION_ACCURACY_THRESHOLD = 500.0f;
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private final Context context;
    private SavedState savedState;
    private LocationListener locationListener;
    private final Lock lock = new ReentrantLock();
    private final Encoder encoder = new AndroidEncoder();
    private DeviceInformation deviceInformation;
    private ApplicationInformation applicationInformation;
    private final AgentConfiguration agentConfiguration;
    private MachineMeasurementConsumer machineMeasurementConsumer;
    private static final Comparator<TransactionData> cmp = new Comparator<TransactionData>(){

        @Override
        public int compare(TransactionData lhs, TransactionData rhs) {
            if (lhs.getTimestamp() > rhs.getTimestamp()) {
                return -1;
            }
            if (lhs.getTimestamp() < rhs.getTimestamp()) {
                return 1;
            }
            return 0;
        }
    };

    public AndroidAgentImpl(Context context, AgentConfiguration agentConfiguration) throws AgentInitializationException {
        this.context = AndroidAgentImpl.appContext(context);
        this.agentConfiguration = agentConfiguration;
        this.savedState = new SavedState(this.context);
        if (this.isDisabled()) {
            throw new AgentInitializationException("This version of the agent has been disabled");
        }
        this.initApplicationInformation();
        if (agentConfiguration.useLocationService() && this.context.getPackageManager().checkPermission("android.permission.ACCESS_FINE_LOCATION", this.getApplicationInformation().getPackageId()) == 0) {
            log.debug("Location stats enabled");
            this.addLocationListener();
        }
        TraceMachine.setTraceMachineInterface((TraceMachineInterface)this);
        agentConfiguration.setCrashStore((CrashStore)new SharedPrefsCrashStore(context));
        agentConfiguration.setPayloadStore((PayloadStore)new SharedPrefsPayloadStore(context));
        agentConfiguration.setAnalyticsAttributeStore((AnalyticsAttributeStore)new SharedPrefsAnalyticsAttributeStore(context));
        ApplicationStateMonitor.getInstance().addApplicationStateListener((ApplicationStateListener)this);
        if (Build.VERSION.SDK_INT >= 14) {
            UiBackgroundListener backgroundListener;
            if (Agent.getUnityInstrumentationFlag().equals("YES")) {
                backgroundListener = new ActivityLifecycleBackgroundListener();
                if (backgroundListener instanceof Application.ActivityLifecycleCallbacks) {
                    try {
                        if (context.getApplicationContext() instanceof Application) {
                            Application application = (Application)context.getApplicationContext();
                            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)backgroundListener);
                        }
                    }
                    catch (Exception exception) {}
                }
            } else {
                backgroundListener = new UiBackgroundListener();
            }
            context.registerComponentCallbacks((ComponentCallbacks)backgroundListener);
        }
        this.setupSession();
    }

    protected void initialize() {
        this.setupSession();
        AnalyticsControllerImpl.initialize((AgentConfiguration)this.agentConfiguration, (AgentImpl)this);
        Harvest.addHarvestListener((HarvestLifecycleAware)this.savedState);
        Harvest.initialize((AgentConfiguration)this.agentConfiguration);
        Harvest.setHarvestConfiguration((HarvestConfiguration)this.savedState.getHarvestConfiguration());
        Harvest.setHarvestConnectInformation((ConnectInformation)this.savedState.getConnectInformation());
        Measurements.initialize();
        log.info(MessageFormat.format("New Relic Agent v{0}", Agent.getVersion()));
        log.verbose(MessageFormat.format("Application token: {0}", this.agentConfiguration.getApplicationToken()));
        this.machineMeasurementConsumer = new MachineMeasurementConsumer();
        Measurements.addMeasurementConsumer((MeasurementConsumer)this.machineMeasurementConsumer);
        StatsEngine.get().inc("Supportability/AgentHealth/UncaughtExceptionHandler/" + this.getUnhandledExceptionHandlerName());
        PayloadController.initialize((AgentConfiguration)this.agentConfiguration);
        Sampler.init(this.context);
        if (this.isInstantApp()) {
            log.info("This appears to be an Instant App");
            AnalyticsAttribute attribute = new AnalyticsAttribute("instantApp", true);
            AnalyticsControllerImpl.getInstance().addAttributeUnchecked(attribute, false);
        }
    }

    protected void setupSession() {
        TraceMachine.clearActivityHistory();
        this.agentConfiguration.provideSessionId();
    }

    protected void finalizeSession() {
    }

    public boolean updateSavedConnectInformation() {
        ConnectInformation savedConnectInformation = this.savedState.getConnectInformation();
        ConnectInformation newConnectInformation = new ConnectInformation(this.getApplicationInformation(), this.getDeviceInformation());
        if (!newConnectInformation.equals((Object)savedConnectInformation) || !this.savedState.hasConnectionToken(this.agentConfiguration.getApplicationToken())) {
            if (newConnectInformation.getApplicationInformation().isAppUpgrade(savedConnectInformation.getApplicationInformation())) {
                StatsEngine.get().inc("Mobile/App/Upgrade");
                AnalyticsAttribute attribute = new AnalyticsAttribute("upgradeFrom", savedConnectInformation.getApplicationInformation().getAppVersion());
                AnalyticsControllerImpl.getInstance().addAttributeUnchecked(attribute, false);
            }
            this.savedState.clear();
            this.savedState.saveConnectInformation(newConnectInformation);
            this.savedState.saveConnectionToken(this.agentConfiguration.getApplicationToken());
            return true;
        }
        return false;
    }

    public DeviceInformation getDeviceInformation() {
        if (this.deviceInformation != null) {
            return this.deviceInformation;
        }
        DeviceInformation info = new DeviceInformation();
        info.setOsName("Android");
        info.setOsVersion(Build.VERSION.RELEASE);
        info.setOsBuild(Build.VERSION.INCREMENTAL);
        info.setModel(Build.MODEL);
        info.setAgentName("AndroidAgent");
        info.setAgentVersion(Agent.getVersion());
        info.setManufacturer(Build.MANUFACTURER);
        info.setDeviceId(this.getUUID());
        info.setArchitecture(System.getProperty("os.arch"));
        info.setRunTime(System.getProperty("java.vm.version"));
        info.setSize(AndroidAgentImpl.deviceForm(this.context).name().toLowerCase(Locale.getDefault()));
        info.setApplicationFramework(this.agentConfiguration.getApplicationFramework());
        info.setApplicationFrameworkVersion(this.agentConfiguration.getApplicationFrameworkVersion());
        this.deviceInformation = info;
        return this.deviceInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnvironmentInformation getEnvironmentInformation() {
        EnvironmentInformation envInfo = new EnvironmentInformation();
        ActivityManager activityManager = (ActivityManager)this.context.getSystemService("activity");
        long[] free = new long[2];
        try {
            StatFs rootStatFs = new StatFs(Environment.getRootDirectory().getAbsolutePath());
            StatFs externalStatFs = new StatFs(Environment.getExternalStorageDirectory().getAbsolutePath());
            if (Build.VERSION.SDK_INT >= 18) {
                free[0] = rootStatFs.getAvailableBlocksLong() * rootStatFs.getBlockSizeLong();
                free[1] = externalStatFs.getAvailableBlocksLong() * rootStatFs.getBlockSizeLong();
            } else {
                free[0] = rootStatFs.getAvailableBlocks() * rootStatFs.getBlockSize();
                free[1] = externalStatFs.getAvailableBlocks() * externalStatFs.getBlockSize();
            }
        }
        catch (Exception e) {
            AgentHealth.noticeException((Exception)e);
        }
        finally {
            if (free[0] < 0L) {
                free[0] = 0L;
            }
            if (free[1] < 0L) {
                free[1] = 0L;
            }
            envInfo.setDiskAvailable(free);
        }
        envInfo.setMemoryUsage(Sampler.sampleMemory(activityManager).getSampleValue().asLong().longValue());
        envInfo.setOrientation(this.context.getResources().getConfiguration().orientation);
        envInfo.setNetworkStatus(this.getNetworkCarrier());
        envInfo.setNetworkWanType(this.getNetworkWanType());
        return envInfo;
    }

    public void initApplicationInformation() throws AgentInitializationException {
        String appName;
        if (this.applicationInformation != null) {
            log.debug("attempted to reinitialize ApplicationInformation.");
            return;
        }
        String packageName = this.context.getPackageName();
        PackageManager packageManager = this.context.getPackageManager();
        PackageInfo packageInfo = null;
        try {
            packageInfo = packageManager.getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new AgentInitializationException("Could not determine package version: " + e.getMessage());
        }
        String appVersion = this.agentConfiguration.getCustomApplicationVersion();
        if (TextUtils.isEmpty((CharSequence)appVersion)) {
            if (packageInfo != null && packageInfo.versionName != null && packageInfo.versionName.length() > 0) {
                appVersion = packageInfo.versionName;
            } else {
                throw new AgentInitializationException("Your app doesn't appear to have a version defined. Ensure you have defined 'versionName' in your manifest.");
            }
        }
        log.debug("Using application version " + appVersion);
        try {
            ApplicationInfo info = packageManager.getApplicationInfo(packageName, 0);
            appName = info != null ? packageManager.getApplicationLabel(info).toString() : packageName;
        }
        catch (PackageManager.NameNotFoundException e) {
            log.warning(e.toString());
            appName = packageName;
        }
        catch (SecurityException e) {
            log.warning(e.toString());
            appName = packageName;
        }
        log.debug("Using application name " + appName);
        String build = this.agentConfiguration.getCustomBuildIdentifier();
        if (TextUtils.isEmpty((CharSequence)build)) {
            if (packageInfo != null) {
                build = String.valueOf(packageInfo.versionCode);
            } else {
                build = "";
                log.warning("Your app doesn't appear to have a version code defined. Ensure you have defined 'versionCode' in your manifest.");
            }
        }
        log.debug("Using build " + build);
        this.applicationInformation = new ApplicationInformation(appName, appVersion, packageName, build);
        this.applicationInformation.setVersionCode(packageInfo.versionCode);
    }

    public ApplicationInformation getApplicationInformation() {
        return this.applicationInformation;
    }

    public long getSessionDurationMillis() {
        return Harvest.getMillisSinceStart();
    }

    private static DeviceForm deviceForm(Context context) {
        int deviceSize = context.getResources().getConfiguration().screenLayout & 0xF;
        switch (deviceSize) {
            case 1: {
                return DeviceForm.SMALL;
            }
            case 2: {
                return DeviceForm.NORMAL;
            }
            case 3: {
                return DeviceForm.LARGE;
            }
        }
        if (deviceSize > 3) {
            return DeviceForm.XLARGE;
        }
        return DeviceForm.UNKNOWN;
    }

    private static Context appContext(Context context) {
        if (!(context instanceof Application)) {
            return context.getApplicationContext();
        }
        return context;
    }

    @Deprecated
    public void addTransactionData(TransactionData transactionData) {
    }

    @Deprecated
    public void mergeTransactionData(List<TransactionData> transactionDataList) {
    }

    @Deprecated
    public List<TransactionData> getAndClearTransactionData() {
        return null;
    }

    public String getCrossProcessId() {
        this.lock.lock();
        try {
            String string = this.savedState.getCrossProcessId();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getStackTraceLimit() {
        this.lock.lock();
        try {
            int n = this.savedState.getStackTraceLimit();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getResponseBodyLimit() {
        this.lock.lock();
        try {
            int n = this.savedState.getHarvestConfiguration().getResponse_body_limit();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void start() {
        if (!this.isDisabled()) {
            this.initialize();
            Harvest.start();
            if (FeatureFlag.featureEnabled((FeatureFlag)FeatureFlag.DistributedTracing)) {
                UserActionFacade.getInstance().recordUserAction(UserActionType.AppLaunch);
            }
        } else {
            this.stop(false);
        }
    }

    public void stop() {
        this.stop(true);
    }

    void stop(boolean finalSendData) {
        if (FeatureFlag.featureEnabled((FeatureFlag)FeatureFlag.DistributedTracing)) {
            UserActionFacade.getInstance().recordUserAction(UserActionType.AppBackground);
        }
        this.finalizeSession();
        Sampler.shutdown();
        TraceMachine.haltTracing();
        AnalyticsControllerImpl analyticsController = AnalyticsControllerImpl.getInstance();
        EventManager eventManager = analyticsController.getEventManager();
        int eventsRecorded = eventManager.getEventsRecorded();
        int eventsEjected = eventManager.getEventsEjected();
        Measurements.addCustomMetric((String)"Supportability/Events/Recorded", (String)MetricCategory.NONE.name(), (int)eventsRecorded, (double)eventsEjected, (double)eventsEjected, (MetricUnit)MetricUnit.OPERATIONS, (MetricUnit)MetricUnit.OPERATIONS);
        if (finalSendData) {
            if (this.isUIThread()) {
                StatsEngine.get().inc("Supportability/AgentHealth/HarvestOnMainThread");
            }
            Harvest.harvestNow((boolean)true);
            HarvestData harvestData = Harvest.getInstance().getHarvestData();
            log.debug("EventManager: recorded[" + eventManager.getEventsRecorded() + "] ejected[" + eventManager.getEventsEjected() + "]");
            if (harvestData != null && harvestData.isValid()) {
                Collection events = harvestData.getAnalyticsEvents();
                if (!events.isEmpty()) {
                    log.warning("Agent stopped with " + events.size() + " events dropped from failed harvest.");
                }
                if (0 < eventManager.size()) {
                    log.warning("Agent stopped with " + eventManager.size() + " events left in event pool.");
                }
            }
        }
        AnalyticsControllerImpl.shutdown();
        TraceMachine.clearActivityHistory();
        Harvest.shutdown();
        Measurements.shutdown();
        PayloadController.shutdown();
    }

    public void disable() {
        log.warning("PERMANENTLY DISABLING AGENT v" + Agent.getVersion());
        try {
            this.savedState.saveDisabledVersion(Agent.getVersion());
        }
        finally {
            try {
                this.stop(false);
            }
            finally {
                Agent.setImpl((AgentImpl)NullAgentImpl.instance);
            }
        }
    }

    public boolean isDisabled() {
        return Agent.getVersion().equals(this.savedState.getDisabledVersion());
    }

    public String getNetworkCarrier() {
        return Connectivity.carrierNameFromContext(this.context);
    }

    public String getNetworkWanType() {
        return Connectivity.wanType(this.context);
    }

    public static void init(Context context, AgentConfiguration agentConfiguration) {
        try {
            Agent.setImpl((AgentImpl)new AndroidAgentImpl(context, agentConfiguration));
            Agent.start();
        }
        catch (AgentInitializationException e) {
            log.error("Failed to initialize the agent: " + e.toString());
            return;
        }
    }

    @Deprecated
    public void connected(ConnectionEvent e) {
        log.error("AndroidAgentImpl: connected ");
    }

    @Deprecated
    public void disconnected(ConnectionEvent e) {
        this.savedState.clear();
    }

    public void applicationForegrounded(ApplicationStateEvent e) {
        log.info("AndroidAgentImpl: application foregrounded");
        this.start();
    }

    public void applicationBackgrounded(ApplicationStateEvent e) {
        log.info("AndroidAgentImpl: application backgrounded");
        this.stop();
    }

    public void setLocation(String countryCode, String adminRegion) {
        if (countryCode == null || adminRegion == null) {
            throw new IllegalArgumentException("Country code and administrative region are required.");
        }
    }

    public void setLocation(Location location) {
        if (location == null) {
            throw new IllegalArgumentException("Location must not be null.");
        }
        Geocoder coder = new Geocoder(this.context);
        List addresses = null;
        try {
            addresses = coder.getFromLocation(location.getLatitude(), location.getLongitude(), 1);
        }
        catch (IOException e) {
            log.error("Unable to geocode location: " + e.toString());
        }
        if (addresses == null || addresses.size() == 0) {
            return;
        }
        Address address = (Address)addresses.get(0);
        if (address == null) {
            return;
        }
        String countryCode = address.getCountryCode();
        String adminArea = address.getAdminArea();
        if (countryCode != null && adminArea != null) {
            this.setLocation(countryCode, adminArea);
            this.removeLocationListener();
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void addLocationListener() {
        LocationManager locationManager = (LocationManager)this.context.getSystemService("location");
        if (locationManager == null) {
            log.error("Unable to retrieve reference to LocationManager. Disabling location listener.");
            return;
        }
        this.locationListener = new LocationListener(){

            public void onLocationChanged(Location location) {
                if (AndroidAgentImpl.this.isAccurate(location)) {
                    AndroidAgentImpl.this.setLocation(location);
                }
            }

            public void onProviderDisabled(String provider) {
                if ("passive".equals(provider)) {
                    AndroidAgentImpl.this.removeLocationListener();
                }
            }

            public void onProviderEnabled(String provider) {
            }

            public void onStatusChanged(String provider, int status, Bundle extras) {
            }
        };
        locationManager.requestLocationUpdates("passive", 1000L, 0.0f, this.locationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"MissingPermission"})
    private void removeLocationListener() {
        if (this.locationListener == null) {
            return;
        }
        LocationManager locationManager = (LocationManager)this.context.getSystemService("location");
        if (locationManager == null) {
            log.error("Unable to retrieve reference to LocationManager. Can't unregister location listener.");
            return;
        }
        LocationManager locationManager2 = locationManager;
        synchronized (locationManager2) {
            locationManager.removeUpdates(this.locationListener);
            this.locationListener = null;
        }
    }

    private boolean isAccurate(Location location) {
        if (location == null) {
            return false;
        }
        return 500.0f >= location.getAccuracy();
    }

    private String getUUID() {
        String uuid = this.savedState.getConnectInformation().getDeviceInformation().getDeviceId();
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            PersistentUUID persistentUUID = new PersistentUUID(this.context);
            uuid = persistentUUID.getPersistentUUID();
            this.savedState.saveDeviceId(uuid);
        }
        return uuid;
    }

    private String getUnhandledExceptionHandlerName() {
        try {
            return Thread.getDefaultUncaughtExceptionHandler().getClass().getName();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public long getCurrentThreadId() {
        return Thread.currentThread().getId();
    }

    public boolean isUIThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public String getCurrentThreadName() {
        return Thread.currentThread().getName();
    }

    protected SavedState getSavedState() {
        return this.savedState;
    }

    protected void setSavedState(SavedState savedState) {
        this.savedState = savedState;
    }

    public boolean hasReachableNetworkConnection(String reachableHost) {
        return Reachability.hasReachableNetworkConnection(this.context, reachableHost);
    }

    public boolean isInstantApp() {
        return InstantApps.isInstantApp(this.context);
    }
}

