/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation;

import android.annotation.TargetApi;
import android.os.AsyncTask;
import com.newrelic.agent.android.api.v2.TraceFieldInterface;
import com.newrelic.agent.android.instrumentation.ReplaceCallSite;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.tracing.TraceMachine;
import com.newrelic.agent.android.tracing.TracingInactiveException;
import com.newrelic.agent.android.util.ExceptionHelper;
import java.util.concurrent.Executor;

public class AsyncTaskInstrumentation {
    private static final AgentLog log = AgentLogManager.getAgentLog();

    protected AsyncTaskInstrumentation() {
    }

    @TargetApi(value=14)
    @ReplaceCallSite
    public static final <Params, Progress, Result> AsyncTask execute(AsyncTask<Params, Progress, Result> task, Params ... params) {
        try {
            TraceFieldInterface tfi = (TraceFieldInterface)task;
            tfi._nr_setTrace(TraceMachine.getCurrentTrace());
        }
        catch (ClassCastException e) {
            ExceptionHelper.recordSupportabilityMetric((Exception)e, (String)"TraceFieldInterface");
            log.error("Not a TraceFieldInterface: " + e.getMessage());
        }
        catch (TracingInactiveException tracingInactiveException) {
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        return task.execute((Object[])params);
    }

    @TargetApi(value=11)
    @ReplaceCallSite
    public static final <Params, Progress, Result> AsyncTask executeOnExecutor(AsyncTask<Params, Progress, Result> task, Executor exec, Params ... params) {
        try {
            TraceFieldInterface tfi = (TraceFieldInterface)task;
            tfi._nr_setTrace(TraceMachine.getCurrentTrace());
        }
        catch (ClassCastException e) {
            ExceptionHelper.recordSupportabilityMetric((Exception)e, (String)"TraceFieldInterface");
            log.error("Not a TraceFieldInterface: " + e.getMessage());
        }
        catch (TracingInactiveException tracingInactiveException) {
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        return task.executeOnExecutor(exec, (Object[])params);
    }
}

