/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.stores;

import android.content.Context;
import android.content.SharedPreferences;
import com.newrelic.agent.android.crash.Crash;
import com.newrelic.agent.android.crash.CrashStore;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.stores.SharedPrefsStore;
import com.newrelic.agent.android.util.SafeJsonPrimitive;
import com.newrelic.com.google.gson.JsonElement;
import com.newrelic.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public class SharedPrefsCrashStore
extends SharedPrefsStore
implements CrashStore {
    private static final String STORE_FILE = "NRCrashStore";

    public SharedPrefsCrashStore(Context context) {
        this(context, STORE_FILE);
    }

    public SharedPrefsCrashStore(Context context, String storeFilename) {
        super(context, storeFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean store(Crash crash) {
        SharedPrefsCrashStore sharedPrefsCrashStore = this;
        synchronized (sharedPrefsCrashStore) {
            try {
                JsonObject jsonObj = crash.asJsonObject();
                jsonObj.add("uploadCount", (JsonElement)SafeJsonPrimitive.factory((Number)crash.getUploadCount()));
                String crashJson = jsonObj.toString();
                SharedPreferences.Editor editor = this.sharedPrefs.edit();
                editor.putString(crash.getUuid().toString(), crashJson);
                StatsEngine.get().inc("AgentHealth/Crash/Size/Uncompressed", (long)crashJson.length());
                return editor.commit();
            }
            catch (Exception e) {
                log.error("SharedPrefsStore.store(String, String): ", (Throwable)e);
            }
        }
        return false;
    }

    public List<Crash> fetchAll() {
        ArrayList<Crash> crashes = new ArrayList<Crash>();
        for (Object object : super.fetchAll()) {
            if (!(object instanceof String)) continue;
            try {
                crashes.add(Crash.crashFromJsonString((String)((String)object)));
            }
            catch (Exception e) {
                log.error("Exception encountered while deserializing crash", (Throwable)e);
            }
        }
        return crashes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Crash crash) {
        try {
            SharedPrefsCrashStore sharedPrefsCrashStore = this;
            synchronized (sharedPrefsCrashStore) {
                SharedPreferences.Editor editor = this.sharedPrefs.edit();
                editor.remove(crash.getUuid().toString()).commit();
            }
        }
        catch (Exception e) {
            log.error("SharedPrefsCrashStore.delete(): ", (Throwable)e);
        }
    }
}

