/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android;

import com.newrelic.agent.android.AgentImpl;
import com.newrelic.agent.android.NullAgentImpl;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.harvest.ApplicationInformation;
import com.newrelic.agent.android.harvest.DeviceInformation;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.util.Encoder;
import java.lang.reflect.Field;
import java.util.List;

public class Agent {
    public static final String VERSION = "6.11.0";
    public static final String MONO_INSTRUMENTATION_FLAG = "NO";
    public static final String DEFAULT_BUILD_ID = "";
    private static final AgentImpl NULL_AGENT_IMPL = new NullAgentImpl();
    private static Object implLock = new Object();
    private static AgentImpl impl = NULL_AGENT_IMPL;
    private static String buildId = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setImpl(AgentImpl impl) {
        Object object = implLock;
        synchronized (object) {
            Agent.impl = impl == null ? NULL_AGENT_IMPL : impl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AgentImpl getImpl() {
        Object object = implLock;
        synchronized (object) {
            return impl;
        }
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getMonoInstrumentationFlag() {
        return MONO_INSTRUMENTATION_FLAG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBuildId() {
        Object object = implLock;
        synchronized (object) {
            if (buildId == null) {
                String build_id = DEFAULT_BUILD_ID;
                if (Agent.getMonoInstrumentationFlag().equals("YES")) {
                    build_id = DEFAULT_BUILD_ID;
                } else {
                    try {
                        ClassLoader classLoader = Agent.class.getClassLoader();
                        Class<?> newRelicConfigClass = classLoader.loadClass("com.newrelic.agent.android.NewRelicConfig");
                        build_id = newRelicConfigClass.getDeclaredField("BUILD_ID").get(null).toString();
                    }
                    catch (Exception e) {
                        AgentLogManager.getAgentLog().error("Agent.getBuildId() was unable to find a valid build Id. Crashes and handled exceptions will not be accepted.");
                    }
                }
                buildId = build_id;
            }
        }
        return buildId;
    }

    public static boolean getIsObfuscated() {
        boolean isObfuscated = false;
        try {
            ClassLoader classLoader = Agent.class.getClassLoader();
            Class<?> newRelicConfigClass = classLoader.loadClass("com.newrelic.agent.android.NewRelicConfig");
            Field field = newRelicConfigClass.getDeclaredField("OBFUSCATED");
            field.setAccessible(true);
            isObfuscated = (Boolean)field.get(null);
            field.setAccessible(false);
        }
        catch (Exception e) {
            AgentLogManager.getAgentLog().error("Unable to get obfuscated flag in crash");
        }
        return isObfuscated;
    }

    public static String getCrossProcessId() {
        return Agent.getImpl().getCrossProcessId();
    }

    public static int getStackTraceLimit() {
        return Agent.getImpl().getStackTraceLimit();
    }

    public static int getResponseBodyLimit() {
        return Agent.getImpl().getResponseBodyLimit();
    }

    public static void addTransactionData(TransactionData transactionData) {
        Agent.getImpl().addTransactionData(transactionData);
    }

    public static List<TransactionData> getAndClearTransactionData() {
        return Agent.getImpl().getAndClearTransactionData();
    }

    public static void mergeTransactionData(List<TransactionData> transactionDataList) {
        Agent.getImpl().mergeTransactionData(transactionDataList);
    }

    public static String getActiveNetworkCarrier() {
        return Agent.getImpl().getNetworkCarrier();
    }

    public static String getActiveNetworkWanType() {
        return Agent.getImpl().getNetworkWanType();
    }

    public static void disable() {
        Agent.getImpl().disable();
    }

    public static boolean isDisabled() {
        return Agent.getImpl().isDisabled();
    }

    public static void start() {
        Agent.getImpl().start();
    }

    public static void stop() {
        Agent.getImpl().stop();
    }

    public static void setLocation(String countryCode, String adminRegion) {
        Agent.getImpl().setLocation(countryCode, adminRegion);
    }

    public static Encoder getEncoder() {
        return Agent.getImpl().getEncoder();
    }

    public static DeviceInformation getDeviceInformation() {
        return Agent.getImpl().getDeviceInformation();
    }

    public static ApplicationInformation getApplicationInformation() {
        return Agent.getImpl().getApplicationInformation();
    }

    public static boolean hasReachableNetworkConnection(String reachableHost) {
        return Agent.getImpl().hasReachableNetworkConnection(reachableHost);
    }

    public static boolean isInstantApp() {
        return Agent.getImpl().isInstantApp();
    }
}

