/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.distributedtracing;

import com.newrelic.agent.android.distributedtracing.DistributedTracing;
import com.newrelic.agent.android.distributedtracing.TraceConfiguration;
import com.newrelic.agent.android.distributedtracing.TraceHeader;
import com.newrelic.agent.android.distributedtracing.TraceParent;
import com.newrelic.agent.android.distributedtracing.TracePayload;
import com.newrelic.agent.android.distributedtracing.TraceState;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.stats.StatsEngine;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class TraceContext {
    protected static final AgentLog log = AgentLogManager.getAgentLog();
    static final String TRACE_FIELD_UNUSED = "";
    public static final String INVALID_TRACE_ID = "00000000000000000000000000000000";
    public static final String INVALID_SPAN_ID = "0000000000000000";
    static final String TRACE_ID_REGEX = "^[A-Fa-f0-9]{32}";
    static final String SPAN_ID_REGEX = "^([A-Fa-f0-9]{16})?";
    public static final String SUPPORTABILITY_TRACE_CONTEXT_CREATED = "Supportability/TraceContext/Create/Success";
    public static final String SUPPORTABILITY_TRACE_CONTEXT_EXCEPTION = "Supportability/TraceContext/Create/Exception/%s";
    final TraceConfiguration traceConfiguration = TraceConfiguration.getInstance();
    final String traceId;
    final TraceParent traceParent;
    final TraceState traceState;
    final TracePayload tracePayload;
    final Map<String, String> requestContext;
    boolean legacyHeadersEnabled = true;

    public static TraceContext createTraceContext(Map<String, String> requestContext) {
        W3CTraceContext traceContext = new W3CTraceContext(requestContext);
        return traceContext;
    }

    public TraceContext(Map<String, String> requestContext) {
        this.requestContext = requestContext == null ? new HashMap() : requestContext;
        this.traceId = DistributedTracing.generateTraceId();
        this.traceParent = TraceParent.createTraceParent(this);
        this.traceState = TraceState.createTraceState(this);
        this.tracePayload = new TracePayload(this);
        this.requestContext.put("thread.id", String.valueOf(Thread.currentThread().getId()));
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getParentId() {
        return this.traceParent.getParentId();
    }

    public String getSampled() {
        return String.format(Locale.ROOT, "%02x", this.traceConfiguration.isSampled() ? 1 : 0);
    }

    public String getVendor() {
        return String.format(Locale.ROOT, "%s@nr", this.traceConfiguration.trustedAccountId);
    }

    public String getAccountId() {
        return String.format(Locale.ROOT, "%s", this.traceConfiguration.accountId);
    }

    public String getApplicationId() {
        return String.format(Locale.ROOT, "%s", this.traceConfiguration.applicationId);
    }

    public Set<TraceHeader> getHeaders() {
        return new HashSet<TraceHeader>(){
            {
                if (TraceContext.this.legacyHeadersEnabled) {
                    this.add(TraceContext.this.tracePayload);
                }
            }
        };
    }

    public TracePayload getTracePayload() {
        return this.tracePayload;
    }

    public static void reportSupportabilityMetrics() {
        StatsEngine.get().inc(SUPPORTABILITY_TRACE_CONTEXT_CREATED);
    }

    public static void reportSupportabilityExceptionMetric(Exception e) {
        log.error("setDistributedTraceHeaders: Unable to add trace headers. ", e);
        StatsEngine.get().inc(String.format(Locale.ROOT, SUPPORTABILITY_TRACE_CONTEXT_EXCEPTION, e.getClass().getSimpleName()));
    }

    public Map<String, Object> asTraceAttributes() {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>(){
            {
                this.put("id", TraceContext.this.tracePayload.spanId);
                this.put("guid", TraceContext.this.tracePayload.spanId);
                this.put("trace.id", TraceContext.this.traceId);
            }
        };
        return attributeMap;
    }

    public void putRequestContext(Map<String, String> requestContextAsMap) {
        if (requestContextAsMap != null) {
            this.requestContext.putAll(requestContextAsMap);
        }
    }

    public Map<String, String> getRequestContext() {
        return this.requestContext;
    }

    static class W3CTraceContext
    extends TraceContext {
        public W3CTraceContext(Map<String, String> requestContext) {
            super(requestContext);
        }

        @Override
        public String getParentId() {
            return this.traceParent.getParentId();
        }

        @Override
        public Set<TraceHeader> getHeaders() {
            Set<TraceHeader> headers = super.getHeaders();
            headers.add(this.traceParent);
            headers.add(this.traceState);
            return headers;
        }
    }
}

