/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.hybrid.data;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.agentdata.AgentDataReporter;
import com.newrelic.agent.android.analytics.AnalyticsAttribute;
import com.newrelic.agent.android.analytics.AnalyticsControllerImpl;
import com.newrelic.agent.android.harvest.crash.ApplicationInfo;
import com.newrelic.agent.android.hybrid.StackTrace;
import com.newrelic.agent.android.hybrid.data.DataBuilder;
import com.newrelic.agent.android.hybrid.rninterface.IStack;
import com.newrelic.agent.android.hybrid.rninterface.IStackFrame;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.com.google.flatbuffers.FlatBufferBuilder;
import com.newrelic.mobile.fbs.HexAgentDataBundle;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DataController {
    protected static final AgentConfiguration agentConfiguration = new AgentConfiguration();
    private static final AgentLog log = AgentLogManager.getAgentLog();

    public static FlatBufferBuilder buildAgentDataFromJSError(StackTrace stackTrace, Map<String, Object> exceptionAttributes) {
        HashMap<String, Object> jsErrorException = new HashMap<String, Object>();
        HashMap<String, Object> sessionAttributes = new HashMap<String, Object>();
        ApplicationInfo applicationInfo = new ApplicationInfo(Agent.getApplicationInformation());
        jsErrorException.put("appVersion", applicationInfo.getApplicationVersion());
        jsErrorException.put("appBuild", applicationInfo.getApplicationBuild());
        jsErrorException.put("name", stackTrace.getStackTraceException().getExceptionName());
        jsErrorException.put("message", stackTrace.getStackTraceException().getCause());
        jsErrorException.put("fatal", stackTrace.isFatal());
        jsErrorException.put("buildId", stackTrace.getBuildId());
        jsErrorException.put("bundleId", stackTrace.getBuildId());
        jsErrorException.put("thread", DataController.threadSetFromStackElements(stackTrace.getStacks()));
        jsErrorException.putAll(exceptionAttributes);
        for (AnalyticsAttribute attribute : AnalyticsControllerImpl.getInstance().getSessionAttributes()) {
            switch (attribute.getAttributeDataType()) {
                case STRING: {
                    sessionAttributes.put(attribute.getName(), attribute.getStringValue());
                    break;
                }
                case DOUBLE: {
                    sessionAttributes.put(attribute.getName(), attribute.getDoubleValue());
                    break;
                }
                case BOOLEAN: {
                    sessionAttributes.put(attribute.getName(), attribute.getBooleanValue());
                }
            }
        }
        long sessionDuration = Agent.getImpl().getSessionDurationMillis();
        if (0L == sessionDuration) {
            log.error("Harvest instance is not running! Session duration will be invalid");
        } else {
            sessionAttributes.put("timeSinceLoad", Float.valueOf((float)sessionDuration / 1000.0f));
        }
        sessionAttributes.putAll(exceptionAttributes);
        HashSet<Map<String, Object>> agentData = new HashSet<Map<String, Object>>();
        agentData.add(jsErrorException);
        FlatBufferBuilder flat = DataBuilder.startAndFinishAgentData(sessionAttributes, agentData);
        return flat;
    }

    public static FlatBufferBuilder buildAgentDataFromJSError(StackTrace stackTrace) {
        return DataController.buildAgentDataFromJSError(stackTrace, new HashMap<String, Object>());
    }

    public static Throwable getRootCause(Throwable throwable) {
        block4: {
            try {
                if (throwable != null) {
                    Throwable cause = throwable.getCause();
                    if (cause == null) {
                        return throwable;
                    }
                    return DataController.getRootCause(cause);
                }
            }
            catch (Exception e) {
                if (throwable == null) break block4;
                return throwable;
            }
        }
        return new Throwable("Unknown cause");
    }

    public static List<Map<String, Object>> threadSetFromStackElements(IStack[] ste) {
        ArrayList<Map<String, Object>> thread = new ArrayList<Map<String, Object>>();
        IStack stack = ste[0];
        for (IStackFrame ele : stack.getStackFrames()) {
            LinkedHashMap<String, Object> frame = new LinkedHashMap<String, Object>();
            frame.put("method", ele.getMethodName());
            frame.put("fileName", ele.getFileName());
            frame.put("lineNumber", ele.getLineNumber());
            frame.put("column", ele.getColumnNumber());
            thread.add(frame);
        }
        return thread;
    }

    public static boolean sendAgentData(StackTrace stackTrace) {
        if (FeatureFlag.featureEnabled(FeatureFlag.HandledExceptions) || FeatureFlag.featureEnabled(FeatureFlag.NativeReporting)) {
            try {
                FlatBufferBuilder flat = DataController.buildAgentDataFromJSError(stackTrace);
                ByteBuffer byteBuffer = flat.dataBuffer().slice();
                byte[] modifiedBytes = new byte[byteBuffer.remaining()];
                byteBuffer.get(modifiedBytes);
                log.audit(DataBuilder.toJsonString(HexAgentDataBundle.getRootAsHexAgentDataBundle(ByteBuffer.wrap(modifiedBytes)), 0));
                boolean reported = AgentDataReporter.reportAgentData(modifiedBytes);
                if (!reported) {
                    log.error("HandledJSError: exception " + stackTrace.getClass().getName() + " failed to record data.");
                }
                return reported;
            }
            catch (Exception error) {
                log.error("HandledJSError: exception " + stackTrace.getClass().getName() + " failed to record data.");
            }
        }
        return false;
    }
}

