/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation.okhttp3;

import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.instrumentation.TransactionState;
import com.newrelic.agent.android.instrumentation.TransactionStateUtil;
import com.newrelic.agent.android.instrumentation.okhttp3.CallExtension;
import com.newrelic.agent.android.instrumentation.okhttp3.OkHttp3TransactionStateUtil;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.measurement.http.HttpTransactionMeasurement;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public class CallbackExtension
implements Callback {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private TransactionState transactionState;
    private Callback impl;
    private CallExtension callExtension;

    public CallbackExtension(Callback impl, TransactionState transactionState, CallExtension callExtension) {
        this.impl = impl;
        this.transactionState = transactionState;
        this.callExtension = callExtension;
    }

    public void onFailure(Call call, IOException e) {
        this.error(e);
        this.impl.onFailure((Call)this.callExtension, e);
    }

    public void onResponse(Call call, Response response) throws IOException {
        response = this.checkResponse(response);
        this.impl.onResponse((Call)this.callExtension, response);
    }

    private Response checkResponse(Response response) {
        if (!this.getTransactionState().isComplete()) {
            log.debug("CallbackExtension.checkResponse() - transaction is not complete.  Inspecting and instrumenting response.");
            response = OkHttp3TransactionStateUtil.inspectAndInstrumentResponse(this.getTransactionState(), response);
        }
        return response;
    }

    protected TransactionState getTransactionState() {
        return this.transactionState;
    }

    protected void error(Exception e) {
        TransactionData transactionData;
        TransactionState transactionState = this.getTransactionState();
        TransactionStateUtil.setErrorCodeFromException(transactionState, e);
        if (!transactionState.isComplete() && (transactionData = transactionState.end()) != null) {
            transactionData.setResponseBody(e.toString());
            TaskQueue.queue(new HttpTransactionMeasurement(transactionData));
        }
    }
}

