/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.measurement;

import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.measurement.Measurement;
import com.newrelic.agent.android.measurement.MeasurementType;
import com.newrelic.agent.android.measurement.consumer.MeasurementConsumer;
import com.newrelic.agent.android.measurement.producer.BaseMeasurementProducer;
import com.newrelic.agent.android.measurement.producer.MeasurementProducer;
import com.newrelic.agent.android.util.ExceptionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;

public class MeasurementPool
extends BaseMeasurementProducer
implements MeasurementConsumer {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private final CopyOnWriteArrayList<MeasurementProducer> producers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MeasurementConsumer> consumers = new CopyOnWriteArrayList();

    public MeasurementPool() {
        super(MeasurementType.Any);
        this.addMeasurementProducer(this);
    }

    public void addMeasurementProducer(MeasurementProducer producer) {
        if (producer != null) {
            if (!this.producers.addIfAbsent(producer)) {
                log.debug("Attempted to add the same MeasurementProducer " + producer + "  multiple times.");
            }
        } else {
            log.debug("Attempted to add null MeasurementProducer.");
        }
    }

    public void removeMeasurementProducer(MeasurementProducer producer) {
        if (!this.producers.remove(producer)) {
            log.debug("Attempted to remove MeasurementProducer " + producer + " which is not registered.");
        }
    }

    public void addMeasurementConsumer(MeasurementConsumer consumer) {
        if (consumer != null) {
            if (!this.consumers.addIfAbsent(consumer)) {
                log.debug("Attempted to add the same MeasurementConsumer " + consumer + " multiple times.");
            }
        } else {
            log.debug("Attempted to add null MeasurementConsumer.");
        }
    }

    public void removeMeasurementConsumer(MeasurementConsumer consumer) {
        if (!this.consumers.remove(consumer)) {
            log.debug("Attempted to remove MeasurementConsumer " + consumer + " which is not registered.");
        }
    }

    public void broadcastMeasurements() {
        ArrayList<Measurement> allProducedMeasurements = new ArrayList<Measurement>();
        for (MeasurementProducer producer : this.producers) {
            Collection<Measurement> measurements = producer.drainMeasurements();
            if (measurements.size() <= 0) continue;
            allProducedMeasurements.addAll(measurements);
            while (allProducedMeasurements.remove(null)) {
            }
        }
        if (allProducedMeasurements.size() > 0) {
            for (MeasurementConsumer consumer : this.consumers) {
                for (Measurement measurement : allProducedMeasurements) {
                    if (consumer.getMeasurementType() != measurement.getType() && consumer.getMeasurementType() != MeasurementType.Any) continue;
                    try {
                        consumer.consumeMeasurement(measurement);
                    }
                    catch (Exception e) {
                        ExceptionHelper.exceptionToErrorCode(e);
                        log.error("broadcastMeasurements exception[" + e.getClass().getName() + "]");
                    }
                }
            }
        }
    }

    @Override
    public void consumeMeasurement(Measurement measurement) {
        this.produceMeasurement(measurement);
    }

    @Override
    public void consumeMeasurements(Collection<Measurement> measurements) {
        this.produceMeasurements(measurements);
    }

    @Override
    public MeasurementType getMeasurementType() {
        return MeasurementType.Any;
    }

    public Collection<MeasurementProducer> getMeasurementProducers() {
        return this.producers;
    }

    public Collection<MeasurementConsumer> getMeasurementConsumers() {
        return this.consumers;
    }
}

