/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.util;

import com.newrelic.agent.android.harvest.AgentHealth;
import com.newrelic.agent.android.harvest.AgentHealthException;
import com.newrelic.agent.android.harvest.type.HarvestErrorCodes;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;

public class ExceptionHelper
implements HarvestErrorCodes {
    private static final AgentLog log = AgentLogManager.getAgentLog();

    public static int exceptionToErrorCode(Exception e) {
        int errorCode = -1;
        log.debug("ExceptionHelper: exception " + e.getClass().getName() + " to error code.");
        if (e instanceof UnknownHostException) {
            errorCode = -1006;
        } else if (e instanceof SocketTimeoutException) {
            errorCode = -1001;
        } else if (e instanceof ConnectException) {
            errorCode = -1004;
        } else if (e instanceof MalformedURLException) {
            errorCode = -1000;
        } else if (e instanceof SSLException) {
            errorCode = -1200;
        } else if (e instanceof FileNotFoundException) {
            errorCode = -1100;
        } else if (e instanceof EOFException) {
            errorCode = -1021;
        } else if (e instanceof IOException) {
            ExceptionHelper.recordSupportabilityMetric(e, "IOException");
        } else if (e instanceof RuntimeException) {
            ExceptionHelper.recordSupportabilityMetric(e, "RuntimeException");
        }
        return errorCode;
    }

    public static void recordSupportabilityMetric(Exception e, String baseExceptionKey) {
        AgentHealthException agentHealthException = new AgentHealthException(e);
        if (agentHealthException.getStackTrace() != null & agentHealthException.getStackTrace().length > 0) {
            StackTraceElement topTraceElement = agentHealthException.getStackTrace()[0];
            log.error(String.format("ExceptionHelper: %s:%s(%s:%s) %s[%s] %s", agentHealthException.getSourceClass(), agentHealthException.getSourceMethod(), topTraceElement.getFileName(), topTraceElement.getLineNumber(), baseExceptionKey, agentHealthException.getExceptionClass(), agentHealthException.getMessage()));
            AgentHealth.noticeException(agentHealthException, baseExceptionKey);
        }
    }
}

