/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.mobile.fbs.models;

import com.newrelic.com.google.flatbuffers.FlatBufferBuilder;
import com.newrelic.com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class InteractionTrace
extends Table {
    public static InteractionTrace getRootAsInteractionTrace(ByteBuffer _bb) {
        return InteractionTrace.getRootAsInteractionTrace(_bb, new InteractionTrace());
    }

    public static InteractionTrace getRootAsInteractionTrace(ByteBuffer _bb, InteractionTrace obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
        this.vtable_start = this.bb_pos - this.bb.getInt(this.bb_pos);
        this.vtable_size = this.bb.getShort(this.vtable_start);
    }

    public InteractionTrace __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public long start() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateStart(long start) {
        int o = this.__offset(4);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, start);
            return true;
        }
        return false;
    }

    public long end() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateEnd(long end) {
        int o = this.__offset(6);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, end);
            return true;
        }
        return false;
    }

    public String name() {
        int o = this.__offset(8);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer nameAsByteBuffer() {
        return this.__vector_as_bytebuffer(8, 1);
    }

    public ByteBuffer nameInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 8, 1);
    }

    public float duration() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getFloat(o + this.bb_pos) : 0.0f;
    }

    public boolean mutateDuration(float duration) {
        int o = this.__offset(10);
        if (o != 0) {
            this.bb.putFloat(o + this.bb_pos, duration);
            return true;
        }
        return false;
    }

    public String protocolVersion() {
        int o = this.__offset(12);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer protocolVersionAsByteBuffer() {
        return this.__vector_as_bytebuffer(12, 1);
    }

    public ByteBuffer protocolVersionInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 12, 1);
    }

    public String content() {
        int o = this.__offset(14);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer contentAsByteBuffer() {
        return this.__vector_as_bytebuffer(14, 1);
    }

    public ByteBuffer contentInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 14, 1);
    }

    public static int createInteractionTrace(FlatBufferBuilder builder, long start, long end, int nameOffset, float duration, int protocolVersionOffset, int contentOffset) {
        builder.startObject(6);
        InteractionTrace.addEnd(builder, end);
        InteractionTrace.addStart(builder, start);
        InteractionTrace.addContent(builder, contentOffset);
        InteractionTrace.addProtocolVersion(builder, protocolVersionOffset);
        InteractionTrace.addDuration(builder, duration);
        InteractionTrace.addName(builder, nameOffset);
        return InteractionTrace.endInteractionTrace(builder);
    }

    public static void startInteractionTrace(FlatBufferBuilder builder) {
        builder.startObject(6);
    }

    public static void addStart(FlatBufferBuilder builder, long start) {
        builder.addLong(0, start, 0L);
    }

    public static void addEnd(FlatBufferBuilder builder, long end) {
        builder.addLong(1, end, 0L);
    }

    public static void addName(FlatBufferBuilder builder, int nameOffset) {
        builder.addOffset(2, nameOffset, 0);
    }

    public static void addDuration(FlatBufferBuilder builder, float duration) {
        builder.addFloat(3, duration, 0.0);
    }

    public static void addProtocolVersion(FlatBufferBuilder builder, int protocolVersionOffset) {
        builder.addOffset(4, protocolVersionOffset, 0);
    }

    public static void addContent(FlatBufferBuilder builder, int contentOffset) {
        builder.addOffset(5, contentOffset, 0);
    }

    public static int endInteractionTrace(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }
}

