/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.harvest.crash;

import com.newrelic.agent.android.harvest.type.HarvestableObject;
import com.newrelic.agent.android.util.SafeJsonPrimitive;
import com.newrelic.com.google.gson.JsonArray;
import com.newrelic.com.google.gson.JsonElement;
import com.newrelic.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ThreadInfo
extends HarvestableObject {
    protected boolean crashed;
    protected long threadId;
    protected String threadName;
    protected int threadPriority;
    protected String state;
    protected StackTraceElement[] stackTrace;

    public ThreadInfo() {
    }

    public ThreadInfo(Throwable throwable) {
        this(Thread.currentThread(), throwable.getStackTrace());
        this.crashed = true;
    }

    public ThreadInfo(Thread thread, StackTraceElement[] stackTrace) {
        this.crashed = false;
        this.threadId = thread.getId();
        this.threadName = thread.getName();
        this.threadPriority = thread.getPriority();
        this.state = thread.getState().toString();
        this.stackTrace = stackTrace;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public List<ThreadInfo> allThreads() {
        ArrayList<ThreadInfo> threads = new ArrayList<ThreadInfo>();
        long crashedThreadId = this.getThreadId();
        threads.add(this);
        for (Map.Entry<Thread, StackTraceElement[]> threadEntry : Thread.getAllStackTraces().entrySet()) {
            Thread thread = threadEntry.getKey();
            StackTraceElement[] threadStackTrace = threadEntry.getValue();
            if (thread.getId() == crashedThreadId) continue;
            threads.add(new ThreadInfo(thread, threadStackTrace));
        }
        return threads;
    }

    public static List<ThreadInfo> extractThreads(Throwable throwable) {
        return new ThreadInfo(throwable).allThreads();
    }

    @Override
    public JsonObject asJsonObject() {
        JsonObject data = new JsonObject();
        data.add("crashed", SafeJsonPrimitive.factory(this.crashed));
        data.add("state", SafeJsonPrimitive.factory(this.state));
        data.add("threadNumber", SafeJsonPrimitive.factory(this.threadId));
        data.add("threadId", SafeJsonPrimitive.factory(this.threadName));
        data.add("priority", SafeJsonPrimitive.factory(this.threadPriority));
        data.add("stack", this.getStackAsJson());
        return data;
    }

    public static ThreadInfo newFromJson(JsonObject jsonObject) {
        ThreadInfo info = new ThreadInfo();
        info.crashed = jsonObject.get("crashed").getAsBoolean();
        info.state = jsonObject.get("state").getAsString();
        info.threadId = jsonObject.get("threadNumber").getAsLong();
        info.threadName = jsonObject.get("threadId").getAsString();
        info.threadPriority = jsonObject.get("priority").getAsInt();
        info.stackTrace = info.stackTraceFromJson(jsonObject.get("stack").getAsJsonArray());
        return info;
    }

    public StackTraceElement[] stackTraceFromJson(JsonArray jsonArray) {
        StackTraceElement[] stack = new StackTraceElement[jsonArray.size()];
        int i = 0;
        for (JsonElement jsonElement : jsonArray) {
            String fileName = "unknown";
            if (jsonElement.getAsJsonObject().get("fileName") != null) {
                fileName = jsonElement.getAsJsonObject().get("fileName").getAsString();
            }
            String className = jsonElement.getAsJsonObject().get("className").getAsString();
            String methodName = jsonElement.getAsJsonObject().get("methodName").getAsString();
            int lineNumber = jsonElement.getAsJsonObject().get("lineNumber").getAsInt();
            StackTraceElement stackTraceElement = new StackTraceElement(className, methodName, fileName, lineNumber);
            stack[i++] = stackTraceElement;
        }
        return stack;
    }

    public List<ThreadInfo> newListFromJson(JsonArray jsonArray) {
        ArrayList<ThreadInfo> list = new ArrayList<ThreadInfo>();
        for (JsonElement jsonElement : jsonArray) {
            list.add(ThreadInfo.newFromJson(jsonElement.getAsJsonObject()));
        }
        return list;
    }

    private JsonArray getStackAsJson() {
        JsonArray data = new JsonArray();
        for (StackTraceElement element : this.stackTrace) {
            JsonObject elementJson = new JsonObject();
            if (element.getFileName() != null) {
                elementJson.add("fileName", SafeJsonPrimitive.factory(element.getFileName()));
            }
            elementJson.add("className", SafeJsonPrimitive.factory(element.getClassName()));
            elementJson.add("methodName", SafeJsonPrimitive.factory(element.getMethodName()));
            elementJson.add("lineNumber", SafeJsonPrimitive.factory(element.getLineNumber()));
            data.add(elementJson);
        }
        return data;
    }
}

