/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.distributedtracing.TraceContext;
import com.newrelic.agent.android.distributedtracing.TraceHeader;
import com.newrelic.agent.android.instrumentation.ReplaceCallSite;
import com.newrelic.agent.android.instrumentation.TransactionState;
import com.newrelic.agent.android.instrumentation.TransactionStateUtil;
import com.newrelic.agent.android.instrumentation.httpclient.ContentBufferingResponseEntityImpl;
import com.newrelic.agent.android.instrumentation.httpclient.HttpRequestEntityImpl;
import com.newrelic.agent.android.instrumentation.httpclient.HttpResponseEntityImpl;
import com.newrelic.agent.android.instrumentation.httpclient.ResponseHandlerImpl;
import com.newrelic.agent.android.instrumentation.io.CountingInputStream;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.measurement.http.HttpTransactionMeasurement;
import com.newrelic.agent.android.tracing.TraceMachine;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.TreeMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.RequestLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

@Deprecated
public final class ApacheInstrumentation {
    protected static final AgentLog log = AgentLogManager.getAgentLog();

    private ApacheInstrumentation() {
    }

    @ReplaceCallSite
    public static HttpResponse execute(HttpClient httpClient, HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        TransactionState transactionState = new TransactionState();
        ApacheInstrumentation.setCrossProcessHeader(request);
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            TransactionStateUtil.setTrace(transactionState);
            ApacheInstrumentation.setDistributedTraceHeaders(transactionState, request);
        }
        try {
            return ApacheInstrumentation.delegate(httpClient.execute(target, ApacheInstrumentation.delegate(target, request, transactionState), context), transactionState);
        }
        catch (IOException e) {
            ApacheInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    @ReplaceCallSite
    public static <T> T execute(HttpClient httpClient, HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        TransactionState transactionState = new TransactionState();
        ApacheInstrumentation.setCrossProcessHeader(request);
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            TransactionStateUtil.setTrace(transactionState);
            ApacheInstrumentation.setDistributedTraceHeaders(transactionState, request);
        }
        try {
            return (T)httpClient.execute(target, ApacheInstrumentation.delegate(target, request, transactionState), ApacheInstrumentation.delegate(responseHandler, transactionState), context);
        }
        catch (ClientProtocolException e) {
            ApacheInstrumentation.httpClientError(transactionState, (Exception)((Object)e));
            throw e;
        }
        catch (IOException e) {
            ApacheInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    @ReplaceCallSite
    public static <T> T execute(HttpClient httpClient, HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        TransactionState transactionState = new TransactionState();
        ApacheInstrumentation.setCrossProcessHeader(request);
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            TransactionStateUtil.setTrace(transactionState);
            ApacheInstrumentation.setDistributedTraceHeaders(transactionState, request);
        }
        try {
            return (T)httpClient.execute(target, ApacheInstrumentation.delegate(target, request, transactionState), ApacheInstrumentation.delegate(responseHandler, transactionState));
        }
        catch (ClientProtocolException e) {
            ApacheInstrumentation.httpClientError(transactionState, (Exception)((Object)e));
            throw e;
        }
        catch (IOException e) {
            ApacheInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    @ReplaceCallSite
    public static HttpResponse execute(HttpClient httpClient, HttpHost target, HttpRequest request) throws IOException {
        TransactionState transactionState = new TransactionState();
        ApacheInstrumentation.setCrossProcessHeader(request);
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            TransactionStateUtil.setTrace(transactionState);
            ApacheInstrumentation.setDistributedTraceHeaders(transactionState, request);
        }
        try {
            return ApacheInstrumentation.delegate(httpClient.execute(target, ApacheInstrumentation.delegate(target, request, transactionState)), transactionState);
        }
        catch (IOException e) {
            ApacheInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    @ReplaceCallSite
    public static HttpResponse execute(HttpClient httpClient, HttpUriRequest request, HttpContext context) throws IOException {
        TransactionState transactionState = new TransactionState();
        ApacheInstrumentation.setCrossProcessHeader((HttpRequest)request);
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            TransactionStateUtil.setTrace(transactionState);
            ApacheInstrumentation.setDistributedTraceHeaders(transactionState, (HttpRequest)request);
        }
        try {
            return ApacheInstrumentation.delegate(httpClient.execute(ApacheInstrumentation.delegate(request, transactionState), context), transactionState);
        }
        catch (IOException e) {
            ApacheInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    @ReplaceCallSite
    public static <T> T execute(HttpClient httpClient, HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        TransactionState transactionState = new TransactionState();
        ApacheInstrumentation.setCrossProcessHeader((HttpRequest)request);
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            TransactionStateUtil.setTrace(transactionState);
            ApacheInstrumentation.setDistributedTraceHeaders(transactionState, (HttpRequest)request);
        }
        try {
            return (T)httpClient.execute(ApacheInstrumentation.delegate(request, transactionState), ApacheInstrumentation.delegate(responseHandler, transactionState), context);
        }
        catch (ClientProtocolException e) {
            ApacheInstrumentation.httpClientError(transactionState, (Exception)((Object)e));
            throw e;
        }
        catch (IOException e) {
            ApacheInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    @ReplaceCallSite
    public static <T> T execute(HttpClient httpClient, HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        TransactionState transactionState = new TransactionState();
        ApacheInstrumentation.setCrossProcessHeader((HttpRequest)request);
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            TransactionStateUtil.setTrace(transactionState);
            ApacheInstrumentation.setDistributedTraceHeaders(transactionState, (HttpRequest)request);
        }
        try {
            return (T)httpClient.execute(ApacheInstrumentation.delegate(request, transactionState), ApacheInstrumentation.delegate(responseHandler, transactionState));
        }
        catch (ClientProtocolException e) {
            ApacheInstrumentation.httpClientError(transactionState, (Exception)((Object)e));
            throw e;
        }
        catch (IOException e) {
            ApacheInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    @ReplaceCallSite
    public static HttpResponse execute(HttpClient httpClient, HttpUriRequest request) throws IOException {
        TransactionState transactionState = new TransactionState();
        ApacheInstrumentation.setCrossProcessHeader((HttpRequest)request);
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            TransactionStateUtil.setTrace(transactionState);
            ApacheInstrumentation.setDistributedTraceHeaders(transactionState, (HttpRequest)request);
        }
        try {
            return ApacheInstrumentation.delegate(httpClient.execute(ApacheInstrumentation.delegate(request, transactionState)), transactionState);
        }
        catch (IOException e) {
            ApacheInstrumentation.httpClientError(transactionState, e);
            throw e;
        }
    }

    protected static void httpClientError(TransactionState transactionState, Exception e) {
        if (!transactionState.isComplete()) {
            TransactionStateUtil.setErrorCodeFromException(transactionState, e);
            TransactionData transactionData = transactionState.end();
            if (transactionData != null) {
                transactionData.setResponseBody(e.toString());
                TaskQueue.queue(new HttpTransactionMeasurement(transactionData));
            }
        }
    }

    private static HttpUriRequest delegate(HttpUriRequest request, TransactionState transactionState) {
        return ApacheInstrumentation.inspectAndInstrument(transactionState, request);
    }

    private static HttpRequest delegate(HttpHost host, HttpRequest request, TransactionState transactionState) {
        return ApacheInstrumentation.inspectAndInstrument(transactionState, host, request);
    }

    private static HttpResponse delegate(HttpResponse response, TransactionState transactionState) {
        return ApacheInstrumentation.inspectAndInstrument(transactionState, response);
    }

    private static <T> ResponseHandler<? extends T> delegate(ResponseHandler<? extends T> handler, TransactionState transactionState) {
        return ResponseHandlerImpl.wrap(handler, transactionState);
    }

    private static void setCrossProcessHeader(HttpRequest request) {
        String crossProcessId = Agent.getCrossProcessId();
        if (crossProcessId != null) {
            TraceMachine.setCurrentTraceParam("cross_process_data", crossProcessId);
            request.setHeader("X-NewRelic-ID", crossProcessId);
        }
    }

    static void setDistributedTraceHeaders(TransactionState transactionState, HttpRequest request) {
        if (transactionState.getTrace() != null) {
            try {
                TraceContext traceContext = transactionState.getTrace();
                if (traceContext != null) {
                    for (TraceHeader traceHeader : traceContext.getHeaders()) {
                        request.setHeader(traceHeader.getHeaderName(), traceHeader.getHeaderValue());
                    }
                    TraceContext.reportSupportabilityMetrics();
                }
            }
            catch (Exception e) {
                log.error("setDistributedTraceHeaders: Unable to add trace headers. ", e);
                TraceContext.reportSupportabilityExceptionMetric(e);
            }
        }
    }

    static void setDistributedTraceHeaders(TransactionState transactionState, HttpResponse response) {
        if (transactionState.getTrace() != null) {
            try {
                TraceContext traceContext = transactionState.getTrace();
                if (traceContext != null) {
                    for (TraceHeader traceHeader : traceContext.getHeaders()) {
                        if (response.containsHeader(traceHeader.getHeaderName())) continue;
                        response.setHeader(traceHeader.getHeaderName(), traceHeader.getHeaderValue());
                    }
                }
            }
            catch (Exception e) {
                log.error("setDistributedTraceHeaders: Unable to add trace headers. ", e);
                TraceContext.reportSupportabilityExceptionMetric(e);
            }
        }
    }

    public static HttpRequest inspectAndInstrument(TransactionState transactionState, HttpHost host, HttpRequest request) {
        String url = null;
        RequestLine requestLine = request.getRequestLine();
        if (requestLine != null) {
            boolean isAbsoluteUri;
            String uri = requestLine.getUri();
            boolean bl = isAbsoluteUri = uri != null && uri.length() >= 10 && uri.substring(0, 10).indexOf("://") >= 0;
            if (!isAbsoluteUri && uri != null && host != null) {
                String prefix = host.toURI();
                url = prefix + (prefix.endsWith("/") || uri.startsWith("/") ? "" : "/") + uri;
            } else if (isAbsoluteUri) {
                url = uri;
            }
            TransactionStateUtil.inspectAndInstrument(transactionState, url, requestLine.getMethod());
        }
        ApacheInstrumentation.setCrossProcessHeader(request);
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            TransactionStateUtil.setTrace(transactionState);
            ApacheInstrumentation.setDistributedTraceHeaders(transactionState, request);
        }
        if (transactionState.getUrl() == null || transactionState.getHttpMethod() == null) {
            try {
                throw new Exception("TransactionData constructor was not provided with a valid URL, host or HTTP method");
            }
            catch (Exception e) {
                log.error(MessageFormat.format("TransactionStateUtil.inspectAndInstrument(...) for {0} could not determine request URL or HTTP method [host={1}, requestLine={2}]", request.getClass().getCanonicalName(), host, requestLine), e);
                return request;
            }
        }
        ApacheInstrumentation.wrapRequestEntity(transactionState, request);
        return request;
    }

    public static HttpUriRequest inspectAndInstrument(TransactionState transactionState, HttpUriRequest request) {
        ApacheInstrumentation.setCrossProcessHeader((HttpRequest)request);
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            TransactionStateUtil.setTrace(transactionState);
            ApacheInstrumentation.setDistributedTraceHeaders(transactionState, (HttpRequest)request);
        }
        TransactionStateUtil.inspectAndInstrument(transactionState, request.getURI().toString(), request.getMethod());
        ApacheInstrumentation.wrapRequestEntity(transactionState, (HttpRequest)request);
        return request;
    }

    private static void wrapRequestEntity(TransactionState transactionState, HttpRequest request) {
        HttpEntityEnclosingRequest entityEnclosingRequest;
        if (request instanceof HttpEntityEnclosingRequest && (entityEnclosingRequest = (HttpEntityEnclosingRequest)request).getEntity() != null) {
            entityEnclosingRequest.setEntity((HttpEntity)new HttpRequestEntityImpl(entityEnclosingRequest.getEntity(), transactionState));
        }
    }

    public static HttpResponse inspectAndInstrument(TransactionState transactionState, HttpResponse response) {
        transactionState.setStatusCode(response.getStatusLine().getStatusCode());
        Header[] appDataHeader = response.getHeaders("X-NewRelic-App-Data");
        if (appDataHeader != null && appDataHeader.length > 0 && !"".equals(appDataHeader[0].getValue())) {
            transactionState.setAppData(appDataHeader[0].getValue());
        }
        Header[] contentLengthHeader = response.getHeaders("Content-Length");
        long contentLengthFromHeader = -1L;
        if (contentLengthHeader != null && contentLengthHeader.length > 0) {
            try {
                contentLengthFromHeader = Long.parseLong(contentLengthHeader[0].getValue());
                transactionState.setBytesReceived(contentLengthFromHeader);
                ApacheInstrumentation.addTransactionAndErrorData(transactionState, response);
            }
            catch (NumberFormatException e) {
                log.warn("Failed to parse content length: " + e);
            }
        } else if (response.getEntity() != null) {
            response.setEntity((HttpEntity)new HttpResponseEntityImpl(response.getEntity(), transactionState, contentLengthFromHeader));
        } else {
            transactionState.setBytesReceived(0L);
            ApacheInstrumentation.addTransactionAndErrorData(transactionState, null);
        }
        ApacheInstrumentation.setDistributedTraceHeaders(transactionState, response);
        return response;
    }

    protected static void addTransactionAndErrorData(TransactionState transactionState, HttpResponse response) {
        TransactionData transactionData = transactionState.end();
        if (transactionData == null) {
            return;
        }
        if (transactionState.isErrorOrFailure()) {
            String responseBody = "";
            TreeMap<String, String> params = new TreeMap<String, String>();
            if (response != null) {
                try {
                    if (response.getEntity() != null) {
                        InputStream content;
                        if (!(response.getEntity() instanceof HttpRequestEntityImpl)) {
                            response.setEntity((HttpEntity)new ContentBufferingResponseEntityImpl(response.getEntity()));
                        }
                        if ((content = response.getEntity().getContent()) instanceof CountingInputStream) {
                            responseBody = ((CountingInputStream)content).getBufferAsString();
                        } else {
                            log.error("Unable to wrap content stream for entity");
                        }
                    } else {
                        log.debug("null response entity. response-body will be reported empty");
                    }
                }
                catch (IllegalStateException e) {
                    log.error(e.toString());
                }
                catch (IOException e) {
                    log.error(e.toString());
                }
                Header[] contentTypeHeader = response.getHeaders("Content-Type");
                String contentType = null;
                if (contentTypeHeader != null && contentTypeHeader.length > 0 && !"".equals(contentTypeHeader[0].getValue())) {
                    contentType = contentTypeHeader[0].getValue();
                }
                if (contentType != null && contentType.length() > 0) {
                    params.put("content_type", contentType);
                }
            }
            params.put("content_length", transactionState.getBytesReceived() + "");
            transactionData.setResponseBody(responseBody);
            transactionData.setParams(params);
        }
        TaskQueue.queue(new HttpTransactionMeasurement(transactionData));
    }
}

