/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation.io;

import com.newrelic.agent.android.instrumentation.io.StreamCompleteEvent;
import com.newrelic.agent.android.instrumentation.io.StreamCompleteListener;
import java.util.ArrayList;
import java.util.List;

class StreamCompleteListenerManager {
    private boolean streamComplete = false;
    private ArrayList<StreamCompleteListener> streamCompleteListeners = new ArrayList();

    StreamCompleteListenerManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isComplete() {
        StreamCompleteListenerManager streamCompleteListenerManager = this;
        synchronized (streamCompleteListenerManager) {
            return this.streamComplete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStreamCompleteListener(StreamCompleteListener streamCompleteListener) {
        ArrayList<StreamCompleteListener> arrayList = this.streamCompleteListeners;
        synchronized (arrayList) {
            this.streamCompleteListeners.add(streamCompleteListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStreamCompleteListener(StreamCompleteListener streamCompleteListener) {
        ArrayList<StreamCompleteListener> arrayList = this.streamCompleteListeners;
        synchronized (arrayList) {
            this.streamCompleteListeners.remove(streamCompleteListener);
        }
    }

    public void notifyStreamComplete(StreamCompleteEvent ev) {
        if (!this.checkComplete()) {
            for (StreamCompleteListener listener : this.getStreamCompleteListeners()) {
                listener.streamComplete(ev);
            }
        }
    }

    public void notifyStreamError(StreamCompleteEvent ev) {
        if (!this.checkComplete()) {
            for (StreamCompleteListener listener : this.getStreamCompleteListeners()) {
                listener.streamError(ev);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkComplete() {
        boolean streamComplete;
        StreamCompleteListenerManager streamCompleteListenerManager = this;
        synchronized (streamCompleteListenerManager) {
            streamComplete = this.isComplete();
            if (!streamComplete) {
                this.streamComplete = true;
            }
        }
        return streamComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StreamCompleteListener> getStreamCompleteListeners() {
        ArrayList<StreamCompleteListener> listeners;
        ArrayList<StreamCompleteListener> arrayList = this.streamCompleteListeners;
        synchronized (arrayList) {
            listeners = new ArrayList<StreamCompleteListener>(this.streamCompleteListeners);
            this.streamCompleteListeners.clear();
        }
        return listeners;
    }
}

