/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation.okhttp3;

import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.io.IOException;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.Sink;

public class ResponseBuilderExtension
extends Response.Builder {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    static final String CACHED_RESPONSE_CLASS = "okhttp3.Cache$CacheResponseBody";
    private Response.Builder impl;

    public ResponseBuilderExtension(Response.Builder impl) {
        this.impl = impl;
    }

    public Response.Builder request(Request request) {
        return this.impl.request(request);
    }

    public Response.Builder protocol(Protocol protocol) {
        return this.impl.protocol(protocol);
    }

    public Response.Builder code(int code) {
        return this.impl.code(code);
    }

    public Response.Builder message(String message) {
        return this.impl.message(message);
    }

    public Response.Builder handshake(Handshake handshake) {
        return this.impl.handshake(handshake);
    }

    public Response.Builder header(String name, String value) {
        return this.impl.header(name, value);
    }

    public Response.Builder addHeader(String name, String value) {
        return this.impl.addHeader(name, value);
    }

    public Response.Builder removeHeader(String name) {
        return this.impl.removeHeader(name);
    }

    public Response.Builder headers(Headers headers) {
        return this.impl.headers(headers);
    }

    public Response.Builder body(ResponseBody body) {
        try {
            if (body != null && !body.getClass().getName().equalsIgnoreCase(CACHED_RESPONSE_CLASS)) {
                BufferedSource source = body.source();
                Buffer buffer = new Buffer();
                source.readAll((Sink)buffer);
                return this.impl.body(ResponseBody.create((MediaType)body.contentType(), (long)buffer.size(), (BufferedSource)buffer));
            }
        }
        catch (IOException e) {
            log.error("IOException reading from source: ", e);
        }
        catch (IllegalStateException ex) {
            log.error("IllegalStateException reading from source: ", ex);
        }
        return this.impl.body(body);
    }

    public Response.Builder networkResponse(Response networkResponse) {
        return this.impl.networkResponse(networkResponse);
    }

    public Response.Builder cacheResponse(Response cacheResponse) {
        return this.impl.cacheResponse(cacheResponse);
    }

    public Response.Builder priorResponse(Response priorResponse) {
        return this.impl.priorResponse(priorResponse);
    }

    public Response build() {
        return this.impl.build();
    }
}

