/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.measurement.http;

import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.distributedtracing.TraceContext;
import com.newrelic.agent.android.measurement.BaseMeasurement;
import com.newrelic.agent.android.measurement.MeasurementType;
import com.newrelic.agent.android.tracing.TraceMachine;
import com.newrelic.agent.android.util.Util;
import java.util.Map;

public class HttpTransactionMeasurement
extends BaseMeasurement {
    private String url;
    private String httpMethod;
    private double totalTime;
    private int statusCode;
    private int errorCode;
    private long bytesSent;
    private long bytesReceived;
    private String appData;
    private String responseBody;
    private Map<String, String> params;
    private TraceContext traceContext;

    public HttpTransactionMeasurement(String url, String httpMethod, int statusCode, int errorCode, long startTime, double totalTime, long bytesSent, long bytesReceived, String appData) {
        super(MeasurementType.Network);
        url = Util.sanitizeUrl(url);
        this.setName(url);
        this.setScope(TraceMachine.getCurrentScope());
        this.setStartTime(startTime);
        this.setEndTime(startTime + (long)((int)totalTime));
        this.setExclusiveTime((int)(totalTime * 1000.0));
        this.url = url;
        this.httpMethod = httpMethod;
        this.statusCode = statusCode;
        this.bytesSent = bytesSent;
        this.bytesReceived = bytesReceived;
        this.totalTime = totalTime;
        this.appData = appData;
        this.errorCode = errorCode;
        this.responseBody = null;
        this.params = null;
        this.traceContext = null;
    }

    public HttpTransactionMeasurement(TransactionData transactionData) {
        this(transactionData.getUrl(), transactionData.getHttpMethod(), transactionData.getStatusCode(), transactionData.getErrorCode(), transactionData.getTimestamp(), transactionData.getTime(), transactionData.getBytesSent(), transactionData.getBytesReceived(), transactionData.getAppData());
        this.responseBody = transactionData.getResponseBody();
        this.params = transactionData.getParams();
        this.traceContext = transactionData.getTraceContext();
    }

    @Override
    public double asDouble() {
        return this.totalTime;
    }

    public String getUrl() {
        return this.url;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public double getTotalTime() {
        return this.totalTime;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public String getAppData() {
        return this.appData;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public TraceContext getTraceContext() {
        return this.traceContext;
    }

    @Override
    public String toString() {
        return "HttpTransactionMeasurement{url='" + this.url + '\'' + ", httpMethod='" + this.httpMethod + '\'' + ", totalTime=" + this.totalTime + ", statusCode=" + this.statusCode + ", errorCode=" + this.errorCode + ", bytesSent=" + this.bytesSent + ", bytesReceived=" + this.bytesReceived + ", appData='" + this.appData + '\'' + ", responseBody='" + this.responseBody + '\'' + ", params='" + this.params + '\'' + '}';
    }
}

