/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android;

import com.newrelic.agent.android.stats.StatsEngine;
import java.util.HashSet;
import java.util.Set;

public enum FeatureFlag {
    HttpResponseBodyCapture,
    CrashReporting,
    AnalyticsEvents,
    InteractionTracing,
    DefaultInteractions,
    NetworkRequests,
    NetworkErrorRequests,
    HandledExceptions,
    DistributedTracing,
    NativeReporting;

    private static final Set<FeatureFlag> enabledFeatures;
    private static boolean instrumentFeature;

    public static void enableFeature(FeatureFlag featureFlag) {
        enabledFeatures.add(featureFlag);
        StatsEngine.get().inc("Supportability/AgentHealth/Feature/Enable/" + featureFlag.name());
    }

    public static void disableFeature(FeatureFlag featureFlag) {
        enabledFeatures.remove((Object)featureFlag);
        if (instrumentFeature) {
            StatsEngine.get().inc("Supportability/AgentHealth/Feature/Disable/" + featureFlag.name());
        }
    }

    public static boolean featureEnabled(FeatureFlag featureFlag) {
        return enabledFeatures.contains((Object)featureFlag);
    }

    public static void resetFeatures() {
        enabledFeatures.clear();
        instrumentFeature = false;
        FeatureFlag.enableFeature(HttpResponseBodyCapture);
        FeatureFlag.enableFeature(CrashReporting);
        FeatureFlag.enableFeature(AnalyticsEvents);
        FeatureFlag.enableFeature(InteractionTracing);
        FeatureFlag.enableFeature(DefaultInteractions);
        FeatureFlag.enableFeature(NetworkRequests);
        FeatureFlag.enableFeature(NetworkErrorRequests);
        FeatureFlag.enableFeature(HandledExceptions);
        FeatureFlag.enableFeature(DistributedTracing);
        instrumentFeature = true;
    }

    static {
        enabledFeatures = new HashSet<FeatureFlag>();
        instrumentFeature = false;
        FeatureFlag.resetFeatures();
    }
}

