/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.harvest;

import com.newrelic.agent.android.harvest.ConnectInformation;
import com.newrelic.agent.android.harvest.HarvestResponse;
import com.newrelic.agent.android.harvest.type.HarvestErrorCodes;
import com.newrelic.agent.android.harvest.type.Harvestable;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.stats.TicToc;
import com.newrelic.agent.android.util.Deflator;
import com.newrelic.agent.android.util.ExceptionHelper;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

public class HarvestConnection
implements HarvestErrorCodes {
    private final AgentLog log = AgentLogManager.getAgentLog();
    private static final String COLLECTOR_CONNECT_URI = "/mobile/v4/connect";
    private static final String COLLECTOR_DATA_URI = "/mobile/v3/data";
    private static final int TIMEOUT_IN_SECONDS = 20;
    private static final int READ_TIMEOUT_IN_SECONDS = 4;
    private static final int CONNECTION_TIMEOUT = (int)TimeUnit.MILLISECONDS.convert(20L, TimeUnit.SECONDS);
    private static final int READ_TIMEOUT = (int)TimeUnit.MILLISECONDS.convert(4L, TimeUnit.SECONDS);
    private static final int RESPONSE_BUFFER_SIZE = 8192;
    private static final int MAX_PLAINTEXT_MESSAGE_SIZE = 512;
    private String collectorHost;
    private String applicationToken;
    private long serverTimestamp;
    private ConnectInformation connectInformation;
    private boolean useSsl = true;

    public HttpURLConnection createPost(String uri) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(uri);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(CONNECTION_TIMEOUT);
            connection.setReadTimeout(READ_TIMEOUT);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestProperty("X-App-License-Key", this.applicationToken);
            connection.setRequestProperty("Content-Type", "application/json");
            String userAgent = System.getProperty("http.agent");
            if (userAgent != null && userAgent.length() > 0) {
                connection.setRequestProperty("User-Agent", userAgent);
            }
            if (this.serverTimestamp != 0L) {
                connection.setRequestProperty("X-NewRelic-Connect-Time", Long.valueOf(this.serverTimestamp).toString());
            }
        }
        catch (Exception e) {
            StatsEngine.get().inc("Supportability/AgentHealth/Collector/connection/errors");
            this.log.error("Failed to create data POST: " + e.getMessage());
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HarvestResponse send(HttpURLConnection connection, String message) {
        HarvestResponse harvestResponse = new HarvestResponse();
        String contentEncoding = message.length() <= 512 ? "identity" : "deflate";
        try {
            TicToc timer = new TicToc();
            timer.tic();
            ByteBuffer byteBuffer = "deflate".equals(contentEncoding.toLowerCase()) ? ByteBuffer.wrap(Deflator.deflate(message.getBytes())) : ByteBuffer.wrap(message.getBytes());
            connection.setFixedLengthStreamingMode(byteBuffer.array().length);
            connection.setRequestProperty("Content-Encoding", contentEncoding);
            try (BufferedOutputStream out = new BufferedOutputStream(connection.getOutputStream());){
                out.write(byteBuffer.array());
            }
            harvestResponse.setResponseTime(timer.toc());
            harvestResponse.setStatusCode(connection.getResponseCode());
            harvestResponse.setResponseBody(this.readResponse(connection));
        }
        catch (IOException e) {
            this.log.error("Failed to retrieve collector response: " + e.getMessage());
            this.recordCollectorError(e);
        }
        catch (Exception e) {
            this.log.error("Failed to send POST to collector: " + e.getMessage());
            this.recordCollectorError(e);
            HarvestResponse harvestResponse2 = null;
            return harvestResponse2;
        }
        finally {
            connection.disconnect();
        }
        return harvestResponse;
    }

    public HarvestResponse sendConnect() {
        if (this.connectInformation == null) {
            throw new IllegalArgumentException();
        }
        HttpURLConnection connectPost = this.createConnectPost();
        if (connectPost == null) {
            this.log.error("Failed to create connect POST");
            return null;
        }
        TicToc timer = new TicToc();
        timer.tic();
        HarvestResponse response = this.send(connectPost, this.connectInformation.toJsonString());
        StatsEngine.get().sampleTimeMs("Supportability/AgentHealth/Collector/Connect", timer.toc());
        return response;
    }

    public HarvestResponse sendData(Harvestable harvestable) {
        if (harvestable == null) {
            throw new IllegalArgumentException();
        }
        HttpURLConnection dataPost = this.createDataPost();
        if (dataPost == null) {
            this.log.error("Failed to create data POST");
            return null;
        }
        return this.send(dataPost, harvestable.toJsonString());
    }

    public HttpURLConnection createConnectPost() {
        return this.createPost(this.getCollectorConnectUri());
    }

    public HttpURLConnection createDataPost() {
        return this.createPost(this.getCollectorDataUri());
    }

    String readStream(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (in != null) {
            char[] buf = new char[8192];
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                int n;
                while ((n = reader.read(buf)) >= 0) {
                    sb.append(buf, 0, n);
                }
            }
        }
        return sb.toString();
    }

    public String readResponse(HttpURLConnection response) throws IOException {
        try {
            return this.readStream(response.getInputStream());
        }
        catch (IOException e) {
            return this.readStream(response.getErrorStream());
        }
    }

    private void recordCollectorError(Exception e) {
        this.log.error("HarvestConnection: Attempting to convert network exception " + e.getClass().getName() + " to error code.");
        StatsEngine.get().inc("Supportability/AgentHealth/Collector/ResponseErrorCodes/" + ExceptionHelper.exceptionToErrorCode(e));
    }

    private String getCollectorUri(String resource) {
        String protocol = "https://";
        return protocol + this.collectorHost + resource;
    }

    private String getCollectorConnectUri() {
        return this.getCollectorUri(COLLECTOR_CONNECT_URI);
    }

    private String getCollectorDataUri() {
        return this.getCollectorUri(COLLECTOR_DATA_URI);
    }

    public void setServerTimestamp(long serverTimestamp) {
        this.log.debug("Setting server timestamp: " + serverTimestamp);
        this.serverTimestamp = serverTimestamp;
    }

    public void useSsl(boolean useSsl) {
        if (!useSsl) {
            this.log.error("Unencrypted http requests are no longer supported");
        }
        this.useSsl = true;
    }

    public void setApplicationToken(String applicationToken) {
        this.applicationToken = applicationToken;
    }

    public void setCollectorHost(String collectorHost) {
        this.collectorHost = collectorHost;
    }

    public void setConnectInformation(ConnectInformation connectInformation) {
        this.connectInformation = connectInformation;
    }
}

