/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.logging;

import android.util.Log;
import com.newrelic.agent.android.logging.AgentLog;

public class AndroidAgentLog
implements AgentLog {
    private static final String TAG = "com.newrelic.android";
    private int level = 3;

    @Override
    public void audit(String message) {
        if (this.level == 6) {
            Log.d((String)TAG, (String)message);
        }
    }

    @Override
    public void debug(String message) {
        if (this.level >= 5) {
            Log.d((String)TAG, (String)message);
        }
    }

    @Override
    public void verbose(String message) {
        if (this.level >= 4) {
            Log.v((String)TAG, (String)message);
        }
    }

    @Override
    public void info(String message) {
        if (this.level >= 3) {
            Log.i((String)TAG, (String)message);
        }
    }

    @Override
    public void warning(String message) {
        if (this.level >= 2) {
            Log.w((String)TAG, (String)message);
        }
    }

    @Override
    public void error(String message) {
        if (this.level >= 1) {
            Log.e((String)TAG, (String)message);
        }
    }

    @Override
    public void error(String message, Throwable cause) {
        if (this.level >= 1) {
            Log.e((String)TAG, (String)message, (Throwable)cause);
        }
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        if (level > 6 || level < 1) {
            throw new IllegalArgumentException("Log level is not between ERROR and AUDIT");
        }
        this.level = level;
    }
}

