/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.analytics;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.analytics.AnalyticsAttribute;
import com.newrelic.agent.android.analytics.AnalyticsEvent;
import com.newrelic.agent.android.analytics.AnalyticsEventCategory;
import com.newrelic.agent.android.analytics.NetworkRequestEvent;
import com.newrelic.agent.android.harvest.HttpTransaction;
import java.util.Set;

public class NetworkRequestErrorEvent
extends AnalyticsEvent {
    static final String DISABLE_FF_RESPONSE = "NEWRELIC_RESPONSE_BODY_CAPTURE_DISABLED";

    static Set<AnalyticsAttribute> createErrorAttributeSet(HttpTransaction httpTransaction) {
        String contentType;
        Set<AnalyticsAttribute> attributes = NetworkRequestEvent.createDefaultAttributeSet(httpTransaction);
        if (FeatureFlag.featureEnabled(FeatureFlag.HttpResponseBodyCapture)) {
            String responseBody = httpTransaction.getResponseBody();
            if (responseBody != null && !responseBody.isEmpty()) {
                String encodedResponseBody;
                if (responseBody.length() > 4096) {
                    log.warning("NetworkRequestErrorEvent: truncating response body to 4096 bytes");
                    responseBody = responseBody.substring(0, 4096);
                }
                if ((encodedResponseBody = Agent.getEncoder().encodeNoWrap(responseBody.getBytes())) != null && !encodedResponseBody.isEmpty()) {
                    attributes.add(new AnalyticsAttribute("nr.responseBody", encodedResponseBody));
                }
            }
        } else {
            attributes.add(new AnalyticsAttribute("nr.responseBody", DISABLE_FF_RESPONSE));
        }
        String appData = httpTransaction.getAppData();
        if (appData != null && !appData.isEmpty()) {
            attributes.add(new AnalyticsAttribute("nr.X-NewRelic-App-Data", appData));
        }
        if (httpTransaction.getParams() != null && (contentType = httpTransaction.getParams().get("content_type")) != null && !contentType.isEmpty()) {
            attributes.add(new AnalyticsAttribute("contentType", contentType));
        }
        return attributes;
    }

    public NetworkRequestErrorEvent(Set<AnalyticsAttribute> attributeSet) {
        super(null, AnalyticsEventCategory.RequestError, "MobileRequestError", attributeSet);
    }

    public static NetworkRequestErrorEvent createHttpErrorEvent(HttpTransaction httpTransaction) {
        Set<AnalyticsAttribute> attributes = NetworkRequestErrorEvent.createErrorAttributeSet(httpTransaction);
        attributes.add(new AnalyticsAttribute("statusCode", httpTransaction.getStatusCode()));
        return new NetworkRequestErrorEvent(attributes);
    }

    public static NetworkRequestErrorEvent createNetworkFailureEvent(HttpTransaction httpTransaction) {
        Set<AnalyticsAttribute> attributes = NetworkRequestErrorEvent.createErrorAttributeSet(httpTransaction);
        attributes.add(new AnalyticsAttribute("networkErrorCode", httpTransaction.getErrorCode()));
        return new NetworkRequestErrorEvent(attributes);
    }
}

