/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation.io;

import com.newrelic.agent.android.instrumentation.io.StreamCompleteEvent;
import com.newrelic.agent.android.instrumentation.io.StreamCompleteListener;
import com.newrelic.agent.android.instrumentation.io.StreamCompleteListenerManager;
import com.newrelic.agent.android.instrumentation.io.StreamCompleteListenerSource;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends OutputStream
implements StreamCompleteListenerSource {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private final OutputStream impl;
    private long count = 0L;
    private final StreamCompleteListenerManager listenerManager = new StreamCompleteListenerManager();

    public CountingOutputStream(OutputStream impl) throws IOException {
        if (impl == null) {
            throw new IOException("CountingOutputStream: output stream cannot be null");
        }
        this.impl = impl;
    }

    @Override
    public void addStreamCompleteListener(StreamCompleteListener streamCompleteListener) {
        this.listenerManager.addStreamCompleteListener(streamCompleteListener);
    }

    @Override
    public void removeStreamCompleteListener(StreamCompleteListener streamCompleteListener) {
        this.listenerManager.removeStreamCompleteListener(streamCompleteListener);
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public void write(int oneByte) throws IOException {
        try {
            this.impl.write(oneByte);
            ++this.count;
        }
        catch (IOException e) {
            this.notifyStreamError(e);
            throw e;
        }
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        try {
            this.impl.write(buffer);
            this.count += (long)buffer.length;
        }
        catch (IOException e) {
            this.notifyStreamError(e);
            throw e;
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int count) throws IOException {
        try {
            this.impl.write(buffer, offset, count);
            this.count += (long)count;
        }
        catch (IOException e) {
            this.notifyStreamError(e);
            throw e;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.impl.flush();
        }
        catch (IOException e) {
            this.notifyStreamError(e);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.impl.close();
            this.notifyStreamComplete();
        }
        catch (IOException e) {
            this.notifyStreamError(e);
            throw e;
        }
        catch (Exception e) {
            log.warning(e.toString());
        }
    }

    private void notifyStreamComplete() {
        if (!this.listenerManager.isComplete()) {
            this.listenerManager.notifyStreamComplete(new StreamCompleteEvent(this, this.count));
        }
    }

    private void notifyStreamError(Exception e) {
        if (!this.listenerManager.isComplete()) {
            this.listenerManager.notifyStreamError(new StreamCompleteEvent(this, this.count, e));
        }
    }
}

