/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.ndk;

import android.content.Context;
import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.agentdata.AgentDataController;
import com.newrelic.agent.android.analytics.AnalyticsControllerImpl;
import com.newrelic.agent.android.crash.Crash;
import com.newrelic.agent.android.crash.CrashReporter;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.HarvestAdapter;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.ndk.AgentNDK;
import com.newrelic.agent.android.ndk.AgentNDKListener;
import com.newrelic.agent.android.ndk.NativeCrash;
import com.newrelic.agent.android.ndk.NativeException;
import com.newrelic.agent.android.stats.StatsEngine;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class NativeReporting
extends HarvestAdapter
implements AgentNDKListener {
    protected static final AgentLog log = AgentLogManager.getAgentLog();
    protected static AtomicReference<NativeReporting> instance = new AtomicReference<Object>(null);

    public static NativeReporting getInstance() {
        return instance.get();
    }

    public static NativeReporting initialize(Context context, AgentConfiguration agentConfiguration) {
        instance.compareAndSet(null, new NativeReporting(context, agentConfiguration));
        Harvest.addHarvestListener(instance.get());
        StatsEngine.get().inc("Supportability/Mobile/Android/NDK/Init");
        return instance.get();
    }

    public static void shutdown() {
        if (NativeReporting.isInitialized()) {
            Harvest.removeHarvestListener(instance.get());
            instance.get().stop();
        }
        instance.set(null);
    }

    public static boolean isInitialized() {
        return instance.get() != null && AgentNDK.getInstance() != null;
    }

    public static void crashNow(String message) {
        if (NativeReporting.isInitialized()) {
            AgentNDK.getInstance().crashNow(message);
        }
    }

    NativeReporting(Context context, AgentConfiguration agentConfiguration) {
        AgentNDK.Builder builder = new AgentNDK.Builder(context);
        builder.withBuildId(Agent.getBuildId()).withSessionId(agentConfiguration.getSessionID()).withReportListener((AgentNDKListener)this).withLogger(log).build();
    }

    public void start() {
        if (NativeReporting.isInitialized()) {
            AgentNDK.getInstance().start();
            StatsEngine.get().inc("Supportability/Mobile/Android/NDK/Start");
        } else {
            log.error("CrashReporter: Must first initialize native module.");
        }
    }

    void stop() {
        if (NativeReporting.isInitialized()) {
            AgentNDK.getInstance().stop();
            StatsEngine.get().inc("Supportability/Mobile/Android/NDK/Stop");
        }
    }

    public boolean onNativeCrash(String crashAsString) {
        AnalyticsControllerImpl analyticsController = AnalyticsControllerImpl.getInstance();
        NativeCrash crash = new NativeCrash(new NativeException(crashAsString), analyticsController.getSessionAttributes(), analyticsController.getEventManager().getQueuedEvents());
        CrashReporter.getInstance().storeAndReportCrash((Crash)crash);
        StatsEngine.get().inc("Supportability/Mobile/Android/NDK/Reports/NativeCrash");
        return true;
    }

    public boolean onNativeException(String exceptionAsString) {
        HashMap<String, Object> exceptionAttributes = new HashMap<String, Object>(){
            {
                this.put("platform", "native");
            }
        };
        NativeException exceptionToHandle = new NativeException(exceptionAsString);
        AgentDataController.sendAgentData((Throwable)exceptionToHandle, (Map<String, Object>)exceptionAttributes);
        StatsEngine.get().inc("Supportability/Mobile/Android/NDK/Reports/NativeException");
        return true;
    }

    public boolean onApplicationNotResponding(String anrAsString) {
        HashMap<String, Object> exceptionAttributes = new HashMap<String, Object>(){
            {
                this.put("platform", "native");
                this.put("ANR", "true");
            }
        };
        NativeException exceptionToHandle = new NativeException(anrAsString);
        AgentDataController.sendAgentData((Throwable)exceptionToHandle, (Map<String, Object>)exceptionAttributes);
        StatsEngine.get().inc("Supportability/Mobile/Android/NDK/Reports/ANR");
        return true;
    }

    @Override
    public void onHarvestStart() {
        AgentNDK.getInstance().flushPendingReports();
        StatsEngine.get().inc("Supportability/Mobile/Android/NDK/Reports/Flush");
    }
}

