/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.analytics;

import com.newrelic.agent.android.agentdata.AgentDataController;
import com.newrelic.agent.android.analytics.AnalyticsAttribute;
import com.newrelic.agent.android.analytics.AnalyticsEvent;
import com.newrelic.agent.android.analytics.EventListener;
import com.newrelic.agent.android.analytics.EventManager;
import com.newrelic.agent.android.analytics.EventManagerImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EventTransformAdapter
implements EventListener {
    final String REPLACEMENT = "*";
    final Map<String, Map<Pattern, String>> attributeTransforms = new HashMap<String, Map<Pattern, String>>();
    EventManagerImpl em = null;

    @Override
    public boolean onEventAdded(AnalyticsEvent analyticsEvent) {
        return this.em != null ? this.em.onEventAdded(analyticsEvent) : true;
    }

    @Override
    public boolean onEventOverflow(AnalyticsEvent analyticsEvent) {
        return this.em != null ? this.em.onEventOverflow(analyticsEvent) : false;
    }

    @Override
    public boolean onEventEvicted(AnalyticsEvent analyticsEvent) {
        return this.em != null ? this.em.onEventEvicted(analyticsEvent) : true;
    }

    @Override
    public void onEventQueueSizeExceeded(int queueSize) {
        if (this.em != null) {
            this.em.onEventQueueSizeExceeded(queueSize);
        }
    }

    @Override
    public void onEventQueueTimeExceeded(int queueTime) {
        if (this.em != null) {
            this.em.onEventQueueTimeExceeded(queueTime);
        }
    }

    @Override
    public void onEventFlush() {
        if (this.em != null) {
            this.em.onEventFlush();
        }
    }

    @Override
    public void onStart(EventManager eventManager) {
        this.em = (EventManagerImpl)eventManager;
        if (this.em != null) {
            this.em.onStart(eventManager);
        }
    }

    @Override
    public void onShutdown() {
        if (this.em != null) {
            this.em.onShutdown();
            this.em = null;
        }
    }

    public EventTransformAdapter withAttributeTransform(String attributeName, Map<String, String> transforms) {
        Map<Pattern, String> attributeTransform = this.attributeTransforms.get(attributeName);
        if (attributeTransform == null) {
            attributeTransform = new HashMap<Pattern, String>();
        }
        if (transforms != null) {
            for (final Map.Entry<String, String> entry : transforms.entrySet()) {
                try {
                    Pattern pattern = Pattern.compile(entry.getKey());
                    attributeTransform.put(pattern, entry.getValue());
                }
                catch (Exception e) {
                    AgentDataController.sendAgentData(e, (Map<String, Object>)new HashMap<String, Object>(){
                        {
                            this.put("transform", (String)entry.getKey() + "/" + (String)entry.getValue());
                        }
                    });
                }
            }
        }
        if (!attributeTransform.isEmpty()) {
            this.attributeTransforms.put(attributeName, attributeTransform);
        }
        return this;
    }

    public void onEventTransform(AnalyticsEvent analyticsEvent) {
        for (AnalyticsAttribute analyticsAttribute : analyticsEvent.getAttributeSet()) {
            if (!this.attributeTransforms.containsKey(analyticsAttribute.getName())) continue;
            String transformedValue = this.onAttributeTransform(analyticsAttribute.getName(), analyticsAttribute.getStringValue());
            analyticsAttribute.setStringValue(transformedValue);
        }
    }

    public String onAttributeTransform(String attributeName, String attributeValue) {
        Map<Pattern, String> transforms = this.attributeTransforms.get(attributeName);
        if (transforms != null) {
            for (Pattern pattern : transforms.keySet()) {
                attributeValue = this.onPatternTransform(pattern, transforms.get(pattern), attributeValue);
            }
        }
        return attributeValue;
    }

    String onPatternTransform(Pattern pattern, String replacement, String value) {
        Matcher matcher = pattern.matcher(value);
        if (matcher.find()) {
            StringBuilder transformedValue = new StringBuilder();
            if (replacement == null) {
                transformedValue.append(value);
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    for (int j = matcher.start(i); j < matcher.end(i); ++j) {
                        transformedValue.replace(j, j + 1, "*");
                    }
                }
            } else {
                transformedValue.append(matcher.replaceAll(replacement));
            }
            return transformedValue.toString();
        }
        return value;
    }
}

