/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.stats;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.harvest.DeviceInformation;
import com.newrelic.agent.android.harvest.HarvestAdapter;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.metric.Metric;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StatsEngine
extends HarvestAdapter {
    public static final StatsEngine INSTANCE = new StatsEngine();
    public static final StatsEngine SUPPORTABILITY = new SupportabilityDecorator();
    public boolean enabled = true;
    private final ConcurrentHashMap<String, Metric> statsMap = new ConcurrentHashMap();

    private StatsEngine() {
    }

    public static StatsEngine get() {
        return INSTANCE;
    }

    public static StatsEngine notice() {
        return SUPPORTABILITY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inc(String name) {
        Metric m;
        Metric metric = m = this.lazyGet(name);
        synchronized (metric) {
            m.increment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inc(String name, long count) {
        Metric m;
        Metric metric = m = this.lazyGet(name);
        synchronized (metric) {
            m.increment(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sample(String name, float value) {
        Metric m;
        Metric metric = m = this.lazyGet(name);
        synchronized (metric) {
            m.sample(value);
        }
    }

    public void sampleTimeMs(String name, long time) {
        this.sample(name, (float)time / 1000.0f);
    }

    public static void populateMetrics() {
        Metric metric;
        for (Map.Entry<String, Metric> entry : INSTANCE.getStatsMap().entrySet()) {
            metric = entry.getValue();
            TaskQueue.queue(metric);
        }
        for (Map.Entry<String, Metric> entry : SUPPORTABILITY.getStatsMap().entrySet()) {
            metric = entry.getValue();
            TaskQueue.queue(metric);
        }
    }

    @Override
    public void onHarvest() {
        StatsEngine.populateMetrics();
        StatsEngine.reset();
    }

    public static void reset() {
        INSTANCE.getStatsMap().clear();
        SUPPORTABILITY.getStatsMap().clear();
    }

    public static synchronized void disable() {
        StatsEngine.INSTANCE.enabled = false;
        StatsEngine.SUPPORTABILITY.enabled = false;
    }

    public static synchronized void enable() {
        StatsEngine.INSTANCE.enabled = true;
        StatsEngine.SUPPORTABILITY.enabled = true;
    }

    public ConcurrentHashMap<String, Metric> getStatsMap() {
        return this.statsMap;
    }

    protected Metric lazyGet(String name) {
        Metric m = this.statsMap.get(name);
        if (m == null) {
            m = new Metric(name);
            if (this.enabled) {
                this.statsMap.put(name, m);
            }
        }
        return m;
    }

    static class SupportabilityDecorator
    extends StatsEngine {
        SupportabilityDecorator() {
        }

        String emptyIfNull(String s) {
            return s == null ? "" : s;
        }

        @Override
        protected Metric lazyGet(String name) {
            DeviceInformation deviceInformation = Agent.getDeviceInformation();
            String framework = this.emptyIfNull(null);
            String frameworkVersion = this.emptyIfNull(null);
            String f = this.emptyIfNull(deviceInformation.getApplicationFrameworkVersion());
            String a = this.emptyIfNull(deviceInformation.getAgentVersion());
            if (deviceInformation.getApplicationFramework() != null) {
                switch (deviceInformation.getApplicationFramework()) {
                    case Native: {
                        if (f.isEmpty() || f.equals(a)) break;
                        framework = this.emptyIfNull(deviceInformation.getApplicationFramework().name());
                        frameworkVersion = this.emptyIfNull(deviceInformation.getApplicationFrameworkVersion());
                        break;
                    }
                    default: {
                        framework = this.emptyIfNull(deviceInformation.getApplicationFramework().name());
                        if (f.equals(a)) break;
                        frameworkVersion = this.emptyIfNull(deviceInformation.getApplicationFrameworkVersion());
                    }
                }
            }
            name = name.replaceAll("<framework>", this.emptyIfNull(framework)).replaceAll("<frameworkVersion>", this.emptyIfNull(frameworkVersion));
            while (name.contains("//")) {
                name = name.replaceAll("//", "/");
            }
            AgentLogManager.getAgentLog().debug("Metric normalized to [" + name + "]");
            return super.lazyGet(name);
        }
    }
}

