/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.stores;

import android.content.Context;
import com.newrelic.agent.android.payload.Payload;
import com.newrelic.agent.android.payload.PayloadStore;
import com.newrelic.agent.android.stores.SharedPrefsStore;
import com.newrelic.com.google.gson.Gson;
import com.newrelic.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SharedPrefsPayloadStore
extends SharedPrefsStore
implements PayloadStore<Payload> {
    public static final String STORE_FILE = "NRPayloadStore";

    public SharedPrefsPayloadStore(Context context) {
        this(context, STORE_FILE);
    }

    public SharedPrefsPayloadStore(Context context, String storeFilename) {
        super(context, storeFilename);
    }

    @Override
    public boolean store(Payload payload) {
        String stringSet = this.toJsonString(payload);
        return super.store(payload.getUuid(), stringSet);
    }

    @Override
    public List<Payload> fetchAll() {
        ArrayList<Payload> payloads = new ArrayList<Payload>();
        for (Object object : super.fetchAll()) {
            try {
                if (object instanceof String) {
                    JsonObject payloadObj = new Gson().fromJson((String)object, JsonObject.class);
                    Payload payload = new Gson().fromJson(payloadObj.get("payload").getAsString(), Payload.class);
                    payload.putBytes(this.decodePayload(payloadObj.get("encodedPayload").toString()));
                    payloads.add(payload);
                    continue;
                }
                if (!(object instanceof HashSet)) continue;
                HashSet stringSet = (HashSet)object;
                Iterator iter = stringSet.iterator();
                Payload payload = new Gson().fromJson((String)iter.next(), Payload.class);
                payload.putBytes(this.decodePayload((String)iter.next()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return payloads;
    }

    @Override
    public void delete(Payload payload) {
        super.delete(payload.getUuid());
    }

    protected String encodePayload(Payload payload) {
        return this.encodeBytes(payload.getBytes());
    }

    protected byte[] decodePayload(String encodedString) {
        return this.decodeStringToBytes(encodedString);
    }

    protected String decodePayloadToString(byte[] decodedString) {
        return this.decodeBytesToString(decodedString);
    }

    private String toJsonString(Payload payload) {
        JsonObject stringObj = new JsonObject();
        stringObj.addProperty("payload", payload.asJsonMeta());
        stringObj.addProperty("encodedPayload", this.encodePayload(payload));
        return stringObj.toString();
    }
}

