/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android;

import android.content.Context;
import android.text.TextUtils;
import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.AndroidAgentImpl;
import com.newrelic.agent.android.ApplicationFramework;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.InstantApps;
import com.newrelic.agent.android.Measurements;
import com.newrelic.agent.android.NullAgentImpl;
import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.agentdata.AgentDataController;
import com.newrelic.agent.android.analytics.AnalyticsControllerImpl;
import com.newrelic.agent.android.analytics.EventListener;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.distributedtracing.DistributedTracing;
import com.newrelic.agent.android.distributedtracing.TraceContext;
import com.newrelic.agent.android.distributedtracing.TraceListener;
import com.newrelic.agent.android.hybrid.StackTrace;
import com.newrelic.agent.android.hybrid.data.DataController;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.logging.AndroidAgentLog;
import com.newrelic.agent.android.logging.NullAgentLog;
import com.newrelic.agent.android.measurement.http.HttpTransactionMeasurement;
import com.newrelic.agent.android.metric.MetricUnit;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.tracing.TraceMachine;
import com.newrelic.agent.android.tracing.TracingInactiveException;
import com.newrelic.agent.android.util.NetworkFailure;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public final class NewRelic {
    private static final String UNKNOWN_HTTP_REQUEST_TYPE = "unknown";
    protected static final AgentLog log = AgentLogManager.getAgentLog();
    protected static final AgentConfiguration agentConfiguration = new AgentConfiguration();
    protected static boolean started = false;
    protected boolean loggingEnabled = true;
    protected int logLevel = 3;

    protected NewRelic(String token) {
        agentConfiguration.setApplicationToken(token);
    }

    public static NewRelic withApplicationToken(String token) {
        return new NewRelic(token);
    }

    @Deprecated
    public NewRelic usingSsl(boolean useSsl) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/Deprecated/<name>".replace("<name>", "usingSsl"));
        agentConfiguration.setUseSsl(useSsl);
        return this;
    }

    public NewRelic usingCollectorAddress(String address) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "usingCollectorAddress"));
        agentConfiguration.setCollectorHost(address);
        return this;
    }

    public NewRelic usingCrashCollectorAddress(String address) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "usingCrashCollectorAddress"));
        agentConfiguration.setCrashCollectorHost(address);
        return this;
    }

    @Deprecated
    public NewRelic withLocationServiceEnabled(boolean enabled) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/Deprecated/<name>".replace("<name>", "withLocationServiceEnabled/<name>").replace("<state>", Boolean.toString(enabled)));
        agentConfiguration.setUseLocationService(enabled);
        return this;
    }

    public NewRelic withLoggingEnabled(boolean enabled) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "withLoggingEnabled/<state>").replace("<state>", Boolean.toString(enabled)));
        this.loggingEnabled = enabled;
        return this;
    }

    public NewRelic withLogLevel(int level) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "withLogLevel/<state>").replace("<state>", Integer.toString(level)));
        this.logLevel = level;
        return this;
    }

    public NewRelic withApplicationVersion(String appVersion) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "withApplicationVersion/<state>").replace("<state>", appVersion));
        if (appVersion != null) {
            agentConfiguration.setCustomApplicationVersion(appVersion);
        }
        return this;
    }

    public NewRelic withApplicationFramework(ApplicationFramework applicationFramework, String frameworkVersion) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "withApplicationFramework").replace("<framework>", applicationFramework != null ? applicationFramework.name() : "<missing>").replace("<frameworkVersion>", frameworkVersion != null ? frameworkVersion : ""));
        if (applicationFramework != null) {
            agentConfiguration.setApplicationFramework(applicationFramework);
        }
        agentConfiguration.setApplicationFrameworkVersion(frameworkVersion);
        return this;
    }

    public NewRelic withCrashReportingEnabled(boolean enabled) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "withCrashReportingEnabled/<state>").replace("<state>", Boolean.toString(enabled)));
        agentConfiguration.setReportCrashes(enabled);
        return this;
    }

    @Deprecated
    public NewRelic withHttpResponseBodyCaptureEnabled(boolean enabled) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "withHttpResponseBodyCaptureEnabled/<state>").replace("<state>", Boolean.toString(enabled)));
        if (enabled) {
            NewRelic.enableFeature(FeatureFlag.HttpResponseBodyCapture);
        } else {
            NewRelic.disableFeature(FeatureFlag.HttpResponseBodyCapture);
        }
        return this;
    }

    @Deprecated
    public NewRelic withAnalyticsEvents(boolean enabled) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "withAnalyticsEvents/<state>").replace("<state>", Boolean.toString(enabled)));
        agentConfiguration.setEnableAnalyticsEvents(enabled);
        if (enabled) {
            NewRelic.enableFeature(FeatureFlag.AnalyticsEvents);
        } else {
            NewRelic.disableFeature(FeatureFlag.AnalyticsEvents);
        }
        return this;
    }

    @Deprecated
    public NewRelic withInteractionTracing(boolean enabled) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "withInteractionTracing/<state>").replace("<state>", Boolean.toString(enabled)));
        if (enabled) {
            NewRelic.enableFeature(FeatureFlag.InteractionTracing);
        } else {
            NewRelic.disableFeature(FeatureFlag.InteractionTracing);
        }
        return this;
    }

    @Deprecated
    public NewRelic withDefaultInteractions(boolean enabled) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "withDefaultInteractions/<state>").replace("<state>", Boolean.toString(enabled)));
        if (enabled) {
            NewRelic.enableFeature(FeatureFlag.DefaultInteractions);
        } else {
            NewRelic.disableFeature(FeatureFlag.DefaultInteractions);
        }
        return this;
    }

    public static void enableFeature(FeatureFlag featureFlag) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "enableFeature/<state>").replace("<state>", featureFlag.name()));
        log.debug("Enable feature: " + featureFlag.name());
        FeatureFlag.enableFeature(featureFlag);
    }

    public static void disableFeature(FeatureFlag featureFlag) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "disableFeature/<state>").replace("<state>", featureFlag.name()));
        log.debug("Disable feature: " + featureFlag.name());
        FeatureFlag.disableFeature(featureFlag);
    }

    @Deprecated
    public NewRelic withBuildIdentifier(String buildId) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "withBuildIdentifier"));
        return this.withApplicationBuild(buildId);
    }

    public NewRelic withApplicationBuild(String buildId) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "withApplicationBuild"));
        if (!TextUtils.isEmpty((CharSequence)buildId)) {
            agentConfiguration.setCustomBuildIdentifier(buildId);
        }
        return this;
    }

    public NewRelic withDistributedTraceListener(TraceListener listener) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "withDistributedTraceListener"));
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            DistributedTracing.setDistributedTraceListener(listener);
        }
        return this;
    }

    public NewRelic withDeviceID(String deviceID) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "withDeviceID"));
        agentConfiguration.setDeviceID(deviceID);
        return this;
    }

    public void start(Context context) {
        block5: {
            StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "start"));
            if (started) {
                log.debug("NewRelic is already running.");
                return;
            }
            try {
                AgentLogManager.setAgentLog(this.loggingEnabled ? new AndroidAgentLog() : new NullAgentLog());
                log.setLevel(this.logLevel);
                boolean instantApp = InstantApps.isInstantApp(context);
                if (instantApp || this.isInstrumented()) {
                    StackTraceElement[] stack;
                    AndroidAgentImpl.init(context, agentConfiguration);
                    started = true;
                    if (log.getLevel() >= 6 && (stack = Thread.currentThread().getStackTrace()).length > 3) {
                        StackTraceElement elem = stack[3];
                        log.audit("Agent started from " + elem.getClassName() + "." + elem.getMethodName() + ":" + elem.getLineNumber());
                    }
                    break block5;
                }
                this.logRecourse();
                return;
            }
            catch (Throwable e) {
                log.error("Error occurred while starting the New Relic agent!", e);
                this.logRecourse();
            }
        }
    }

    private void logRecourse() {
        log.error("Failed to detect New Relic instrumentation. The current runtime variant may be excluded from instrumentation, or instrumentation failed during your build process. Please visit http://support.newrelic.com.");
    }

    public static boolean isStarted() {
        return started;
    }

    @Deprecated
    public static void shutdown() {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/Deprecated/<name>".replace("<name>", "shutdown"));
        if (started) {
            try {
                Agent.getImpl().stop();
            }
            finally {
                Agent.setImpl(NullAgentImpl.instance);
                started = false;
            }
        }
    }

    private boolean isInstrumented() {
        log.info("isInstrumented: checking for Mono instrumentation flag - " + Agent.getMonoInstrumentationFlag());
        return Agent.getMonoInstrumentationFlag().equals("YES");
    }

    public static String startInteraction(String actionName) {
        NewRelic.checkNull(actionName, "startInteraction: actionName must be an action/method name.");
        log.debug("NewRelic.startInteraction invoked with actionName: " + actionName);
        TraceMachine.startTracing(actionName.replace("/", "."), true, FeatureFlag.featureEnabled(FeatureFlag.InteractionTracing));
        try {
            return TraceMachine.getActivityTrace().getId();
        }
        catch (TracingInactiveException e) {
            return null;
        }
    }

    public static String startInteraction(Context activityContext, String actionName) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/Deprecated/<name>".replace("<name>", "startInteraction"));
        NewRelic.checkNull(activityContext, "startInteraction: context must be an Activity instance.");
        NewRelic.checkNull(actionName, "startInteraction: actionName must be an action/method name.");
        log.debug("NewRelic.startInteraction invoked with actionName: " + actionName);
        TraceMachine.startTracing(activityContext.getClass().getSimpleName() + "#" + actionName.replace("/", "."), false, FeatureFlag.featureEnabled(FeatureFlag.InteractionTracing));
        try {
            return TraceMachine.getActivityTrace().getId();
        }
        catch (TracingInactiveException e) {
            return null;
        }
    }

    @Deprecated
    public static String startInteraction(Context context, String actionName, boolean cancelRunningTrace) {
        if (TraceMachine.isTracingActive() && !cancelRunningTrace) {
            log.warning("startInteraction: An interaction is already being traced, and invalidateActiveTrace is false. This interaction will not be traced.");
            return null;
        }
        return NewRelic.startInteraction(context, actionName);
    }

    public static void endInteraction(String id) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "endInteraction"));
        log.debug("NewRelic.endInteraction invoked. id: " + id);
        TraceMachine.endTrace(id);
    }

    public static void setInteractionName(String name) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "setInteractionName"));
        TraceMachine.setRootDisplayName(name);
    }

    public static void startMethodTrace(String actionName) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "startMethodTrace"));
        NewRelic.checkNull(actionName, "startMethodTrace: actionName must be an action/method name.");
        TraceMachine.enterMethod(actionName);
    }

    public static void endMethodTrace() {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "endMethodTrace"));
        log.debug("NewRelic.endMethodTrace invoked.");
        TraceMachine.exitMethod();
    }

    @Deprecated
    public static void recordMetric(String name, String category, int count, double totalValue, double exclusiveValue) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/Deprecated/<name>".replace("<name>", "recordMetric"));
        NewRelic.recordMetric(name, category, count, totalValue, exclusiveValue, null, null);
    }

    public static void recordMetric(String name, String category, int count, double totalValue, double exclusiveValue, MetricUnit countUnit, MetricUnit valueUnit) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "recordMetric"));
        log.debug("NewRelic.recordMetric invoked for name " + name + ", category: " + category + ", count: " + count + ", totalValue " + totalValue + ", exclusiveValue: " + exclusiveValue + ", countUnit: " + (Object)((Object)countUnit) + ", valueUnit: " + (Object)((Object)valueUnit));
        NewRelic.checkNull(category, "recordMetric: category must not be null. If no MetricCategory is applicable, use MetricCategory.NONE.");
        NewRelic.checkEmpty(name, "recordMetric: name must not be empty.");
        if (!NewRelic.checkNegative(count, "recordMetric: count must not be negative.")) {
            Measurements.addCustomMetric(name, category, count, totalValue, exclusiveValue, countUnit, valueUnit);
        }
    }

    public static void recordMetric(String name, String category, double value) {
        NewRelic.recordMetric(name, category, 1, value, value, null, null);
    }

    public static void recordMetric(String name, String category) {
        NewRelic.recordMetric(name, category, 1.0);
    }

    public static void noticeHttpTransaction(Map<String, Object> attributes) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "noticeHttpTransaction(Map Attribute)"));
        try {
            NewRelic.noticeHttpTransaction((String)attributes.get("url"), (String)attributes.get("httpMethod"), Integer.parseInt((String)attributes.get("statusCode")), Long.parseLong((String)attributes.get("startTimeMs")), Long.parseLong((String)attributes.get("endTimeMs")), Long.parseLong((String)attributes.get("bytesSent")), Long.parseLong((String)attributes.get("bytesReceived")), (String)attributes.get("responseBody"), null, (String)attributes.get("appData"), (Map)attributes.get("traceAttributes"));
        }
        catch (NumberFormatException e) {
            log.error(e.getMessage());
            NewRelic.recordHandledException(e);
        }
    }

    public static void noticeHttpTransaction(String url, String httpMethod, int statusCode, long startTimeMs, long endTimeMs, long bytesSent, long bytesReceived) {
        NewRelic._noticeHttpTransaction(url, httpMethod, statusCode, startTimeMs, endTimeMs, bytesSent, bytesReceived, null, null, null);
    }

    public static void noticeHttpTransaction(String url, String httpMethod, int statusCode, long startTimeMs, long endTimeMs, long bytesSent, long bytesReceived, String responseBody) {
        NewRelic._noticeHttpTransaction(url, httpMethod, statusCode, startTimeMs, endTimeMs, bytesSent, bytesReceived, responseBody, null, null);
    }

    public static void noticeHttpTransaction(String url, String httpMethod, int statusCode, long startTimeMs, long endTimeMs, long bytesSent, long bytesReceived, String responseBody, Map<String, String> params) {
        NewRelic._noticeHttpTransaction(url, httpMethod, statusCode, startTimeMs, endTimeMs, bytesSent, bytesReceived, responseBody, params, null);
    }

    public static void noticeHttpTransaction(String url, String httpMethod, int statusCode, long startTimeMs, long endTimeMs, long bytesSent, long bytesReceived, String responseBody, Map<String, String> params, String appData) {
        NewRelic._noticeHttpTransaction(url, httpMethod, statusCode, startTimeMs, endTimeMs, bytesSent, bytesReceived, responseBody, params, appData);
    }

    public static void noticeHttpTransaction(String url, String httpMethod, int statusCode, long startTimeMs, long endTimeMs, long bytesSent, long bytesReceived, String responseBody, Map<String, String> params, URLConnection urlConnection) {
        String header;
        if (urlConnection != null && (header = urlConnection.getHeaderField("X-NewRelic-ID")) != null && header.length() > 0) {
            NewRelic._noticeHttpTransaction(url, httpMethod, statusCode, startTimeMs, endTimeMs, bytesSent, bytesReceived, responseBody, params, header);
            return;
        }
        NewRelic._noticeHttpTransaction(url, httpMethod, statusCode, startTimeMs, endTimeMs, bytesSent, bytesReceived, responseBody, params, null);
    }

    @Deprecated
    public static void noticeHttpTransaction(String url, String httpMethod, int statusCode, long startTimeMs, long endTimeMs, long bytesSent, long bytesReceived, String responseBody, Map<String, String> params, HttpResponse httpResponse) {
        Header header;
        if (httpResponse != null && (header = httpResponse.getFirstHeader("X-NewRelic-ID")) != null && header.getValue() != null && header.getValue().length() > 0) {
            NewRelic._noticeHttpTransaction(url, httpMethod, statusCode, startTimeMs, endTimeMs, bytesSent, bytesReceived, responseBody, params, header.getValue());
            return;
        }
        NewRelic._noticeHttpTransaction(url, httpMethod, statusCode, startTimeMs, endTimeMs, bytesSent, bytesReceived, responseBody, params, null);
    }

    @Deprecated
    public static void noticeHttpTransaction(String url, int statusCode, long startTimeMs, long endTimeMs, long bytesSent, long bytesReceived, String responseBody, Map<String, String> params, HttpResponse httpResponse) {
        NewRelic.noticeHttpTransaction(url, UNKNOWN_HTTP_REQUEST_TYPE, statusCode, startTimeMs, endTimeMs, bytesSent, bytesReceived, responseBody, params, httpResponse);
    }

    @Deprecated
    public static void noticeHttpTransaction(String url, int statusCode, long startTimeMs, long endTimeMs, long bytesSent, long bytesReceived, String responseBody, Map<String, String> params, URLConnection urlConnection) {
        NewRelic.noticeHttpTransaction(url, UNKNOWN_HTTP_REQUEST_TYPE, statusCode, startTimeMs, endTimeMs, bytesSent, bytesReceived, responseBody, params, urlConnection);
    }

    @Deprecated
    public static void noticeHttpTransaction(String url, int statusCode, long startTimeMs, long endTimeMs, long bytesSent, long bytesReceived) {
        NewRelic._noticeHttpTransaction(url, UNKNOWN_HTTP_REQUEST_TYPE, statusCode, startTimeMs, endTimeMs, bytesSent, bytesReceived, null, null, null);
    }

    @Deprecated
    public static void noticeHttpTransaction(String url, int statusCode, long startTimeMs, long endTimeMs, long bytesSent, long bytesReceived, String responseBody) {
        NewRelic._noticeHttpTransaction(url, UNKNOWN_HTTP_REQUEST_TYPE, statusCode, startTimeMs, endTimeMs, bytesSent, bytesReceived, responseBody, null, null);
    }

    @Deprecated
    public static void noticeHttpTransaction(String url, int statusCode, long startTimeMs, long endTimeMs, long bytesSent, long bytesReceived, String responseBody, Map<String, String> params) {
        NewRelic._noticeHttpTransaction(url, UNKNOWN_HTTP_REQUEST_TYPE, statusCode, startTimeMs, endTimeMs, bytesSent, bytesReceived, responseBody, params, null);
    }

    @Deprecated
    public static void noticeHttpTransaction(String url, int statusCode, long startTimeMs, long endTimeMs, long bytesSent, long bytesReceived, String responseBody, Map<String, String> params, String appData) {
        NewRelic._noticeHttpTransaction(url, UNKNOWN_HTTP_REQUEST_TYPE, statusCode, startTimeMs, endTimeMs, bytesSent, bytesReceived, responseBody, params, appData);
    }

    static void _noticeHttpTransaction(String url, String httpMethod, int statusCode, long startTimeMs, long endTimeMs, long bytesSent, long bytesReceived, String responseBody, Map<String, String> params, String appData) {
        NewRelic.noticeHttpTransaction(url, httpMethod, statusCode, startTimeMs, endTimeMs, bytesSent, bytesReceived, responseBody, params, appData, null);
    }

    public static void noticeHttpTransaction(String url, String httpMethod, int statusCode, long startTimeMs, long endTimeMs, long bytesSent, long bytesReceived, String responseBody, Map<String, String> params, String appData, Map<String, Object> traceAttributes) {
        NewRelic.checkEmpty(url, "noticeHttpTransaction: url must not be empty.");
        NewRelic.checkEmpty(httpMethod, "noticeHttpTransaction: httpMethod must not be empty.");
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("noticeHttpTransaction: URL is malformed: " + url);
        }
        float totalTime = endTimeMs - startTimeMs;
        if (!NewRelic.checkNegative((int)totalTime, "noticeHttpTransaction: the startTimeMs is later than the endTimeMs, resulting in a negative total time.")) {
            totalTime = (float)((double)totalTime / 1000.0);
            TransactionData transactionData = new TransactionData(url, httpMethod, Agent.getActiveNetworkCarrier(), totalTime, statusCode, 0, bytesSent, bytesReceived, appData, Agent.getActiveNetworkWanType(), null, responseBody, params, traceAttributes);
            TaskQueue.queue(new HttpTransactionMeasurement(transactionData));
            if ((long)statusCode >= 400L) {
                Measurements.addHttpError(url, httpMethod, statusCode, responseBody, params);
            }
        }
    }

    public static void noticeNetworkFailure(Map<String, Object> attributes) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "noticeNetworkFailure(Map Attribute)"));
        try {
            NewRelic.noticeNetworkFailure((String)attributes.get("url"), (String)attributes.get("httpMethod"), Long.parseLong((String)attributes.get("startTimeMs")), Long.parseLong((String)attributes.get("endTimeMs")), NetworkFailure.fromErrorCode(Integer.parseInt((String)attributes.get("errorCode"))), (String)attributes.get("message"), (Map)attributes.get("traceAttributes"));
        }
        catch (NumberFormatException e) {
            log.error(e.getMessage());
            NewRelic.recordHandledException(e);
        }
    }

    public static void noticeNetworkFailure(String url, String httpMethod, long startTime, long endTime, NetworkFailure failure, String message) {
        NewRelic.noticeNetworkFailure(url, httpMethod, startTime, endTime, failure, message, null);
    }

    public static void noticeNetworkFailure(String url, String httpMethod, long startTime, long endTime, NetworkFailure failure) {
        NewRelic.noticeNetworkFailure(url, httpMethod, startTime, endTime, failure, "", null);
    }

    public static void noticeNetworkFailure(String url, String httpMethod, long startTime, long endTime, Exception e) {
        NewRelic.checkEmpty(url, "noticeHttpException: url must not be empty.");
        NetworkFailure failure = NetworkFailure.exceptionToNetworkFailure(e);
        NewRelic.noticeNetworkFailure(url, httpMethod, startTime, endTime, failure, e.getMessage());
    }

    @Deprecated
    public static void noticeNetworkFailure(String url, long startTime, long endTime, NetworkFailure failure) {
        NewRelic.noticeNetworkFailure(url, UNKNOWN_HTTP_REQUEST_TYPE, startTime, endTime, failure);
    }

    @Deprecated
    public static void noticeNetworkFailure(String url, long startTime, long endTime, Exception e) {
        NewRelic.noticeNetworkFailure(url, UNKNOWN_HTTP_REQUEST_TYPE, startTime, endTime, e);
    }

    public static void noticeNetworkFailure(String url, String httpMethod, long startTimeMs, long endTimeMs, NetworkFailure failure, String message, Map<String, Object> traceAttributes) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "_noticeNetworkFailure"));
        float totalTime = endTimeMs - startTimeMs;
        if (!NewRelic.checkNegative((int)totalTime, "_noticeNetworkFailure: the startTimeMs is later than the endTimeMs, resulting in a negative total time.")) {
            totalTime /= 1000.0f;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("content_length", "0");
            params.put("content_type", "text/html");
            TransactionData transactionData = new TransactionData(url, httpMethod, Agent.getActiveNetworkCarrier(), totalTime, NetworkFailure.Unknown.getErrorCode(), failure.getErrorCode(), 0L, 0L, null, Agent.getActiveNetworkWanType(), null, message, params, traceAttributes);
            TaskQueue.queue(new HttpTransactionMeasurement(transactionData));
            Measurements.addHttpError(transactionData);
        }
    }

    public static TraceContext noticeDistributedTrace(Map<String, String> requestAttributes) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "noticeDistributedTrace"));
        return TraceContext.createTraceContext(requestAttributes);
    }

    private static void checkNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    private static void checkEmpty(String string, String message) {
        NewRelic.checkNull(string, message);
        if (string.length() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    private static boolean checkNegative(int number, String message) {
        if (number < 0) {
            log.error(message);
            if (FeatureFlag.featureEnabled(FeatureFlag.HandledExceptions)) {
                NewRelic.recordHandledException(new RuntimeException(message));
            }
            return true;
        }
        return false;
    }

    public static void crashNow() {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "crashNow"));
        NewRelic.crashNow("This is a demonstration crash courtesy of New Relic");
    }

    public static void crashNow(String message) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "crashNow(String)"));
        throw new RuntimeException(message);
    }

    public static boolean setAttribute(String name, String value) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "setAttribute(String,String)"));
        return AnalyticsControllerImpl.getInstance().setAttribute(name, value);
    }

    public static boolean setAttribute(String name, double value) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "setAttribute(String,double)"));
        return AnalyticsControllerImpl.getInstance().setAttribute(name, value);
    }

    public static boolean setAttribute(String name, boolean value) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "setAttribute(String,boolean)"));
        return AnalyticsControllerImpl.getInstance().setAttribute(name, value);
    }

    public static boolean incrementAttribute(String name) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "incrementAttribute(String)"));
        return AnalyticsControllerImpl.getInstance().incrementAttribute(name, 1.0);
    }

    public static boolean incrementAttribute(String name, double value) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "incrementAttribute(String, double)"));
        return AnalyticsControllerImpl.getInstance().incrementAttribute(name, value);
    }

    public static boolean removeAttribute(String name) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "removeAttribute"));
        return AnalyticsControllerImpl.getInstance().removeAttribute(name);
    }

    public static boolean removeAllAttributes() {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "removeAllAttribute"));
        return AnalyticsControllerImpl.getInstance().removeAllAttributes();
    }

    public static boolean setUserId(String userId) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "setUserId"));
        return AnalyticsControllerImpl.getInstance().setAttribute("userId", userId);
    }

    @Deprecated
    public static boolean recordEvent(String name, Map<String, Object> eventAttributes) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/Deprecated/<name>".replace("<name>", "recordEvent"));
        if (null == eventAttributes) {
            eventAttributes = new HashMap<String, Object>();
        }
        return AnalyticsControllerImpl.getInstance().recordEvent(name, eventAttributes);
    }

    public static boolean recordCustomEvent(String eventType, Map<String, Object> eventAttributes) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "recordCustomEvent"));
        if (null == eventAttributes) {
            eventAttributes = new HashMap<String, Object>();
        }
        return AnalyticsControllerImpl.getInstance().recordCustomEvent(eventType, eventAttributes);
    }

    public static boolean recordCustomEvent(String eventType, String eventName, Map<String, Object> eventAttributes) {
        if (null == eventAttributes) {
            eventAttributes = new HashMap<String, Object>();
        }
        if (eventName != null && !eventName.isEmpty()) {
            eventAttributes.put("name", eventName);
        }
        return NewRelic.recordCustomEvent(eventType, eventAttributes);
    }

    public static boolean recordBreadcrumb(String breadcrumbName) {
        return NewRelic.recordBreadcrumb(breadcrumbName, null);
    }

    public static boolean recordBreadcrumb(String breadcrumbName, Map<String, Object> attributes) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "recordBreadcrumb"));
        if (null == attributes) {
            attributes = new HashMap<String, Object>();
        }
        if (breadcrumbName != null && !breadcrumbName.isEmpty()) {
            attributes.put("name", breadcrumbName);
        }
        return AnalyticsControllerImpl.getInstance().recordBreadcrumb(breadcrumbName, attributes);
    }

    public static boolean recordHandledException(Exception exception) {
        return NewRelic.recordHandledException(exception, null);
    }

    public static boolean recordHandledException(Exception exception, Map<String, Object> exceptionAttributes) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "recordHandledException"));
        if (exceptionAttributes == null) {
            exceptionAttributes = new HashMap<String, Object>();
        }
        return NewRelic.recordHandledException((Throwable)exception, exceptionAttributes);
    }

    public static boolean recordHandledException(Throwable throwable) {
        return NewRelic.recordHandledException(throwable, null);
    }

    public static boolean recordHandledException(Throwable throwable, Map<String, Object> attributes) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "recordThrowable"));
        if (attributes == null) {
            attributes = new HashMap<String, Object>();
        }
        return AgentDataController.sendAgentData(throwable, attributes);
    }

    public static void setMaxEventPoolSize(int maxSize) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "setMaxEventPoolSize"));
        AnalyticsControllerImpl.getInstance().setMaxEventPoolSize(maxSize);
    }

    public static void setMaxEventBufferTime(int maxBufferTimeInSec) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "setMaxEventBufferTime"));
        AnalyticsControllerImpl.getInstance().setMaxEventBufferTime(maxBufferTimeInSec);
    }

    public static void setEventListener(EventListener eventListener) {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "setEventListener"));
        AnalyticsControllerImpl.getInstance().getEventManager().setEventListener(eventListener);
    }

    public static String currentSessionId() {
        StatsEngine.notice().inc("Supportability/Mobile/Android/<framework>/<frameworkVersion>/API/<name>".replace("<name>", "currentSessionId"));
        return agentConfiguration.getSessionID();
    }

    public static boolean recordJSErrorException(StackTrace stackTrace) {
        return DataController.sendAgentData(stackTrace);
    }
}

