/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.distributedtracing;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.distributedtracing.DistributedTracing;
import com.newrelic.agent.android.distributedtracing.TraceContext;
import com.newrelic.agent.android.distributedtracing.TraceHeader;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.com.google.gson.JsonArray;
import com.newrelic.com.google.gson.JsonObject;
import com.newrelic.com.google.gson.JsonPrimitive;

public class TracePayload
implements TraceHeader {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    public static final String TRACE_PAYLOAD_HEADER = "newrelic";
    static final String VERSION_KEY = "v";
    static final String DATA_KEY = "d";
    static final String PAYLOAD_TYPE_KEY = "ty";
    static final String ACCOUNT_ID_KEY = "ac";
    static final String APP_ID_KEY = "ap";
    static final String GUID_KEY = "id";
    static final String TRACE_ID_KEY = "tr";
    static final String TIMESTAMP_KEY = "ti";
    static final String CALLER_TYPE = "Mobile";
    static final int MAJOR_VERSION = 0;
    static final int MINOR_VERSION = 2;
    final long timestampMs = DistributedTracing.generateNormalizedTimestamp();
    final TraceContext traceContext;
    final String spanId;

    public TracePayload(TraceContext traceContext) {
        this.traceContext = traceContext;
        this.spanId = traceContext.tracePayload == null ? traceContext.getParentId() : traceContext.tracePayload.spanId;
    }

    public JsonObject asJson() {
        JsonObject payload = new JsonObject();
        JsonArray version = new JsonArray();
        JsonObject data = new JsonObject();
        try {
            version.add(new JsonPrimitive(0));
            version.add(new JsonPrimitive(2));
            data.add(PAYLOAD_TYPE_KEY, new JsonPrimitive(CALLER_TYPE));
            data.add(ACCOUNT_ID_KEY, new JsonPrimitive(this.traceContext.traceConfiguration.accountId));
            data.add(APP_ID_KEY, new JsonPrimitive(this.traceContext.traceConfiguration.applicationId));
            data.add(TRACE_ID_KEY, new JsonPrimitive(this.traceContext.traceId));
            data.add(GUID_KEY, new JsonPrimitive(this.spanId));
            data.add(TIMESTAMP_KEY, new JsonPrimitive(this.timestampMs));
            payload.add(VERSION_KEY, version);
            payload.add(DATA_KEY, data);
        }
        catch (Exception e) {
            log.error("Unable to create payload asJSON", e);
        }
        return payload;
    }

    String asBase64Json() {
        try {
            String payloadAsJson = this.asJson().toString();
            return Agent.getEncoder().encodeNoWrap(payloadAsJson.getBytes());
        }
        catch (Exception e) {
            log.error("asBase64Json: " + e.getLocalizedMessage());
            return "";
        }
    }

    public String getTraceId() {
        return this.traceContext.getTraceId();
    }

    public String getSpanId() {
        return this.spanId;
    }

    @Override
    public String getHeaderName() {
        return TRACE_PAYLOAD_HEADER;
    }

    @Override
    public String getHeaderValue() {
        return this.asBase64Json();
    }
}

