/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation;

import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.distributedtracing.TraceContext;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.tracing.TraceMachine;
import com.newrelic.agent.android.util.Util;
import java.net.MalformedURLException;
import java.net.URL;

public class TransactionState {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private String url;
    private String httpMethod;
    private int statusCode = 0;
    private int errorCode = 0;
    private long bytesSent = 0L;
    private long bytesReceived = 0L;
    private long startTime = 0L;
    private long endTime = 0L;
    private String appData;
    private String carrier = "unknown";
    private String wanType = "unknown";
    private State state = State.READY;
    private String contentType;
    private TransactionData transactionData;
    private TraceContext trace;

    public TransactionState() {
        this.startTime = System.currentTimeMillis();
        TraceMachine.enterNetworkSegment("External/unknownhost");
    }

    public TraceContext getTrace() {
        return this.trace;
    }

    public void setTrace(TraceContext traceContext) {
        if (!this.isSent()) {
            this.trace = traceContext;
        } else {
            log.debug("setCatPayload(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public void setCarrier(String carrier) {
        if (!this.isSent()) {
            this.carrier = carrier;
            TraceMachine.setCurrentTraceParam("carrier", carrier);
        } else {
            log.debug("setCarrier(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public void setWanType(String wanType) {
        if (!this.isSent()) {
            this.wanType = wanType;
            TraceMachine.setCurrentTraceParam("wan_type", wanType);
        } else {
            log.debug("setWanType(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public void setAppData(String appData) {
        if (!this.isComplete()) {
            this.appData = appData;
            TraceMachine.setCurrentTraceParam("encoded_app_data", appData);
        } else {
            log.debug("setAppData(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public void setUrl(String urlString) {
        String url = Util.sanitizeUrl(urlString);
        if (url == null) {
            return;
        }
        if (!this.isSent()) {
            this.url = url;
            try {
                TraceMachine.setCurrentDisplayName("External/" + new URL(url).getHost());
            }
            catch (MalformedURLException e) {
                log.error("unable to parse host name from " + url);
            }
            TraceMachine.setCurrentTraceParam("uri", url);
        } else {
            log.debug("setUrl(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public void setHttpMethod(String httpMethod) {
        if (!this.isSent()) {
            this.httpMethod = httpMethod;
            TraceMachine.setCurrentTraceParam("http_method", httpMethod);
        } else {
            log.debug("setHttpMethod(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public boolean isSent() {
        return this.state == State.SENT || this.state == State.COMPLETE;
    }

    public boolean isComplete() {
        return this.state == State.COMPLETE;
    }

    public void setStatusCode(int statusCode) {
        if (!this.isComplete()) {
            this.statusCode = statusCode;
            TraceMachine.setCurrentTraceParam("status_code", statusCode);
        } else {
            log.debug("setStatusCode(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setErrorCode(int errorCode) {
        if (!this.isComplete()) {
            this.errorCode = errorCode;
            TraceMachine.setCurrentTraceParam("error_code", errorCode);
        } else {
            if (this.transactionData != null) {
                this.transactionData.setErrorCode(errorCode);
            }
            log.debug("setErrorCode(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setBytesSent(long bytesSent) {
        if (!this.isComplete()) {
            this.bytesSent = bytesSent;
            TraceMachine.setCurrentTraceParam("bytes_sent", bytesSent);
        } else {
            log.debug("setBytesSent(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public void setBytesReceived(long bytesReceived) {
        if (!this.isComplete()) {
            this.bytesReceived = bytesReceived;
            TraceMachine.setCurrentTraceParam("bytes_received", bytesReceived);
        } else {
            log.debug("setBytesReceived(...) called on TransactionState in " + this.state.toString() + " state");
        }
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public TransactionData end() {
        if (!this.isComplete()) {
            this.state = State.COMPLETE;
            this.endTime = System.currentTimeMillis();
            TraceMachine.exitMethod();
        }
        return this.toTransactionData();
    }

    TransactionData toTransactionData() {
        if (!this.isComplete()) {
            log.debug("toTransactionData() called on incomplete TransactionState");
        }
        if (this.url == null) {
            log.error("Attempted to convert a TransactionState instance with no URL into a TransactionData");
            return null;
        }
        float totalTimeAsSeconds = (float)(this.endTime - this.startTime) / 1000.0f;
        if (totalTimeAsSeconds < 0.0f) {
            log.error("Invalid response duration detected: start[" + this.startTime + "] end[" + this.endTime + "]");
            StatsEngine.get().inc("Supportability/AgentHealth/Network/Request/ResponseTime/InvalidDuration");
            totalTimeAsSeconds = 0.0f;
        }
        if (this.transactionData == null) {
            this.transactionData = new TransactionData(this.url, this.httpMethod, this.carrier, totalTimeAsSeconds, this.statusCode, this.errorCode, this.bytesSent, this.bytesReceived, this.appData, this.wanType, this.trace, null);
        }
        return this.transactionData;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean isErrorOrFailure() {
        return this.isRequestError() || this.isRequestFailure();
    }

    public boolean isRequestFailure() {
        return TransactionState.isRequestFailure(this.errorCode);
    }

    public boolean isRequestError() {
        return TransactionState.isRequestError(this.statusCode);
    }

    public static boolean isRequestFailure(int errorCode) {
        return errorCode != 0;
    }

    public static boolean isRequestError(int statusCode) {
        return (long)statusCode >= 400L;
    }

    public String toString() {
        return "TransactionState{url='" + this.url + '\'' + ", httpMethod='" + this.httpMethod + '\'' + ", statusCode=" + this.statusCode + ", errorCode=" + this.errorCode + ", bytesSent=" + this.bytesSent + ", bytesReceived=" + this.bytesReceived + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", appData='" + this.appData + '\'' + ", carrier='" + this.carrier + '\'' + ", wanType='" + this.wanType + '\'' + ", state=" + (Object)((Object)this.state) + ", contentType='" + this.contentType + '\'' + ", transactionData=" + this.transactionData + '}';
    }

    State setState(State state) {
        this.state = state;
        return this.state;
    }

    static enum State {
        READY,
        SENT,
        COMPLETE;

    }
}

