/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.crash;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.analytics.AnalyticsControllerImpl;
import com.newrelic.agent.android.background.ApplicationStateMonitor;
import com.newrelic.agent.android.crash.Crash;
import com.newrelic.agent.android.crash.CrashReporter;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.payload.PayloadController;
import com.newrelic.agent.android.stats.StatsEngine;
import java.util.concurrent.atomic.AtomicBoolean;

public class UncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    protected static final AgentLog log = AgentLogManager.getAgentLog();
    protected final AtomicBoolean handledException = new AtomicBoolean(false);
    private final CrashReporter crashReporter;
    static Thread.UncaughtExceptionHandler previousExceptionHandler = null;

    public UncaughtExceptionHandler(CrashReporter crashReporter) {
        this.crashReporter = crashReporter;
    }

    public void installExceptionHandler() {
        Thread.UncaughtExceptionHandler currentExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (currentExceptionHandler != null) {
            if (currentExceptionHandler instanceof UncaughtExceptionHandler) {
                log.debug("New Relic crash handler already installed.");
                return;
            }
            if (previousExceptionHandler != null) {
                if (previousExceptionHandler instanceof UncaughtExceptionHandler) {
                    log.warning("Previous uncaught exception handler[" + previousExceptionHandler.getClass().getName() + "] exists, and it is us! Replace it.");
                } else {
                    log.warning("Previous uncaught exception handler[" + previousExceptionHandler.getClass().getName() + "] exists. Assuming it delegates to [" + UncaughtExceptionHandler.class.getName() + "]");
                    return;
                }
            }
            log.debug("Installing New Relic crash handler and chaining to " + currentExceptionHandler.getClass().getName());
        } else {
            log.debug("Installing New Relic crash handler.");
        }
        previousExceptionHandler = currentExceptionHandler;
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        if (!Agent.getUnityInstrumentationFlag().equals("YES") && !this.handledException.compareAndSet(false, true)) {
            StatsEngine.get().inc("Supportability/AgentHealth/Crash/UncaughtExceptionHandler/Recursion");
            return;
        }
        try {
            AgentConfiguration agentConfiguration = this.crashReporter.getAgentConfiguration();
            if (!this.crashReporter.isEnabled() || !FeatureFlag.featureEnabled(FeatureFlag.CrashReporting)) {
                log.debug("A crash has been detected but crash reporting is disabled!");
                return;
            }
            log.debug("A crash has been detected in " + thread.getStackTrace()[0].getClassName() + " and will be reported ASAP.");
            log.debug("Analytics data is currently " + (agentConfiguration.getEnableAnalyticsEvents() ? "enabled " : "disabled"));
            AnalyticsControllerImpl analyticsController = AnalyticsControllerImpl.getInstance();
            analyticsController.setEnabled(true);
            long sessionDuration = Harvest.getMillisSinceStart();
            if (sessionDuration != 0L) {
                analyticsController.setAttribute("sessionDuration", (float)sessionDuration / 1000.0f, false);
            }
            Crash crash = new Crash(throwable, analyticsController.getSessionAttributes(), analyticsController.getEventManager().getQueuedEvents(), agentConfiguration.getEnableAnalyticsEvents());
            this.crashReporter.storeAndReportCrash(crash);
        }
        finally {
            if (Agent.isInstantApp()) {
                Harvest.shutdown();
                ApplicationStateMonitor.getInstance().uiHidden();
            }
            Thread.UncaughtExceptionHandler exceptionHandler = previousExceptionHandler;
            PayloadController.shutdown();
            if (!Agent.getUnityInstrumentationFlag().equals("YES")) {
                this.chainExceptionHandler(exceptionHandler, thread, throwable);
            }
        }
    }

    void chainExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler, Thread thread, Throwable throwable) {
        if (exceptionHandler != null) {
            log.debug("Chaining crash reporting duties to " + exceptionHandler.getClass().getSimpleName());
            exceptionHandler.uncaughtException(thread, throwable);
        }
    }

    public void resetExceptionHandler() {
        Thread.UncaughtExceptionHandler currentExceptionHandler;
        if (previousExceptionHandler != null && (currentExceptionHandler = Thread.getDefaultUncaughtExceptionHandler()) != null) {
            if (currentExceptionHandler instanceof UncaughtExceptionHandler) {
                Thread.setDefaultUncaughtExceptionHandler(previousExceptionHandler);
                previousExceptionHandler = null;
            } else {
                log.warning("Previous uncaught exception handler[" + currentExceptionHandler.getClass().getName() + "] was set after agent start. Let it be...");
            }
        }
        this.handledException.set(false);
    }

    public Thread.UncaughtExceptionHandler getPreviousExceptionHandler() {
        return previousExceptionHandler;
    }
}

