/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.analytics;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.AgentImpl;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.analytics.AnalyticsAttribute;
import com.newrelic.agent.android.analytics.AnalyticsAttributeStore;
import com.newrelic.agent.android.analytics.AnalyticsController;
import com.newrelic.agent.android.analytics.AnalyticsEvent;
import com.newrelic.agent.android.analytics.AnalyticsEventCategory;
import com.newrelic.agent.android.analytics.AnalyticsEventFactory;
import com.newrelic.agent.android.analytics.AnalyticsValidator;
import com.newrelic.agent.android.analytics.EventManager;
import com.newrelic.agent.android.analytics.EventManagerImpl;
import com.newrelic.agent.android.analytics.NetworkEventController;
import com.newrelic.agent.android.harvest.DeviceInformation;
import com.newrelic.agent.android.harvest.EnvironmentInformation;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.HarvestAdapter;
import com.newrelic.agent.android.harvest.HarvestData;
import com.newrelic.agent.android.harvest.HttpTransaction;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.tracing.ActivityTrace;
import com.newrelic.agent.android.tracing.TraceLifecycleAware;
import com.newrelic.agent.android.tracing.TraceMachine;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class AnalyticsControllerImpl
extends HarvestAdapter
implements AnalyticsController {
    protected static final int MAX_ATTRIBUTES = 128;
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private static final AnalyticsControllerImpl instance = new AnalyticsControllerImpl();
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final AnalyticsValidator validator = new AnalyticsValidator();
    private final ConcurrentLinkedQueue<AnalyticsAttribute> systemAttributes;
    private final ConcurrentLinkedQueue<AnalyticsAttribute> userAttributes;
    private final EventManagerImpl eventManager;
    private final AtomicBoolean isEnabled = new AtomicBoolean(false);
    private final InteractionCompleteListener interactionListener;
    private AgentImpl agentImpl;
    private AnalyticsAttributeStore attributeStore;

    public static void initialize(AgentConfiguration agentConfiguration, AgentImpl agentImpl) {
        if (agentConfiguration == null || agentImpl == null) {
            log.error("AnalyticsControllerImpl.initialize(): Can't initialize with a null agent configuration or implementation.");
            return;
        }
        log.audit("AnalyticsControllerImpl.initialize(" + agentConfiguration + ", " + agentImpl.toString() + ")");
        if (!initialized.compareAndSet(false, true)) {
            log.warn("AnalyticsControllerImpl.initialize(): Has already been initialized. Bypassing..");
            return;
        }
        instance.clear();
        instance.reinitialize(agentConfiguration, agentImpl);
        TraceMachine.addTraceListener(AnalyticsControllerImpl.instance.interactionListener);
        Harvest.addHarvestListener(instance);
        log.info("Analytics Controller initialized: enabled[" + AnalyticsControllerImpl.instance.isEnabled + "]");
    }

    public static void shutdown() {
        TraceMachine.removeTraceListener(AnalyticsControllerImpl.instance.interactionListener);
        Harvest.removeHarvestListener(instance);
        instance.getEventManager().shutdown();
        initialized.compareAndSet(true, false);
        log.info("Analytics Controller shutdown");
    }

    private AnalyticsControllerImpl() {
        this.eventManager = new EventManagerImpl();
        this.systemAttributes = new ConcurrentLinkedQueue();
        this.userAttributes = new ConcurrentLinkedQueue();
        this.interactionListener = new InteractionCompleteListener();
    }

    void reinitialize(AgentConfiguration agentConfiguration, AgentImpl agentImpl) {
        log.audit("AnalyticsControllerImpl.reinitialize(" + agentConfiguration + ", " + agentImpl.toString() + ")");
        this.agentImpl = agentImpl;
        this.eventManager.initialize(agentConfiguration);
        this.isEnabled.set(agentConfiguration.getEnableAnalyticsEvents());
        this.attributeStore = agentConfiguration.getAnalyticsAttributeStore();
        this.loadPersistentAttributes();
        DeviceInformation deviceInformation = this.agentImpl.getDeviceInformation();
        String osVersion = deviceInformation.getOsVersion();
        if (osVersion != null && !(osVersion = osVersion.replace(" ", "")).isEmpty()) {
            String osMajorVersion = null;
            String[] osMajorVersionArr = osVersion.split("[.:-]");
            if (osMajorVersionArr.length > 0) {
                osMajorVersion = osMajorVersionArr[0];
            }
            if (osMajorVersion == null || osMajorVersion.isEmpty()) {
                osMajorVersion = osVersion;
            }
            this.systemAttributes.add(new AnalyticsAttribute("osVersion", osVersion));
            this.systemAttributes.add(new AnalyticsAttribute("osMajorVersion", osMajorVersion));
        }
        if (osVersion == null || osVersion.isEmpty()) {
            this.systemAttributes.add(new AnalyticsAttribute("osVersion", "undefined"));
        }
        EnvironmentInformation environmentInformation = this.agentImpl.getEnvironmentInformation();
        this.systemAttributes.add(new AnalyticsAttribute("osName", deviceInformation.getOsName()));
        this.systemAttributes.add(new AnalyticsAttribute("osBuild", deviceInformation.getOsBuild()));
        this.systemAttributes.add(new AnalyticsAttribute("deviceManufacturer", deviceInformation.getManufacturer()));
        this.systemAttributes.add(new AnalyticsAttribute("deviceModel", deviceInformation.getModel()));
        this.systemAttributes.add(new AnalyticsAttribute("uuid", deviceInformation.getDeviceId()));
        this.systemAttributes.add(new AnalyticsAttribute("carrier", agentImpl.getNetworkCarrier()));
        this.systemAttributes.add(new AnalyticsAttribute("newRelicVersion", deviceInformation.getAgentVersion()));
        this.systemAttributes.add(new AnalyticsAttribute("memUsageMb", environmentInformation.getMemoryUsage()));
        this.systemAttributes.add(new AnalyticsAttribute("sessionId", agentConfiguration.getSessionID()));
        this.systemAttributes.add(new AnalyticsAttribute("platform", agentConfiguration.getApplicationFramework().toString()));
        this.systemAttributes.add(new AnalyticsAttribute("platformVersion", agentConfiguration.getApplicationFrameworkVersion()));
        this.systemAttributes.add(new AnalyticsAttribute("runTime", deviceInformation.getRunTime()));
        this.systemAttributes.add(new AnalyticsAttribute("architecture", deviceInformation.getArchitecture()));
        if (agentConfiguration.getCustomBuildIdentifier() != null) {
            this.systemAttributes.add(new AnalyticsAttribute("appBuild", agentConfiguration.getCustomBuildIdentifier()));
        } else {
            String appBuildString = String.valueOf(Agent.getApplicationInformation().getVersionCode());
            if (!appBuildString.isEmpty()) {
                this.systemAttributes.add(new AnalyticsAttribute("appBuild", appBuildString));
            }
        }
    }

    @Override
    public AnalyticsAttribute getAttribute(String name) {
        log.audit("AnalyticsControllerImpl.getAttribute(" + name + ")");
        AnalyticsAttribute attribute = this.getUserAttribute(name);
        if (attribute == null) {
            attribute = this.getSystemAttribute(name);
        }
        return attribute;
    }

    @Override
    public Set<AnalyticsAttribute> getSystemAttributes() {
        log.audit("AnalyticsControllerImpl.getSystemAttributes(): " + this.systemAttributes.size());
        HashSet<AnalyticsAttribute> attrs = new HashSet<AnalyticsAttribute>(this.systemAttributes.size());
        for (AnalyticsAttribute attr : this.systemAttributes) {
            attrs.add(new AnalyticsAttribute(attr));
        }
        return Collections.unmodifiableSet(attrs);
    }

    @Override
    public Set<AnalyticsAttribute> getUserAttributes() {
        log.audit("AnalyticsControllerImpl.getUserAttributes(): " + this.userAttributes.size());
        HashSet<AnalyticsAttribute> attrs = new HashSet<AnalyticsAttribute>(this.userAttributes.size());
        for (AnalyticsAttribute attr : this.userAttributes) {
            attrs.add(new AnalyticsAttribute(attr));
            if (attrs.size() != 128) continue;
            break;
        }
        return Collections.unmodifiableSet(attrs);
    }

    @Override
    public Set<AnalyticsAttribute> getSessionAttributes() {
        log.audit("AnalyticsControllerImpl.getSessionAttributes(): " + this.getSessionAttributeCount());
        HashSet<AnalyticsAttribute> attrs = new HashSet<AnalyticsAttribute>(this.getSessionAttributeCount());
        attrs.addAll(this.getSystemAttributes());
        attrs.addAll(this.getUserAttributes());
        return Collections.unmodifiableSet(attrs);
    }

    @Override
    public int getSystemAttributeCount() {
        return this.systemAttributes.size();
    }

    @Override
    public int getUserAttributeCount() {
        return Math.min(this.userAttributes.size(), 128);
    }

    @Override
    public int getSessionAttributeCount() {
        return this.systemAttributes.size() + this.userAttributes.size();
    }

    @Override
    public boolean setAttribute(String name, String value) {
        return this.setAttribute(name, value, true);
    }

    @Override
    public boolean setAttribute(String name, String value, boolean persistent) {
        log.audit("AnalyticsControllerImpl.setAttribute(" + name + ", " + value + ")" + (persistent ? "(persistent)" : "(transient)"));
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        if (!validator.isValidAttributeName(name) || !validator.isValidAttributeValue(name, value)) {
            return false;
        }
        AnalyticsAttribute cachedAttribute = this.getAttribute(name);
        if (cachedAttribute == null) {
            return this.addNewUserAttribute(new AnalyticsAttribute(name, value, persistent));
        }
        cachedAttribute.setStringValue(value);
        cachedAttribute.setPersistent(persistent);
        if (cachedAttribute.isPersistent()) {
            if (!this.attributeStore.store(cachedAttribute)) {
                log.error("Failed to store attribute [" + cachedAttribute + "] to attribute store.");
                return false;
            }
        } else {
            this.attributeStore.delete(cachedAttribute);
        }
        return true;
    }

    @Override
    public boolean setAttribute(String name, double value) {
        return this.setAttribute(name, value, true);
    }

    @Override
    public boolean setAttribute(String name, double value, boolean persistent) {
        log.audit("AnalyticsControllerImpl.setAttribute(" + name + ", " + value + ")" + (persistent ? " (persistent)" : " (transient)"));
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        if (!validator.isValidAttributeName(name)) {
            return false;
        }
        AnalyticsAttribute cachedAttribute = this.getAttribute(name);
        if (cachedAttribute == null) {
            return this.addNewUserAttribute(new AnalyticsAttribute(name, value, persistent));
        }
        cachedAttribute.setDoubleValue(value);
        cachedAttribute.setPersistent(persistent);
        if (cachedAttribute.isPersistent()) {
            if (!this.attributeStore.store(cachedAttribute)) {
                log.error("Failed to store attribute [" + cachedAttribute + "] to attribute store.");
                return false;
            }
        } else {
            this.attributeStore.delete(cachedAttribute);
        }
        return true;
    }

    @Override
    public boolean setAttribute(String name, boolean value) {
        return this.setAttribute(name, value, true);
    }

    @Override
    public boolean setAttribute(String name, boolean value, boolean persistent) {
        log.audit("AnalyticsControllerImpl.setAttribute(" + name + ", " + value + ")" + (persistent ? " (persistent)" : " (transient)"));
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        if (!validator.isValidAttributeName(name)) {
            return false;
        }
        AnalyticsAttribute cachedAttribute = this.getAttribute(name);
        if (cachedAttribute == null) {
            return this.addNewUserAttribute(new AnalyticsAttribute(name, value, persistent));
        }
        cachedAttribute.setBooleanValue(value);
        cachedAttribute.setPersistent(persistent);
        if (cachedAttribute.isPersistent()) {
            if (!this.attributeStore.store(cachedAttribute)) {
                log.error("Failed to store attribute [" + cachedAttribute + "] to attribute store.");
                return false;
            }
        } else {
            this.attributeStore.delete(cachedAttribute);
        }
        return true;
    }

    public boolean addAttributeUnchecked(AnalyticsAttribute attribute, boolean persistent) {
        log.audit("AnalyticsControllerImpl.setAttributeUnchecked(" + attribute.getName() + ")" + attribute.getStringValue() + (persistent ? " (persistent)" : " (transient)"));
        if (!initialized.get()) {
            log.warn("Analytics controller is not initialized!");
            return false;
        }
        if (!this.isEnabled.get()) {
            log.warn("Analytics controller is not enabled!");
            return false;
        }
        String name = attribute.getName();
        if (!validator.isValidKeyName(name)) {
            return false;
        }
        if (attribute.isStringAttribute() && !validator.isValidAttributeValue(name, attribute.getStringValue())) {
            return false;
        }
        AnalyticsAttribute cachedAttribute = this.getSystemAttribute(name);
        if (cachedAttribute == null) {
            this.systemAttributes.add(attribute);
            if (attribute.isPersistent() && !this.attributeStore.store(attribute)) {
                log.error("Failed to store attribute " + attribute + " to attribute store.");
                return false;
            }
        } else {
            switch (attribute.getAttributeDataType()) {
                case STRING: {
                    cachedAttribute.setStringValue(attribute.getStringValue());
                    break;
                }
                case DOUBLE: {
                    cachedAttribute.setDoubleValue(attribute.getDoubleValue());
                    break;
                }
                case BOOLEAN: {
                    cachedAttribute.setBooleanValue(attribute.getBooleanValue());
                    break;
                }
                default: {
                    log.error("Attribute data type [" + attribute.getAttributeDataType() + "] is invalid");
                }
            }
            cachedAttribute.setPersistent(persistent);
            if (cachedAttribute.isPersistent()) {
                if (!this.attributeStore.store(cachedAttribute)) {
                    log.error("Failed to store attribute [" + cachedAttribute + "] to attribute store.");
                    return false;
                }
            } else {
                this.attributeStore.delete(cachedAttribute);
            }
        }
        return true;
    }

    @Override
    public boolean incrementAttribute(String name, double value) {
        return this.incrementAttribute(name, value, true);
    }

    @Override
    public boolean incrementAttribute(String name, double value, boolean persistent) {
        log.audit("AnalyticsControllerImpl.incrementAttribute(" + name + ", " + value + ") " + (persistent ? " (persistent)" : " (transient)"));
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        if (!validator.isValidAttributeName(name)) {
            return false;
        }
        AnalyticsAttribute cachedAttribute = this.getAttribute(name);
        if (cachedAttribute != null && cachedAttribute.isDoubleAttribute()) {
            cachedAttribute.setDoubleValue(cachedAttribute.getDoubleValue() + value);
            cachedAttribute.setPersistent(persistent);
            if (cachedAttribute.isPersistent() && !this.attributeStore.store(cachedAttribute)) {
                log.error("Failed to store attribute " + cachedAttribute + " to attribute store.");
                return false;
            }
        } else {
            if (cachedAttribute == null) {
                return this.addNewUserAttribute(new AnalyticsAttribute(name, value, persistent));
            }
            log.warn("Cannot increment attribute " + name + ": the attribute is already defined as a non-float value.");
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAttribute(String name) {
        log.audit("AnalyticsControllerImpl.removeAttribute(" + name + ")");
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        AnalyticsAttribute cachedAttribute = this.getAttribute(name);
        if (cachedAttribute != null) {
            this.userAttributes.remove(cachedAttribute);
            if (cachedAttribute.isPersistent()) {
                this.attributeStore.delete(cachedAttribute);
            }
        }
        return true;
    }

    @Override
    public boolean removeAllAttributes() {
        log.audit("AnalyticsControllerImpl.removeAttributes(): " + this.attributeStore.count() + this.userAttributes.size());
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        this.attributeStore.clear();
        this.userAttributes.clear();
        return true;
    }

    @Override
    public boolean addEvent(String name, Set<AnalyticsAttribute> eventAttributes) {
        return this.addEvent(name, AnalyticsEventCategory.Custom, "Mobile", eventAttributes);
    }

    @Override
    public boolean addEvent(String name, AnalyticsEventCategory eventCategory, String eventType, Set<AnalyticsAttribute> eventAttributes) {
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        AnalyticsEvent event = AnalyticsEventFactory.createEvent(name, eventCategory, eventType, eventAttributes);
        return this.addEvent(event);
    }

    @Override
    public boolean addEvent(AnalyticsEvent event) {
        log.audit("AnalyticsControllerImpl.addEvent(" + (event.getName() == null ? event.getEventType() : event.getName()) + ")");
        if (!this.isInitializedAndEnabled()) {
            return false;
        }
        HashSet<AnalyticsAttribute> sessionAttributes = new HashSet<AnalyticsAttribute>();
        long sessionDuration = this.agentImpl.getSessionDurationMillis();
        if (0L == sessionDuration) {
            log.error("Harvest instance is not running! Session duration will be invalid");
        } else {
            sessionAttributes.add(new AnalyticsAttribute("timeSinceLoad", (float)sessionDuration / 1000.0f));
            event.addAttributes(sessionAttributes);
        }
        return this.eventManager.addEvent(event);
    }

    @Override
    public int getMaxEventPoolSize() {
        return this.eventManager.getMaxEventPoolSize();
    }

    @Override
    public void setMaxEventPoolSize(int maxSize) {
        this.eventManager.setMaxEventPoolSize(maxSize);
    }

    @Override
    public void setMaxEventBufferTime(int maxBufferTimeInSec) {
        this.eventManager.setMaxEventBufferTime(maxBufferTimeInSec);
    }

    @Override
    public int getMaxEventBufferTime() {
        return this.eventManager.getMaxEventBufferTime();
    }

    @Override
    public EventManager getEventManager() {
        return this.eventManager;
    }

    public static AnalyticsControllerImpl getInstance() {
        return instance;
    }

    void loadPersistentAttributes() {
        log.audit("AnalyticsControllerImpl.loadPersistentAttributes(): " + this.attributeStore.count());
        List<AnalyticsAttribute> storedAttrs = this.attributeStore.fetchAll();
        log.debug("AnalyticsControllerImpl.loadPersistentAttributes(): found " + storedAttrs.size() + " userAttributes in the attribute store");
        int size = this.userAttributes.size();
        for (AnalyticsAttribute attr : storedAttrs) {
            if (this.userAttributes.contains(attr) || size > 128) continue;
            this.userAttributes.add(attr);
            ++size;
        }
    }

    private AnalyticsAttribute getSystemAttribute(String name) {
        AnalyticsAttribute attribute = null;
        for (AnalyticsAttribute nextAttribute : this.systemAttributes) {
            if (!nextAttribute.getName().equals(name)) continue;
            attribute = nextAttribute;
            break;
        }
        return attribute;
    }

    private AnalyticsAttribute getUserAttribute(String name) {
        AnalyticsAttribute attribute = null;
        for (AnalyticsAttribute nextAttribute : this.userAttributes) {
            if (!nextAttribute.getName().equals(name)) continue;
            attribute = nextAttribute;
            break;
        }
        return attribute;
    }

    public void clear() {
        log.audit("AnalyticsControllerImpl.clear(): system[" + this.systemAttributes.size() + "] user[" + this.userAttributes.size() + "] events[" + this.eventManager.size() + "]");
        this.systemAttributes.clear();
        this.userAttributes.clear();
        this.eventManager.empty();
    }

    @Override
    public boolean recordCustomEvent(String eventType, Map<String, Object> eventAttributes) {
        try {
            log.audit("AnalyticsControllerImpl.recordCustomEvent(" + eventType + ", " + eventAttributes + ")");
            if (!this.isInitializedAndEnabled()) {
                return false;
            }
            if (!validator.isValidEventType(eventType) || validator.isReservedEventType(eventType)) {
                return false;
            }
            String eventName = eventType;
            HashSet<AnalyticsAttribute> attributes = new HashSet<AnalyticsAttribute>();
            attributes.addAll(validator.toValidatedAnalyticsAttributes(eventAttributes));
            String overrideName = (String)eventAttributes.get("name");
            if (overrideName != null && !overrideName.isEmpty()) {
                eventName = overrideName;
            }
            return this.addEvent(eventName, AnalyticsEventCategory.Custom, eventType, attributes);
        }
        catch (Exception e) {
            log.error(String.format("Error occurred while recording custom event [%s]: ", eventType), e);
            return false;
        }
    }

    public boolean recordBreadcrumb(String name, Map<String, Object> eventAttributes) {
        try {
            log.audit("AnalyticsControllerImpl.recordBreadcrumb(" + name + ", " + eventAttributes + ")");
            if (!this.isInitializedAndEnabled()) {
                return false;
            }
            HashSet<AnalyticsAttribute> attributes = new HashSet<AnalyticsAttribute>();
            attributes.addAll(validator.toValidatedAnalyticsAttributes(eventAttributes));
            return this.addEvent(name, AnalyticsEventCategory.Breadcrumb, "MobileBreadcrumb", attributes);
        }
        catch (Exception e) {
            log.error(String.format("Error occurred while recording Breadcrumb event [%s]: ", name), e);
            return false;
        }
    }

    public boolean internalRecordEvent(String name, AnalyticsEventCategory eventCategory, String eventType, Map<String, Object> eventAttributes) {
        try {
            log.audit("AnalyticsControllerImpl.internalRecordEvent(" + name + ", " + eventCategory.toString() + ", " + eventType + ", " + eventAttributes + ")");
            if (!this.isInitializedAndEnabled()) {
                return false;
            }
            if (!validator.isValidEventType(eventType)) {
                return false;
            }
            Set<AnalyticsAttribute> attributes = validator.toValidatedAnalyticsAttributes(eventAttributes);
            return this.addEvent(name, eventCategory, eventType, attributes);
        }
        catch (Exception e) {
            log.error(String.format("Error occurred while recording event [%s]: ", name), e);
            return false;
        }
    }

    @Override
    public boolean recordEvent(String name, Map<String, Object> eventAttributes) {
        try {
            log.audit("AnalyticsControllerImpl.recordEvent - " + name + ": " + eventAttributes.size() + " attributes");
            if (!this.isInitializedAndEnabled()) {
                return false;
            }
            HashSet<AnalyticsAttribute> attributes = new HashSet<AnalyticsAttribute>();
            attributes.addAll(validator.toValidatedAnalyticsAttributes(eventAttributes));
            return this.addEvent(name, AnalyticsEventCategory.Custom, "Mobile", attributes);
        }
        catch (Exception e) {
            log.error(String.format("Error occurred while recording event [%s]: ", name), e);
            return false;
        }
    }

    void createHttpErrorEvent(HttpTransaction txn) {
        if (this.isInitializedAndEnabled()) {
            NetworkEventController.createHttpErrorEvent(txn);
        }
    }

    void createNetworkFailureEvent(HttpTransaction txn) {
        if (this.isInitializedAndEnabled()) {
            NetworkEventController.createNetworkFailureEvent(txn);
        }
    }

    void createNetworkRequestEvent(HttpTransaction txn) {
        if (this.isInitializedAndEnabled()) {
            NetworkEventController.createNetworkRequestEvent(txn);
        }
    }

    public void createNetworkRequestEvents(HttpTransaction txn) {
        if (this.isInitializedAndEnabled()) {
            if (this.isHttpError(txn)) {
                NetworkEventController.createHttpErrorEvent(txn);
            } else if (this.isNetworkFailure(txn)) {
                NetworkEventController.createNetworkFailureEvent(txn);
            } else if (this.isSuccessfulRequest(txn)) {
                NetworkEventController.createNetworkRequestEvent(txn);
            }
        }
    }

    private boolean isNetworkFailure(HttpTransaction txn) {
        return txn.getErrorCode() != 0;
    }

    private boolean isHttpError(HttpTransaction txn) {
        return (long)txn.getStatusCode() >= 400L;
    }

    private boolean isSuccessfulRequest(HttpTransaction txn) {
        return txn.getStatusCode() > 0 && txn.getStatusCode() < 400;
    }

    private boolean isInitializedAndEnabled() {
        if (!initialized.get()) {
            log.warn("Analytics controller is not initialized!");
            return false;
        }
        if (!this.isEnabled.get()) {
            log.warn("Analytics controller is not enabled!");
            return false;
        }
        return true;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled.set(enabled);
    }

    private boolean addNewUserAttribute(AnalyticsAttribute attribute) {
        if (this.userAttributes.size() < 128) {
            if (validator.isValidAttribute(attribute)) {
                this.userAttributes.add(attribute);
                if (attribute.isPersistent() && !this.attributeStore.store(attribute)) {
                    log.error("Failed to store attribute [" + attribute + "] to attribute store.");
                    return false;
                }
            } else {
                log.error("Refused to add invalid attribute: " + attribute.getName());
            }
        } else {
            log.warn("Attribute limit exceeded: 128 are allowed.");
            if (log.getLevel() >= 6) {
                log.audit("Currently defined attributes:");
                for (AnalyticsAttribute attr : this.userAttributes) {
                    log.audit("\t" + attr.getName() + ": " + attr.valueAsString());
                }
            }
        }
        return true;
    }

    @Override
    public void onHarvest() {
        HarvestData harvestData = Harvest.getInstance().getHarvestData();
        if (harvestData != null) {
            harvestData.setAnalyticsEnabled(this.isEnabled.get());
            if (this.isEnabled.get() && FeatureFlag.featureEnabled(FeatureFlag.AnalyticsEvents) && this.eventManager.isTransmitRequired()) {
                HashSet<AnalyticsAttribute> sessionAttributes = new HashSet<AnalyticsAttribute>();
                sessionAttributes.addAll(this.getSystemAttributes());
                sessionAttributes.addAll(this.getUserAttributes());
                harvestData.setSessionAttributes(sessionAttributes);
                Collection<AnalyticsEvent> pendingEvents = this.eventManager.getQueuedEventsSnapshot();
                if (pendingEvents.size() > 0) {
                    harvestData.getAnalyticsEvents().addAll(pendingEvents);
                    log.debug("EventManager: [" + pendingEvents.size() + "] events moved from buffer to HarvestData");
                }
                if (this.eventManager.getQueuedEvents().size() > 0) {
                    log.error("EventManager: [" + this.eventManager.getQueuedEvents().size() + "] events remain in buffer after hand-off");
                }
            }
        }
    }

    class InteractionCompleteListener
    implements TraceLifecycleAware {
        InteractionCompleteListener() {
        }

        @Override
        public void onEnterMethod() {
        }

        @Override
        public void onExitMethod() {
        }

        @Override
        public void onTraceStart(ActivityTrace activityTrace) {
            AnalyticsAttribute lastInteraction = new AnalyticsAttribute("lastInteraction", activityTrace.getActivityName());
            AnalyticsControllerImpl.this.addAttributeUnchecked(lastInteraction, true);
        }

        @Override
        public void onTraceComplete(ActivityTrace activityTrace) {
            log.audit("AnalyticsControllerImpl.InteractionCompleteListener.onTraceComplete()");
            AnalyticsEvent event = this.createTraceEvent(activityTrace);
            AnalyticsControllerImpl.getInstance().addEvent(event);
        }

        @Override
        public void onTraceRename(ActivityTrace activityTrace) {
            AnalyticsAttribute lastInteraction = new AnalyticsAttribute("lastInteraction", activityTrace.getActivityName());
            AnalyticsControllerImpl.this.addAttributeUnchecked(lastInteraction, true);
        }

        private AnalyticsEvent createTraceEvent(ActivityTrace activityTrace) {
            float durationInSec = activityTrace.rootTrace.getDurationAsSeconds();
            HashSet<AnalyticsAttribute> attrs = new HashSet<AnalyticsAttribute>();
            attrs.add(new AnalyticsAttribute("interactionDuration", durationInSec));
            return AnalyticsEventFactory.createEvent(activityTrace.rootTrace.displayName, AnalyticsEventCategory.Interaction, "Mobile", attrs);
        }
    }
}

