/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.rum;

import com.newrelic.agent.android.rum.AppTracer;

public class AppStartUpMetrics {
    private Long contentProviderToAppStart = 0L;
    private Long applicationOnCreateTime = 0L;
    private Long appOnCreateEndToFirstActivityCreate = 0L;
    private Long firstActivityCreateToResume = 0L;
    private Long coldStartTime = 0L;
    private Long hotStartTime = 0L;
    private Long warmStartTime = 0L;

    public AppStartUpMetrics() {
        AppTracer tracer = AppTracer.getInstance();
        this.contentProviderToAppStart = tracer.getAppOnCreateTime() - tracer.getContentProviderStartedTime();
        this.applicationOnCreateTime = tracer.getAppOnCreateEndTime() - tracer.getAppOnCreateTime();
        this.appOnCreateEndToFirstActivityCreate = tracer.getFirstActivityCreatedTime() - tracer.getAppOnCreateEndTime();
        this.firstActivityCreateToResume = tracer.getFirstActivityResumeTime() - tracer.getFirstActivityCreatedTime();
        this.coldStartTime = tracer.getFirstActivityResumeTime() - tracer.getContentProviderStartedTime();
        this.hotStartTime = tracer.getFirstActivityResumeTime() - tracer.getFirstActivityStartTime();
        this.warmStartTime = tracer.getFirstActivityResumeTime() - tracer.getContentProviderStartedTime();
    }

    public String toString() {
        return "NewRelicAppStartUpMetrics{contentProviderToAppStart=" + (double)this.contentProviderToAppStart.longValue() / 1000.0 + ", applicationOnCreateTime=" + (double)this.applicationOnCreateTime.longValue() / 1000.0 + ", appOnCreateEndToFirstActivityCreate=" + (double)this.appOnCreateEndToFirstActivityCreate.longValue() / 1000.0 + ", firstActivityCreateToResume=" + (double)this.firstActivityCreateToResume.longValue() / 1000.0 + ", coldStartTime=" + (double)this.coldStartTime.longValue() / 1000.0 + ", hotStartTime=" + (double)this.hotStartTime.longValue() / 1000.0 + ", warmStartTime=" + (double)this.warmStartTime.longValue() / 1000.0 + '}';
    }

    public Long getContentProviderToAppStart() {
        return this.contentProviderToAppStart;
    }

    public void setContentProviderToAppStart(Long contentProviderToAppStart) {
        this.contentProviderToAppStart = contentProviderToAppStart;
    }

    public Long getApplicationOnCreateTime() {
        return this.applicationOnCreateTime;
    }

    public void setApplicationOnCreateTime(Long applicationOnCreateTime) {
        this.applicationOnCreateTime = applicationOnCreateTime;
    }

    public Long getAppOnCreateEndToFirstActivityCreate() {
        return this.appOnCreateEndToFirstActivityCreate;
    }

    public void setAppOnCreateEndToFirstActivityCreate(Long appOnCreateEndToFirstActivityCreate) {
        this.appOnCreateEndToFirstActivityCreate = appOnCreateEndToFirstActivityCreate;
    }

    public Long getFirstActivityCreateToResume() {
        return this.firstActivityCreateToResume;
    }

    public void setFirstActivityCreateToResume(Long firstActivityCreateToResume) {
        this.firstActivityCreateToResume = firstActivityCreateToResume;
    }

    public Long getColdStartTime() {
        return this.coldStartTime;
    }

    public void setColdStartTime(Long coldStartTime) {
        this.coldStartTime = coldStartTime;
    }

    public Long getHotStartTime() {
        return this.hotStartTime;
    }

    public void setHotStartTime(Long hotStartTime) {
        this.hotStartTime = hotStartTime;
    }

    public Long getWarmStartTime() {
        return this.warmStartTime;
    }

    public void setWarmStartTime(Long warmStartTime) {
        this.warmStartTime = warmStartTime;
    }
}

