/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.analytics;

import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.analytics.AnalyticsEvent;
import com.newrelic.agent.android.analytics.EventListener;
import com.newrelic.agent.android.analytics.EventManager;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.stats.StatsEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class EventManagerImpl
implements EventManager,
EventListener {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    public static final int DEFAULT_MAX_EVENT_BUFFER_TIME = 600;
    public static final int DEFAULT_MAX_EVENT_BUFFER_SIZE = 4000;
    public static final int DEFAULT_MIN_EVENT_BUFFER_SIZE = 64;
    public static final int DEFAULT_MIN_EVENT_BUFFER_TIME = 60;
    private AtomicReference<List<AnalyticsEvent>> events;
    int maxEventPoolSize;
    int maxBufferTimeInSec;
    private long firstEventTimestamp;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicInteger eventsRecorded = new AtomicInteger(0);
    private final AtomicInteger eventsEvicted = new AtomicInteger(0);
    private final AtomicInteger eventsDropped = new AtomicInteger(0);
    private final AtomicBoolean transmitRequired = new AtomicBoolean(true);
    private final AtomicReference<EventListener> listener = new AtomicReference<EventManagerImpl>(this);
    AtomicReference<EventManager> instance = new AtomicReference<Object>(null);

    public EventManagerImpl() {
        this(4000, 600);
    }

    public EventManagerImpl(int maxEventPoolSize, int maxBufferTimeInSec) {
        this.events = new AtomicReference(Collections.synchronizedList(new ArrayList(maxEventPoolSize)));
        this.maxBufferTimeInSec = maxBufferTimeInSec;
        this.maxEventPoolSize = maxEventPoolSize;
        this.firstEventTimestamp = 0L;
        this.eventsRecorded.set(0);
        this.eventsEvicted.set(0);
        this.eventsDropped.set(0);
        this.instance.compareAndSet(null, this);
    }

    @Override
    public void initialize(AgentConfiguration agentConfiguration) {
        if (!this.initialized.compareAndSet(false, true)) {
            log.verbose("EventManagerImpl.initialize(): Has already been initialized. Bypassing...");
            return;
        }
        this.firstEventTimestamp = 0L;
        this.eventsRecorded.set(0);
        this.eventsEvicted.set(0);
        this.empty();
        this.listener.get().onStart(this);
    }

    @Override
    public void shutdown() {
        this.listener.get().onShutdown();
        this.initialized.set(false);
    }

    @Override
    public int size() {
        return this.events.get().size();
    }

    @Override
    public void empty() {
        Collection<AnalyticsEvent> droppedEvents = this.getQueuedEventsSnapshot();
        if (droppedEvents.size() > 0) {
            log.warn("EventManager.empty(): dropped [" + droppedEvents.size() + "] events");
        }
        droppedEvents.clear();
        this.firstEventTimestamp = 0L;
    }

    public void empty(Collection<AnalyticsEvent> harvestedEvents) {
        this.events.get().removeAll(harvestedEvents);
    }

    @Override
    public boolean isTransmitRequired() {
        return !this.initialized.get() && this.events.get().size() > 0 || this.transmitRequired.compareAndSet(true, false) || this.isMaxEventPoolSizeExceeded() || this.isMaxEventBufferTimeExceeded();
    }

    @Override
    public void setTransmitRequired() {
        this.transmitRequired.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean addEvent(AnalyticsEvent event) {
        if (!this.initialized.get()) {
            this.eventsDropped.incrementAndGet();
            return false;
        }
        if (!this.listener.get().onEventAdded(event)) {
            log.warn("Listener dropped new event[" + event.getName() + "]");
            this.eventsDropped.incrementAndGet();
            return false;
        }
        if (this.isMaxEventBufferTimeExceeded()) {
            this.listener.get().onEventQueueTimeExceeded(this.maxBufferTimeInSec);
        }
        List<AnalyticsEvent> list = this.events.get();
        synchronized (list) {
            int snapshotSize = this.events.get().size();
            if (snapshotSize == 0) {
                this.firstEventTimestamp = System.currentTimeMillis();
                log.debug("EventManager.addEvent(): Queue is empty, setting first event timestamp to " + this.firstEventTimestamp);
            }
            if (snapshotSize >= this.maxEventPoolSize) {
                try {
                    if (this.listener.get().onEventOverflow(event)) {
                        log.warn("Listener dropped overflow event[" + event.getName() + "]");
                        this.eventsDropped.incrementAndGet();
                        boolean bl = false;
                        return bl;
                    }
                    int index = (int)(Math.random() * (double)this.eventsRecorded.get());
                    if (index >= this.maxEventPoolSize) {
                        if (this.listener.get().onEventEvicted(event)) {
                            this.eventsDropped.incrementAndGet();
                            boolean bl = false;
                            return bl;
                        }
                    } else {
                        AnalyticsEvent evicted = this.events.get().get(index);
                        if (this.listener.get().onEventEvicted(evicted)) {
                            this.events.get().remove(index);
                            this.eventsEvicted.incrementAndGet();
                        }
                    }
                    this.listener.get().onEventQueueSizeExceeded(snapshotSize);
                }
                finally {
                    log.debug("Event queue is full, scheduling harvest");
                }
            }
            if (this.events.get().add(event)) {
                this.eventsRecorded.incrementAndGet();
                return true;
            }
            return false;
        }
    }

    @Override
    public int getEventsRecorded() {
        return this.eventsRecorded.get();
    }

    @Override
    public int getEventsEjected() {
        return this.eventsEvicted.get();
    }

    @Override
    public int getEventsDropped() {
        return this.eventsDropped.get();
    }

    @Override
    public boolean isMaxEventBufferTimeExceeded() {
        if (this.firstEventTimestamp > 0L) {
            return System.currentTimeMillis() - this.firstEventTimestamp > (long)(this.maxBufferTimeInSec * 1000);
        }
        return false;
    }

    @Override
    public boolean isMaxEventPoolSizeExceeded() {
        return this.events.get().size() > this.maxEventPoolSize;
    }

    @Override
    public int getMaxEventPoolSize() {
        return this.maxEventPoolSize;
    }

    @Override
    public void setMaxEventPoolSize(int maxSize) {
        if (maxSize < 64) {
            log.error("Event queue cannot be smaller than 64");
            maxSize = 64;
        }
        if (maxSize > 4000) {
            log.warn("Event queue should not be larger than 4000");
        }
        this.maxEventPoolSize = maxSize;
    }

    @Override
    public void setMaxEventBufferTime(int maxBufferTimeInSec) {
        if (maxBufferTimeInSec < 60) {
            log.error("Event buffer time cannot be shorter than 60 seconds");
            maxBufferTimeInSec = 60;
        }
        if (maxBufferTimeInSec > 600) {
            log.warn("Event buffer time should not be longer than 600 seconds");
            maxBufferTimeInSec = 600;
        }
        this.maxBufferTimeInSec = maxBufferTimeInSec;
    }

    @Override
    public int getMaxEventBufferTime() {
        return this.maxBufferTimeInSec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<AnalyticsEvent> getQueuedEvents() {
        List<AnalyticsEvent> list = this.events.get();
        synchronized (list) {
            return Collections.unmodifiableCollection((Collection)this.events.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<AnalyticsEvent> getQueuedEventsSnapshot() {
        List<AnalyticsEvent> list = this.events.get();
        synchronized (list) {
            this.listener.get().onEventFlush();
            this.transmitRequired.set(false);
            return this.events.getAndSet(Collections.synchronizedList(new ArrayList(this.maxEventPoolSize)));
        }
    }

    @Override
    public void setEventListener(EventListener listener) {
        if (listener != null) {
            this.listener.set(listener);
        } else {
            this.listener.set(this);
        }
    }

    public EventListener getListener() {
        return this.listener.get();
    }

    @Override
    public boolean onEventAdded(AnalyticsEvent event) {
        log.debug("Event [" + event.getCategory() + "] added to queue");
        StatsEngine.get().inc("Supportability/Events/Added");
        return true;
    }

    @Override
    public boolean onEventOverflow(AnalyticsEvent event) {
        log.warn("Event queue overflow adding event [" + event.getName() + "]");
        StatsEngine.get().inc("Supportability/Events/Overflow");
        this.transmitRequired.set(true);
        return false;
    }

    @Override
    public boolean onEventEvicted(AnalyticsEvent event) {
        log.warn("Event [" + event.getName() + "] evicted from queue");
        StatsEngine.get().inc("Supportability/Events/Evicted");
        this.transmitRequired.set(true);
        return true;
    }

    @Override
    public void onEventQueueSizeExceeded(int currentQueueSize) {
        log.warn("Event queue size [" + currentQueueSize + "] exceeded max[" + this.maxEventPoolSize + "]");
        StatsEngine.get().inc("Supportability/Events/Queue/Size/Exceeded");
        this.transmitRequired.set(true);
    }

    @Override
    public void onEventQueueTimeExceeded(int maxBufferTimeInSec) {
        log.warn("Event queue time [" + maxBufferTimeInSec + "] exceeded");
        StatsEngine.get().inc("Supportability/Events/Queue/Time/Exceeded");
        this.transmitRequired.set(true);
    }

    @Override
    public void onEventFlush() {
    }

    @Override
    public void onStart(EventManager eventManager) {
    }

    @Override
    public void onShutdown() {
        if (!this.events.get().isEmpty()) {
            log.warn("Event manager is shutting down with [" + this.events.get().size() + "] events remaining in the queue");
        }
        this.transmitRequired.set(true);
    }
}

