/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.api.common;

import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.distributedtracing.TraceContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TransactionData {
    private final Object errorCodeLock = new Object();
    private final long timestamp;
    private final String url;
    private final String httpMethod;
    private final String carrier;
    private final float time;
    private final int statusCode;
    private final long bytesSent;
    private final long bytesReceived;
    private final String appData;
    private final String wanType;
    private final TraceContext traceContext;
    private Map<String, Object> traceAttributes;
    private int errorCode = 0;
    private String responseBody = null;
    private Map<String, String> params = null;

    public TransactionData(String url, String httpMethod, String carrier, float time, int statusCode, int errorCode, long bytesSent, long bytesReceived, String appData, String wanType, TraceContext traceContext, Map<String, Object> traceAttributes) {
        String trimmedUrl;
        int endPos = url.indexOf(63);
        if (endPos < 0 && (endPos = url.indexOf(59)) < 0) {
            endPos = url.length();
        }
        this.url = trimmedUrl = url.substring(0, endPos);
        this.httpMethod = httpMethod;
        this.carrier = carrier;
        this.time = time;
        this.statusCode = statusCode;
        this.errorCode = errorCode;
        this.bytesSent = bytesSent;
        this.bytesReceived = bytesReceived;
        this.appData = appData;
        this.wanType = wanType;
        this.timestamp = System.currentTimeMillis();
        this.responseBody = null;
        this.params = null;
        this.traceContext = traceContext;
        this.traceAttributes = traceAttributes;
    }

    public TransactionData(String url, String httpMethod, String carrier, float time, int statusCode, int errorCode, long bytesSent, long bytesReceived, String appData, String wanType, TraceContext traceContext, String responseBody, Map<String, String> params, Map<String, Object> traceAttributes) {
        this(url, httpMethod, carrier, time, statusCode, errorCode, bytesSent, bytesReceived, appData, wanType, traceContext, traceAttributes);
        this.responseBody = responseBody;
        this.params = params;
    }

    public String getUrl() {
        return this.url;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getCarrier() {
        return this.carrier;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getErrorCode() {
        Object object = this.errorCodeLock;
        synchronized (object) {
            return this.errorCode;
        }
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public String getAppData() {
        return this.appData;
    }

    public String getWanType() {
        return this.wanType;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public float getTime() {
        return this.time;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErrorCode(int errorCode) {
        Object object = this.errorCodeLock;
        synchronized (object) {
            this.errorCode = errorCode;
        }
    }

    public void setResponseBody(String responseBody) {
        if (FeatureFlag.featureEnabled(FeatureFlag.HttpResponseBodyCapture)) {
            this.responseBody = responseBody == null || responseBody.isEmpty() ? null : responseBody;
        }
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public TraceContext getTraceContext() {
        return this.traceContext;
    }

    public Map<String, Object> getTraceAttributes() {
        return this.traceAttributes;
    }

    public void setTraceAttributes(Map<String, Object> traceAttributes) {
        this.traceAttributes = traceAttributes;
    }

    public List<Object> asList() {
        ArrayList<Object> r = new ArrayList<Object>();
        r.add(this.url);
        r.add(this.carrier);
        r.add(Float.valueOf(this.time));
        r.add(this.statusCode);
        r.add(this.errorCode);
        r.add(this.bytesSent);
        r.add(this.bytesReceived);
        r.add(this.appData);
        return r;
    }

    public String toString() {
        return "TransactionData{timestamp=" + this.timestamp + ", url='" + this.url + "', httpMethod='" + this.httpMethod + "', carrier='" + this.carrier + "', time=" + this.time + ", statusCode=" + this.statusCode + ", errorCode=" + this.errorCode + ", errorCodeLock=" + this.errorCodeLock + ", bytesSent=" + this.bytesSent + ", bytesReceived=" + this.bytesReceived + ", appData='" + this.appData + "', wanType='" + this.wanType + "'}";
    }
}

