/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.hybrid;

import com.newrelic.agent.android.hybrid.rninterface.IStackFrame;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StackFrame
implements IStackFrame {
    private String method;
    private int line;
    private int column;
    private String fileName;
    private final String rawJsLine;
    private static final Pattern STACK_FRAME_PATTERN1 = Pattern.compile("^(?:(.*?)@)?(.*?)\\:([0-9]+)\\:([0-9]+)$");
    private static final Pattern STACK_FRAME_PATTERN2 = Pattern.compile("\\s*(?:at)\\s*(.+?)\\s*[@(](.*):([0-9]+):([0-9]+)[)]$");

    StackFrame(String rawJsLine) {
        this.rawJsLine = rawJsLine.trim();
        this.parseRawJS();
    }

    private void parseRawJS() {
        Matcher matcher;
        Matcher matcher1 = STACK_FRAME_PATTERN1.matcher(this.rawJsLine);
        Matcher matcher2 = STACK_FRAME_PATTERN2.matcher(this.rawJsLine);
        if (matcher2.find()) {
            matcher = matcher2;
        } else if (matcher1.find()) {
            matcher = matcher1;
        } else {
            this.fileName = null;
            this.method = this.rawJsLine;
            this.line = -1;
            this.column = -1;
            return;
        }
        this.fileName = matcher.group(2);
        this.method = matcher.group(1) == null ? "(unknown)" : matcher.group(1);
        this.line = Integer.parseInt(matcher.group(3));
        this.column = Integer.parseInt(matcher.group(4));
    }

    @Override
    public String getClassName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return this.method;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getRawSourceLine() {
        return this.rawJsLine;
    }

    @Override
    public int getLineNumber() {
        return this.line;
    }

    @Override
    public int getColumnNumber() {
        return this.column;
    }
}

