/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.harvest;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.activity.config.ActivityTraceConfiguration;
import com.newrelic.agent.android.activity.config.ActivityTraceConfigurationDeserializer;
import com.newrelic.agent.android.harvest.ActivityTraces;
import com.newrelic.agent.android.harvest.AgentHealth;
import com.newrelic.agent.android.harvest.ConnectInformation;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.HarvestConfiguration;
import com.newrelic.agent.android.harvest.HarvestConnection;
import com.newrelic.agent.android.harvest.HarvestData;
import com.newrelic.agent.android.harvest.HarvestLifecycleAware;
import com.newrelic.agent.android.harvest.HarvestResponse;
import com.newrelic.agent.android.harvest.HttpTransaction;
import com.newrelic.agent.android.harvest.HttpTransactions;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.tracing.ActivityTrace;
import com.newrelic.com.google.gson.Gson;
import com.newrelic.com.google.gson.GsonBuilder;
import com.newrelic.com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;

public class Harvester {
    private final AgentLog log = AgentLogManager.getAgentLog();
    private State state = State.UNINITIALIZED;
    protected boolean stateChanged;
    private HarvestConnection harvestConnection;
    private AgentConfiguration agentConfiguration;
    private HarvestConfiguration configuration = HarvestConfiguration.getDefaultHarvestConfiguration();
    private HarvestData harvestData;
    private final Collection<HarvestLifecycleAware> harvestListeners = new ArrayList<HarvestLifecycleAware>();

    public void start() {
        this.fireOnHarvestStart();
    }

    public void stop() {
        this.fireOnHarvestStop();
    }

    protected void uninitialized() {
        if (this.agentConfiguration == null) {
            this.log.error("Agent configuration unavailable.");
            return;
        }
        if (Agent.getImpl().updateSavedConnectInformation()) {
            this.configureHarvester(HarvestConfiguration.getDefaultHarvestConfiguration());
            this.harvestData.getDataToken().clear();
        }
        Harvest.setHarvestConnectInformation(new ConnectInformation(Agent.getApplicationInformation(), Agent.getDeviceInformation()));
        this.harvestConnection.setApplicationToken(this.agentConfiguration.getApplicationToken());
        this.harvestConnection.setCollectorHost(this.agentConfiguration.getCollectorHost());
        this.harvestConnection.useSsl(this.agentConfiguration.useSsl());
        this.transition(State.DISCONNECTED);
        this.execute();
    }

    protected void disconnected() {
        if (null == this.configuration) {
            this.configureHarvester(HarvestConfiguration.getDefaultHarvestConfiguration());
        }
        if (this.harvestData.isValid()) {
            this.log.verbose("Skipping connect call, saved state is available: " + this.harvestData.getDataToken());
            StatsEngine.get().sample("Session/Start", 1.0f);
            this.fireOnHarvestConnected();
            this.transition(State.CONNECTED);
            this.execute();
            return;
        }
        this.log.info("Connecting, saved state is not available: " + this.harvestData.getDataToken());
        HarvestResponse response = this.harvestConnection.sendConnect();
        if (response == null) {
            this.log.error("Unable to connect to the Collector.");
            return;
        }
        if (response.isOK()) {
            HarvestConfiguration configuration = this.parseHarvesterConfiguration(response);
            if (configuration == null) {
                this.log.error("Unable to configure Harvester using Collector configuration.");
                return;
            }
            this.configureHarvester(configuration);
            StatsEngine.get().sampleTimeMs("Supportability/AgentHealth/Collector/Harvest", response.getResponseTime());
            this.fireOnHarvestConnected();
            this.transition(State.CONNECTED);
            this.execute();
            return;
        }
        this.log.debug("Harvest connect response: " + response.getResponseCode());
        StatsEngine.get().inc("Supportability/AgentHealth/Collector/Harvest/Connect/Error/" + response.getResponseCode());
        switch (response.getResponseCode()) {
            case UNAUTHORIZED: 
            case INVALID_AGENT_ID: {
                this.harvestData.getDataToken().clear();
                this.fireOnHarvestDisconnected();
                return;
            }
            case FORBIDDEN: {
                if (response.isDisableCommand()) {
                    this.log.error("Collector has commanded Agent to disable.");
                    this.fireOnHarvestDisabled();
                    this.transition(State.DISABLED);
                    return;
                }
                this.log.error("Unexpected Collector response: FORBIDDEN");
                break;
            }
            case UNSUPPORTED_MEDIA_TYPE: 
            case ENTITY_TOO_LARGE: {
                this.log.error("Invalid ConnectionInformation was sent to the Collector.");
                break;
            }
            case REQUEST_TIMEOUT: {
                this.log.warn("Harvest request has timed-out, and will retry during next harvest cycle.");
                break;
            }
            case TOO_MANY_REQUESTS: {
                this.log.warn("Harvest request has been throttled, and will retry during next harvest cycle.");
                break;
            }
            default: {
                this.log.error("An unknown error occurred when connecting to the Collector.");
            }
        }
        this.fireOnHarvestError();
    }

    protected void connected() {
        if (!this.harvestData.isValid()) {
            this.log.error("Harvester: invalid data token! Agent must reconnect prior to upload.");
            StatsEngine.SUPPORTABILITY.inc("Supportability/AgentHealth/DataToken/Invalid");
            this.harvestData.getDataToken().clear();
            this.fireOnHarvestSendFailed();
            this.transition(State.DISCONNECTED);
            return;
        }
        this.log.info("Harvester: connected");
        this.log.info("Harvester: Sending [" + this.harvestData.getHttpTransactions().count() + "] HTTP transactions.");
        this.log.info("Harvester: Sending [" + this.harvestData.getActivityTraces().count() + "] activity traces.");
        this.log.info("Harvester: Sending [" + this.harvestData.getSessionAttributes().size() + "] session attributes.");
        this.log.info("Harvester: Sending [" + this.harvestData.getAnalyticsEvents().size() + "] analytics events.");
        HarvestResponse response = this.harvestConnection.sendData(this.harvestData);
        if (response == null || response.isUnknown()) {
            this.log.debug("Harvest data response: " + response.getResponseCode());
            this.fireOnHarvestSendFailed();
            return;
        }
        StatsEngine.get().sampleTimeMs("Supportability/AgentHealth/Collector/Harvest", response.getResponseTime());
        this.log.debug("Harvest data response: " + response.getResponseCode());
        this.log.debug("Harvest data response status code: " + response.getStatusCode());
        this.log.audit("Harvest data response BODY: " + response.getResponseBody());
        if (response.isError()) {
            this.fireOnHarvestError();
            StatsEngine.get().inc("Supportability/AgentHealth/Collector/Harvest/Error/" + response.getResponseCode());
            switch (response.getResponseCode()) {
                case UNAUTHORIZED: 
                case INVALID_AGENT_ID: {
                    this.harvestData.reset();
                    this.harvestData.getDataToken().clear();
                    this.transition(State.DISCONNECTED);
                    break;
                }
                case FORBIDDEN: {
                    this.harvestData.reset();
                    if (response.isDisableCommand()) {
                        this.log.error("Collector has commanded Agent to disable.");
                        this.transition(State.DISABLED);
                        break;
                    }
                    this.log.error("Unexpected Collector response: FORBIDDEN");
                    this.transition(State.DISCONNECTED);
                    break;
                }
                case UNSUPPORTED_MEDIA_TYPE: 
                case ENTITY_TOO_LARGE: {
                    this.harvestData.reset();
                    this.log.error("An invalid harvest payload was sent to the Collector.");
                    break;
                }
                case REQUEST_TIMEOUT: {
                    this.log.warn("Harvest request has timed-out, and will retry during next harvest cycle.");
                    break;
                }
                case TOO_MANY_REQUESTS: {
                    this.log.warn("Harvest request has been throttled, and will retry during next harvest cycle.");
                    break;
                }
                default: {
                    this.log.error("An unknown error occurred when connecting to the Collector.");
                }
            }
            return;
        }
        this.fireOnHarvestComplete();
        this.harvestData.reset();
    }

    protected void disabled() {
        Harvest.stop();
        this.fireOnHarvestDisabled();
    }

    protected void execute() {
        this.log.debug("Harvester state: " + this.state);
        this.stateChanged = false;
        try {
            this.expireHarvestData();
            switch (this.state) {
                case UNINITIALIZED: {
                    this.uninitialized();
                    break;
                }
                case DISCONNECTED: {
                    this.fireOnHarvestBefore();
                    this.disconnected();
                    break;
                }
                case CONNECTED: {
                    TaskQueue.synchronousDequeue();
                    this.fireOnHarvestBefore();
                    this.fireOnHarvest();
                    this.fireOnHarvestFinalize();
                    this.connected();
                    break;
                }
                case DISABLED: {
                    this.disabled();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (Exception e) {
            this.log.error("Exception encountered while attempting to harvest", e);
            AgentHealth.noticeException(e);
        }
    }

    protected void transition(State newState) {
        if (this.stateChanged) {
            this.log.debug("Ignoring multiple transition: " + newState);
            return;
        }
        if (this.state == newState) {
            return;
        }
        switch (this.state) {
            case UNINITIALIZED: {
                if (this.stateIn(newState, State.DISCONNECTED, newState, State.CONNECTED, State.DISABLED)) break;
                throw new IllegalStateException();
            }
            case DISCONNECTED: {
                if (this.stateIn(newState, State.UNINITIALIZED, State.CONNECTED, State.DISABLED)) break;
                throw new IllegalStateException();
            }
            case CONNECTED: {
                if (this.stateIn(newState, State.DISCONNECTED, State.DISABLED)) break;
                throw new IllegalStateException();
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.changeState(newState);
    }

    private HarvestConfiguration parseHarvesterConfiguration(HarvestResponse response) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter((Type)((Object)ActivityTraceConfiguration.class), new ActivityTraceConfigurationDeserializer());
        Gson gson = gsonBuilder.create();
        HarvestConfiguration config = null;
        try {
            config = gson.fromJson(response.getResponseBody(), HarvestConfiguration.class);
        }
        catch (JsonSyntaxException e) {
            this.log.error("Unable to parse collector configuration: " + e.getMessage());
            AgentHealth.noticeException(e);
        }
        return config;
    }

    private void configureHarvester(HarvestConfiguration harvestConfiguration) {
        this.configuration.reconfigure(harvestConfiguration);
        this.harvestData.setDataToken(this.configuration.getDataToken());
        Harvest.setHarvestConfiguration(this.configuration);
    }

    private void changeState(State newState) {
        this.log.debug("Harvester changing state: " + this.state + " -> " + newState);
        if (this.state == State.CONNECTED) {
            if (newState == State.DISCONNECTED) {
                this.fireOnHarvestDisconnected();
            } else if (newState == State.DISABLED) {
                this.fireOnHarvestDisabled();
            }
        }
        this.state = newState;
        this.stateChanged = true;
    }

    private boolean stateIn(State testState, State ... legalStates) {
        for (State state : legalStates) {
            if (testState != state) continue;
            return true;
        }
        return false;
    }

    public State getCurrentState() {
        return this.state;
    }

    public boolean isDisabled() {
        return State.DISABLED == this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHarvestListener(HarvestLifecycleAware harvestAware) {
        if (harvestAware == null) {
            this.log.error("Can't add null harvest listener");
            new Exception().printStackTrace();
            return;
        }
        Collection<HarvestLifecycleAware> collection = this.harvestListeners;
        synchronized (collection) {
            if (this.harvestListeners.contains(harvestAware)) {
                return;
            }
            this.harvestListeners.add(harvestAware);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHarvestListener(HarvestLifecycleAware harvestAware) {
        Collection<HarvestLifecycleAware> collection = this.harvestListeners;
        synchronized (collection) {
            if (!this.harvestListeners.contains(harvestAware)) {
                return;
            }
            this.harvestListeners.remove(harvestAware);
        }
    }

    public void expireHarvestData() {
        if (this.harvestData != null) {
            this.expireHttpTransactions();
            this.expireActivityTraces();
            this.expireAnalyticsEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireHttpTransactions() {
        HttpTransactions transactions;
        HttpTransactions httpTransactions = transactions = this.harvestData.getHttpTransactions();
        synchronized (httpTransactions) {
            ArrayList<HttpTransaction> expiredTransactions = new ArrayList<HttpTransaction>();
            long now = System.currentTimeMillis();
            long maxAge = this.configuration.getReportMaxTransactionAgeMilliseconds();
            for (HttpTransaction txn : transactions.getHttpTransactions()) {
                if (txn.getTimestamp() >= now - maxAge) continue;
                this.log.audit("HttpTransaction too old, purging: " + txn);
                expiredTransactions.add(txn);
            }
            if (!expiredTransactions.isEmpty()) {
                this.log.debug("Purging [" + expiredTransactions.size() + "] expired HttpTransactions from HarvestData");
                for (HttpTransaction txn : expiredTransactions) {
                    transactions.remove(txn);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireActivityTraces() {
        ActivityTraces traces;
        ActivityTraces activityTraces = traces = this.harvestData.getActivityTraces();
        synchronized (activityTraces) {
            ArrayList<ActivityTrace> expiredTraces = new ArrayList<ActivityTrace>();
            long maxAttempts = this.configuration.getActivity_trace_max_report_attempts();
            for (ActivityTrace trace : traces.getActivityTraces()) {
                if (trace.getReportAttemptCount() < maxAttempts) continue;
                this.log.audit("ActivityTrace has had " + trace.getReportAttemptCount() + " report attempts, purging: " + trace);
                expiredTraces.add(trace);
            }
            if (!expiredTraces.isEmpty()) {
                this.log.debug("Purging [" + expiredTraces.size() + "] expired ActivityTraces from HarvestData");
                for (ActivityTrace trace : expiredTraces) {
                    traces.remove(trace);
                }
            }
        }
    }

    public void expireAnalyticsEvents() {
    }

    public void setAgentConfiguration(AgentConfiguration agentConfiguration) {
        this.agentConfiguration = agentConfiguration;
    }

    public void setHarvestConnection(HarvestConnection connection) {
        this.harvestConnection = connection;
    }

    public HarvestConnection getHarvestConnection() {
        return this.harvestConnection;
    }

    public void setHarvestData(HarvestData harvestData) {
        this.harvestData = harvestData;
    }

    public HarvestData getHarvestData() {
        return this.harvestData;
    }

    private void fireOnHarvestBefore() {
        try {
            for (HarvestLifecycleAware harvestAware : this.getHarvestListeners()) {
                harvestAware.onHarvestBefore();
            }
        }
        catch (Exception e) {
            this.log.error("Error in fireOnHarvestBefore", e);
            AgentHealth.noticeException(e);
        }
    }

    private void fireOnHarvestStart() {
        try {
            for (HarvestLifecycleAware harvestAware : this.getHarvestListeners()) {
                harvestAware.onHarvestStart();
            }
        }
        catch (Exception e) {
            this.log.error("Error in fireOnHarvestStart", e);
            AgentHealth.noticeException(e);
        }
    }

    private void fireOnHarvestStop() {
        try {
            for (HarvestLifecycleAware harvestAware : this.getHarvestListeners()) {
                harvestAware.onHarvestStop();
            }
        }
        catch (Exception e) {
            this.log.error("Error in fireOnHarvestStop", e);
            AgentHealth.noticeException(e);
        }
    }

    private void fireOnHarvest() {
        try {
            for (HarvestLifecycleAware harvestAware : this.getHarvestListeners()) {
                harvestAware.onHarvest();
            }
        }
        catch (Exception e) {
            this.log.error("Error in fireOnHarvest", e);
            AgentHealth.noticeException(e);
        }
    }

    private void fireOnHarvestFinalize() {
        try {
            for (HarvestLifecycleAware harvestAware : this.getHarvestListeners()) {
                harvestAware.onHarvestFinalize();
            }
        }
        catch (Exception e) {
            this.log.error("Error in fireOnHarvestFinalize", e);
            AgentHealth.noticeException(e);
        }
    }

    private void fireOnHarvestDisabled() {
        try {
            for (HarvestLifecycleAware harvestAware : this.getHarvestListeners()) {
                harvestAware.onHarvestDisabled();
            }
        }
        catch (Exception e) {
            this.log.error("Error in fireOnHarvestDisabled", e);
            AgentHealth.noticeException(e);
        }
    }

    private void fireOnHarvestDisconnected() {
        try {
            for (HarvestLifecycleAware harvestAware : this.getHarvestListeners()) {
                harvestAware.onHarvestDisconnected();
            }
        }
        catch (Exception e) {
            this.log.error("Error in fireOnHarvestDisconnected", e);
            AgentHealth.noticeException(e);
        }
    }

    private void fireOnHarvestError() {
        try {
            for (HarvestLifecycleAware harvestAware : this.getHarvestListeners()) {
                harvestAware.onHarvestError();
            }
        }
        catch (Exception e) {
            this.log.error("Error in fireOnHarvestError", e);
            AgentHealth.noticeException(e);
        }
    }

    private void fireOnHarvestSendFailed() {
        try {
            for (HarvestLifecycleAware harvestAware : this.getHarvestListeners()) {
                harvestAware.onHarvestSendFailed();
            }
        }
        catch (Exception e) {
            this.log.error("Error in fireOnHarvestSendFailed", e);
            AgentHealth.noticeException(e);
        }
    }

    private void fireOnHarvestComplete() {
        try {
            for (HarvestLifecycleAware harvestAware : this.getHarvestListeners()) {
                harvestAware.onHarvestComplete();
            }
        }
        catch (Exception e) {
            this.log.error("Error in fireOnHarvestComplete", e);
            AgentHealth.noticeException(e);
        }
    }

    private void fireOnHarvestConnected() {
        try {
            for (HarvestLifecycleAware harvestAware : this.getHarvestListeners()) {
                harvestAware.onHarvestConnected();
            }
        }
        catch (Exception e) {
            this.log.error("Error in fireOnHarvestConnected", e);
            AgentHealth.noticeException(e);
        }
    }

    public void setConfiguration(HarvestConfiguration configuration) {
        this.configuration = configuration;
    }

    private Collection<HarvestLifecycleAware> getHarvestListeners() {
        return new ArrayList<HarvestLifecycleAware>(this.harvestListeners);
    }

    protected static enum State {
        UNINITIALIZED,
        DISCONNECTED,
        CONNECTED,
        DISABLED;

    }
}

