/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.hybrid.data;

import com.newrelic.com.google.flatbuffers.FlatBufferBuilder;
import com.newrelic.com.google.flatbuffers.Table;
import com.newrelic.com.google.gson.Gson;
import com.newrelic.com.google.gson.GsonBuilder;
import com.newrelic.mobile.fbs.ApplicationInfo;
import com.newrelic.mobile.fbs.BoolSessionAttribute;
import com.newrelic.mobile.fbs.DoubleSessionAttribute;
import com.newrelic.mobile.fbs.HexAgentData;
import com.newrelic.mobile.fbs.HexAgentDataBundle;
import com.newrelic.mobile.fbs.LongSessionAttribute;
import com.newrelic.mobile.fbs.StringSessionAttribute;
import com.newrelic.mobile.fbs.jserror.Frame;
import com.newrelic.mobile.fbs.jserror.JsError;
import com.newrelic.mobile.fbs.jserror.Thread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataBuilder {
    protected static void computeIfAbsent(String s, Map<String, Integer> map, FlatBufferBuilder flat) {
        if (null != s && !map.containsValue(s)) {
            int offset = flat.createString(s);
            map.put(s, offset);
        }
    }

    public static FlatBufferBuilder startAndFinishAgentData(Map<String, Object> attributesMap, Set<Map<String, Object>> agentData) {
        Object checkedThread;
        HashMap<String, Integer> stringIndexMap = new HashMap<String, Integer>();
        FlatBufferBuilder flat = new FlatBufferBuilder();
        for (Map.Entry<String, Object> entry : attributesMap.entrySet()) {
            String string = entry.getKey();
            Object val = entry.getValue();
            DataBuilder.computeIfAbsent(string, stringIndexMap, flat);
            if (!(val instanceof String)) continue;
            String s = (String)val;
            DataBuilder.computeIfAbsent(s, stringIndexMap, flat);
        }
        Object thread = null;
        for (Map<String, Object> map : agentData) {
            DataBuilder.computeIfAbsent((String)map.get("name"), stringIndexMap, flat);
            DataBuilder.computeIfAbsent((String)map.get("message"), stringIndexMap, flat);
            thread = checkedThread = (List)map.get("thread");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList arrayList2 = new ArrayList();
        if (thread != null) {
            checkedThread = thread.iterator();
            while (checkedThread.hasNext()) {
                Map frame = (Map)checkedThread.next();
                HashMap<String, Integer> frameValStringIndexMap = new HashMap<String, Integer>();
                frameValStringIndexMap.put("fileName", flat.createString(""));
                for (Map.Entry frameElement : frame.entrySet()) {
                    String key = (String)frameElement.getKey();
                    Iterator<Map.Entry<String, Object>> val = frameElement.getValue();
                    if (!(val instanceof String)) continue;
                    int offset = flat.createString((String)((Object)val));
                    frameValStringIndexMap.put(key, offset);
                }
                Frame.startFrame(flat);
                if (frameValStringIndexMap.get("method") != null) {
                    Frame.addMethod(flat, (Integer)frameValStringIndexMap.get("method"));
                }
                if (frameValStringIndexMap.get("fileName") != null) {
                    Frame.addFileName(flat, (Integer)frameValStringIndexMap.get("fileName"));
                }
                if (frame.get("lineNumber") != null) {
                    Frame.addLineNumber(flat, (Integer)frame.get("lineNumber"));
                }
                if (frame.get("column") != null) {
                    Frame.addColumn(flat, (Integer)frame.get("column"));
                }
                int frameOffset = Frame.endFrame(flat);
                arrayList.add(frameOffset);
            }
        }
        int framesOffset = Thread.createFramesVector(flat, DataBuilder.toArray(arrayList));
        int threadOffset = Thread.createThread(flat, framesOffset);
        HashSet<Integer> stringSessionAttributes = new HashSet<Integer>();
        HashSet<Integer> doubleSessionAttributes = new HashSet<Integer>();
        HashSet<Integer> longSessionAttributes = new HashSet<Integer>();
        HashSet<Integer> boolSessionAttributes = new HashSet<Integer>();
        for (Map.Entry<String, Object> attribute : attributesMap.entrySet()) {
            Object n;
            String key = attribute.getKey();
            int keyIndex = (Integer)stringIndexMap.get(key);
            Object val = attribute.getValue();
            if (val instanceof String) {
                stringSessionAttributes.add(StringSessionAttribute.createStringSessionAttribute(flat, keyIndex, (Integer)stringIndexMap.get(val)));
                continue;
            }
            if (val instanceof Double || val instanceof Float) {
                n = (Number)val;
                doubleSessionAttributes.add(DoubleSessionAttribute.createDoubleSessionAttribute(flat, keyIndex, ((Number)n).doubleValue()));
                continue;
            }
            if (val instanceof Number) {
                n = (Number)val;
                longSessionAttributes.add(LongSessionAttribute.createLongSessionAttribute(flat, keyIndex, ((Number)n).longValue()));
                continue;
            }
            if (!(val instanceof Boolean)) continue;
            boolSessionAttributes.add(BoolSessionAttribute.createBoolSessionAttribute(flat, keyIndex, (Boolean)val));
        }
        int stringSessionAttributesVector = -1;
        if (!stringSessionAttributes.isEmpty()) {
            stringSessionAttributesVector = HexAgentData.createStringAttributesVector(flat, DataBuilder.toArray(stringSessionAttributes));
        }
        int doubleSessionAttributesVector = -1;
        if (!doubleSessionAttributes.isEmpty()) {
            doubleSessionAttributesVector = HexAgentData.createDoubleAttributesVector(flat, DataBuilder.toArray(doubleSessionAttributes));
        }
        int longSessionAttributesVector = -1;
        if (!longSessionAttributes.isEmpty()) {
            longSessionAttributesVector = HexAgentData.createLongAttributesVector(flat, DataBuilder.toArray(longSessionAttributes));
        }
        int booleanSessionAttributesVector = -1;
        if (!boolSessionAttributes.isEmpty()) {
            booleanSessionAttributesVector = HexAgentData.createBoolAttributesVector(flat, DataBuilder.toArray(boolSessionAttributes));
        }
        HashSet<Integer> JSErrorOffsets = new HashSet<Integer>();
        if (!agentData.isEmpty()) {
            for (Map map : agentData) {
                int nameOffset = DataBuilder.stringIndexMapOffset(stringIndexMap, map.get("name"));
                int messageOffset = DataBuilder.stringIndexMapOffset(stringIndexMap, map.get("message"));
                boolean fatal = (Boolean)map.get("fatal");
                int buildIdOffset = DataBuilder.stringIndexMapOffset(stringIndexMap, map.get("buildId"));
                int bundleIdOffset = DataBuilder.stringIndexMapOffset(stringIndexMap, map.get("bundleId"));
                JsError.startJsError(flat);
                JsError.addFatal(flat, fatal);
                if (-1 != nameOffset) {
                    JsError.addName(flat, nameOffset);
                }
                if (-1 != messageOffset) {
                    JsError.addMessage(flat, messageOffset);
                }
                if (-1 != buildIdOffset) {
                    JsError.addBuildId(flat, buildIdOffset);
                }
                if (-1 != bundleIdOffset) {
                    JsError.addBundleId(flat, bundleIdOffset);
                }
                JsError.addThread(flat, threadOffset);
                int JSErrorOffset = JsError.endJsError(flat);
                JSErrorOffsets.add(JSErrorOffset);
            }
        }
        int JSErrorVector = -1;
        if (!JSErrorOffsets.isEmpty()) {
            JSErrorVector = HexAgentData.createJsErrorsVector(flat, DataBuilder.toArray(JSErrorOffsets));
        }
        ApplicationInfo.startApplicationInfo(flat);
        ApplicationInfo.addPlatform(flat, 0);
        ApplicationInfo.addFramework(flat, 1);
        int n = ApplicationInfo.endApplicationInfo(flat);
        HexAgentData.startHexAgentData(flat);
        if (stringSessionAttributesVector != -1) {
            HexAgentData.addStringAttributes(flat, stringSessionAttributesVector);
        }
        if (doubleSessionAttributesVector != -1) {
            HexAgentData.addDoubleAttributes(flat, doubleSessionAttributesVector);
        }
        if (longSessionAttributesVector != -1) {
            HexAgentData.addLongAttributes(flat, longSessionAttributesVector);
        }
        if (booleanSessionAttributesVector != -1) {
            HexAgentData.addBoolAttributes(flat, booleanSessionAttributesVector);
        }
        if (JSErrorVector != -1) {
            HexAgentData.addJsErrors(flat, JSErrorVector);
        }
        HexAgentData.addApplicationInfo(flat, n);
        HashSet<Integer> agentDataOffsets = new HashSet<Integer>();
        int agentDataOffset = HexAgentData.endHexAgentData(flat);
        agentDataOffsets.add(agentDataOffset);
        int agentDataVector = HexAgentDataBundle.createHexAgentDataVector(flat, DataBuilder.toArray(agentDataOffsets));
        HexAgentDataBundle.startHexAgentDataBundle(flat);
        HexAgentDataBundle.addHexAgentData(flat, agentDataVector);
        int agentDFataBundleOffset = HexAgentDataBundle.endHexAgentDataBundle(flat);
        flat.finish(agentDFataBundleOffset);
        return flat;
    }

    private static int stringIndexMapOffset(Map<String, Integer> stringIndexMap, Object hexKey) {
        Integer index;
        Integer offset = -1;
        if (hexKey != null && (index = stringIndexMap.get(hexKey)) != null) {
            offset = index;
        }
        return offset;
    }

    private static int[] toArray(Collection<Integer> c) {
        int[] a = new int[c.size()];
        Iterator<Integer> i = c.iterator();
        int index = 0;
        while (i.hasNext()) {
            a[index++] = i.next();
        }
        return a;
    }

    public static String toJsonString(HexAgentDataBundle agentDataBundle, int index) {
        Gson gson = new GsonBuilder().enableComplexMapKeySerialization().serializeNulls().setPrettyPrinting().create();
        HexAgentData agentData = agentDataBundle.hexAgentData(index);
        return gson.toJson(DataBuilder.attributesMapFromAgentData(agentData));
    }

    public static Map<String, Object> attributesMapFromAgentData(HexAgentData agentData) {
        Table a;
        int si;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (si = 0; si < agentData.stringAttributesLength(); ++si) {
            a = agentData.stringAttributes(si);
            map.put(((StringSessionAttribute)a).name(), ((StringSessionAttribute)a).value());
        }
        for (si = 0; si < agentData.longAttributesLength(); ++si) {
            a = agentData.longAttributes(si);
            map.put(((LongSessionAttribute)a).name(), ((LongSessionAttribute)a).value());
        }
        for (si = 0; si < agentData.doubleAttributesLength(); ++si) {
            a = agentData.doubleAttributes(si);
            map.put(((DoubleSessionAttribute)a).name(), ((DoubleSessionAttribute)a).value());
        }
        for (si = 0; si < agentData.boolAttributesLength(); ++si) {
            a = agentData.boolAttributes(si);
            map.put(((BoolSessionAttribute)a).name(), ((BoolSessionAttribute)a).value());
        }
        for (si = 0; si < agentData.jsErrorsLength(); ++si) {
            JsError hex = agentData.jsErrors(si);
            map.put("name", hex.name());
            map.put("message", hex.message());
            map.put("fatal", hex.fatal());
            map.put("buildId", hex.buildId());
            map.put("bundleId", hex.bundleId());
            java.lang.Thread currentThread = java.lang.Thread.currentThread();
            LinkedHashMap<Object, Object> threadMap = new LinkedHashMap<Object, Object>();
            for (int f = 0; f < hex.thread().framesLength(); ++f) {
                LinkedHashMap<String, Object> frameMap = new LinkedHashMap<String, Object>();
                frameMap.put("fileName", hex.thread().frames(f).fileName());
                frameMap.put("lineNumber", hex.thread().frames(f).lineNumber());
                frameMap.put("method", hex.thread().frames(f).method());
                frameMap.put("column", hex.thread().frames(f).column());
                threadMap.put("frame " + f, frameMap);
            }
            threadMap.put("crashed", false);
            threadMap.put("state", currentThread.getState().toString());
            threadMap.put("threadNumber", currentThread.getId());
            threadMap.put("threadId", currentThread.getName());
            threadMap.put("priority", currentThread.getPriority());
            map.put("thread 0", threadMap);
        }
        return map;
    }
}

