/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation.io;

import com.newrelic.agent.android.instrumentation.io.StreamCompleteEvent;
import com.newrelic.agent.android.instrumentation.io.StreamCompleteListener;
import com.newrelic.agent.android.instrumentation.io.StreamCompleteListenerManager;
import com.newrelic.agent.android.instrumentation.io.StreamCompleteListenerSource;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class CountingInputStream
extends InputStream
implements StreamCompleteListenerSource {
    private final InputStream impl;
    private final StreamCompleteListenerManager listenerManager;
    private final boolean enableBuffering;
    private ByteBuffer buffer;
    private long count = 0L;
    private static final AgentLog log = AgentLogManager.getAgentLog();

    public CountingInputStream(InputStream impl) throws IOException {
        this(impl, false);
    }

    public CountingInputStream(InputStream impl, boolean enableBuffering) throws IOException {
        this(impl, enableBuffering, 4096);
    }

    CountingInputStream(InputStream impl, boolean enableBuffering, int capacity) throws IOException {
        this(impl, enableBuffering ? ByteBuffer.allocate(capacity) : null);
    }

    CountingInputStream(InputStream impl, ByteBuffer byteBuffer) throws IOException {
        if (impl == null) {
            throw new IOException("CountingInputStream: input stream cannot be null");
        }
        this.impl = impl;
        this.buffer = byteBuffer;
        this.enableBuffering = this.buffer != null;
        this.listenerManager = new StreamCompleteListenerManager();
        if (this.enableBuffering) {
            this.fillBuffer();
        }
    }

    @Override
    public void addStreamCompleteListener(StreamCompleteListener streamCompleteListener) {
        this.listenerManager.addStreamCompleteListener(streamCompleteListener);
    }

    @Override
    public void removeStreamCompleteListener(StreamCompleteListener streamCompleteListener) {
        this.listenerManager.removeStreamCompleteListener(streamCompleteListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        if (this.enableBuffering) {
            ByteBuffer byteBuffer = this.buffer;
            synchronized (byteBuffer) {
                if (this.bufferHasBytes(1L)) {
                    int n = this.readBuffer();
                    if (n >= 0) {
                        ++this.count;
                    }
                    return n;
                }
            }
        }
        try {
            int n = this.impl.read();
            if (n >= 0) {
                ++this.count;
            } else {
                this.notifyStreamComplete();
            }
            return n;
        }
        catch (IOException e) {
            this.notifyStreamError(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b) throws IOException {
        int n = 0;
        int numBytesFromBuffer = 0;
        int inputBufferRemaining = b.length;
        if (this.enableBuffering) {
            ByteBuffer byteBuffer = this.buffer;
            synchronized (byteBuffer) {
                if (this.bufferHasBytes(inputBufferRemaining)) {
                    n = this.readBufferBytes(b);
                    if (n >= 0) {
                        this.count += (long)n;
                    } else {
                        throw new IOException("readBufferBytes failed");
                    }
                    return n;
                }
                int remaining = this.buffer.remaining();
                if (remaining > 0) {
                    numBytesFromBuffer = this.readBufferBytes(b, 0, remaining);
                    if (numBytesFromBuffer < 0) {
                        throw new IOException("partial read from buffer failed");
                    }
                    inputBufferRemaining -= numBytesFromBuffer;
                    this.count += (long)numBytesFromBuffer;
                }
            }
        }
        try {
            n = this.impl.read(b, numBytesFromBuffer, inputBufferRemaining);
            if (n >= 0) {
                this.count += (long)n;
                return n + numBytesFromBuffer;
            }
            if (numBytesFromBuffer <= 0) {
                this.notifyStreamComplete();
                return n;
            }
            return numBytesFromBuffer;
        }
        catch (IOException e) {
            log.error(e.toString());
            System.out.println("NOTIFY STREAM ERROR: " + e);
            e.printStackTrace();
            this.notifyStreamError(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = 0;
        int numBytesFromBuffer = 0;
        int inputBufferRemaining = len;
        if (this.enableBuffering) {
            ByteBuffer byteBuffer = this.buffer;
            synchronized (byteBuffer) {
                if (this.bufferHasBytes(inputBufferRemaining)) {
                    n = this.readBufferBytes(b, off, len);
                    if (n >= 0) {
                        this.count += (long)n;
                    } else {
                        throw new IOException("readBufferBytes failed");
                    }
                    return n;
                }
                int remaining = this.buffer.remaining();
                if (remaining > 0) {
                    numBytesFromBuffer = this.readBufferBytes(b, off, remaining);
                    if (numBytesFromBuffer < 0) {
                        throw new IOException("partial read from buffer failed");
                    }
                    inputBufferRemaining -= numBytesFromBuffer;
                    this.count += (long)numBytesFromBuffer;
                }
            }
        }
        try {
            n = this.impl.read(b, off + numBytesFromBuffer, inputBufferRemaining);
            if (n >= 0) {
                this.count += (long)n;
                return n + numBytesFromBuffer;
            }
            if (numBytesFromBuffer <= 0) {
                this.notifyStreamComplete();
                return n;
            }
            return numBytesFromBuffer;
        }
        catch (IOException e) {
            this.notifyStreamError(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long byteCount) throws IOException {
        long toSkip = byteCount;
        if (this.enableBuffering) {
            ByteBuffer byteBuffer = this.buffer;
            synchronized (byteBuffer) {
                if (this.bufferHasBytes(byteCount)) {
                    this.buffer.position((int)byteCount);
                    this.count += byteCount;
                    return byteCount;
                }
                toSkip = byteCount - (long)this.buffer.remaining();
                if (toSkip <= 0L) {
                    throw new IOException("partial read from buffer (skip) failed");
                }
                this.buffer.position(this.buffer.remaining());
            }
        }
        try {
            long n = this.impl.skip(toSkip);
            this.count += n;
            return n;
        }
        catch (IOException e) {
            this.notifyStreamError(e);
            throw e;
        }
    }

    @Override
    public int available() throws IOException {
        int remaining = 0;
        if (this.enableBuffering) {
            remaining = this.buffer.remaining();
        }
        try {
            return remaining + this.impl.available();
        }
        catch (IOException e) {
            this.notifyStreamError(e);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.impl.close();
            this.notifyStreamComplete();
        }
        catch (IOException e) {
            this.notifyStreamError(e);
            throw e;
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
        }
    }

    @Override
    public void mark(int readlimit) {
        if (!this.markSupported()) {
            return;
        }
        this.impl.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.impl.markSupported();
    }

    @Override
    public void reset() throws IOException {
        if (!this.markSupported()) {
            return;
        }
        try {
            this.impl.reset();
        }
        catch (IOException e) {
            this.notifyStreamError(e);
            throw e;
        }
    }

    private int readBuffer() {
        if (this.bufferEmpty()) {
            return -1;
        }
        return this.buffer.get();
    }

    private int readBufferBytes(byte[] bytes) {
        return this.readBufferBytes(bytes, 0, bytes.length);
    }

    private int readBufferBytes(byte[] bytes, int offset, int length) {
        if (this.bufferEmpty()) {
            return -1;
        }
        int remainingBefore = this.buffer.remaining();
        this.buffer.get(bytes, offset, length);
        return remainingBefore - this.buffer.remaining();
    }

    private boolean bufferHasBytes(long num) {
        return (long)this.buffer.remaining() >= num;
    }

    private boolean bufferEmpty() {
        return !this.buffer.hasRemaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillBuffer() {
        if (this.buffer != null) {
            if (!this.buffer.hasArray()) {
                return;
            }
            ByteBuffer byteBuffer = this.buffer;
            synchronized (byteBuffer) {
                int bytesRead;
                try {
                    int readCnt;
                    for (bytesRead = 0; bytesRead < this.buffer.capacity(); bytesRead += readCnt) {
                        readCnt = 0;
                        readCnt = this.impl.read(this.buffer.array(), bytesRead, this.buffer.capacity() - bytesRead);
                        if (readCnt <= 0) break;
                    }
                    this.buffer.limit(bytesRead);
                }
                catch (NoSuchMethodError e) {
                    log.error(e.toString());
                    try {
                        ((Buffer)this.buffer).limit(bytesRead);
                    }
                    catch (NoSuchMethodError e1) {
                        log.error(e1.toString());
                        try {
                            this.buffer = ByteBuffer.wrap(this.buffer.array(), 0, bytesRead);
                        }
                        catch (IndexOutOfBoundsException e2) {
                            log.error(e2.toString());
                        }
                    }
                }
                catch (Exception e) {
                    log.error(e.getLocalizedMessage());
                }
            }
        }
    }

    private void notifyStreamComplete() {
        if (!this.listenerManager.isComplete()) {
            this.listenerManager.notifyStreamComplete(new StreamCompleteEvent(this, this.count));
        }
    }

    private void notifyStreamError(Exception e) {
        if (!this.listenerManager.isComplete()) {
            this.listenerManager.notifyStreamError(new StreamCompleteEvent(this, this.count, e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBufferAsString() {
        if (this.buffer != null) {
            ByteBuffer byteBuffer = this.buffer;
            synchronized (byteBuffer) {
                byte[] buf = new byte[this.buffer.limit()];
                for (int i = 0; i < this.buffer.limit(); ++i) {
                    buf[i] = this.buffer.get(i);
                }
                return new String(buf);
            }
        }
        return "";
    }
}

