/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.ApplicationFramework;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.analytics.AnalyticsAttributeStore;
import com.newrelic.agent.android.analytics.AnalyticsEventStore;
import com.newrelic.agent.android.crash.CrashStore;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.payload.NullPayloadStore;
import com.newrelic.agent.android.payload.Payload;
import com.newrelic.agent.android.payload.PayloadStore;
import com.newrelic.agent.android.stats.StatsEngine;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AgentConfiguration {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private static final String DEFAULT_COLLECTOR_HOST = "mobile-collector.newrelic.com";
    private static final String DEFAULT_CRASH_COLLECTOR_HOST = "mobile-crash.newrelic.com";
    public static final String DEFAULT_REGION_COLLECTOR_HOST = "mobile-collector.%s.nr-data.net";
    private static final String DEFAULT_REGION_CRASH_COLLECTOR_HOST = "mobile-crash.%s.nr-data.net";
    public static final String DEFAULT_FED_RAMP_COLLECTOR_HOST = "gov-mobile-collector.newrelic.com";
    private static final String DEFAULT_FED_RAMP_CRASH_COLLECTOR_HOST = "gov-mobile-crash.newrelic.com";
    private static final String HEX_COLLECTOR_PATH = "/mobile/f";
    private static final int HEX_COLLECTOR_TIMEOUT = 5000;
    private static final int NUM_IO_THREADS = 3;
    private static final int PAYLOAD_TTL = 172800000;
    static final String DEFAULT_DEVICE_UUID = "0";
    static final int DEVICE_UUID_MAX_LEN = 40;
    private String collectorHost = "mobile-collector.newrelic.com";
    private String crashCollectorHost = "mobile-crash.newrelic.com";
    private String applicationToken;
    private boolean useSsl = true;
    private boolean useLocationService = false;
    private boolean reportCrashes = false;
    private boolean reportHandledExceptions = true;
    private boolean enableAnalyticsEvents = true;
    private String sessionID = this.provideSessionId();
    private String customApplicationVersion = null;
    private String customBuildId = null;
    private String region = null;
    private String launchActivityClassName = null;
    private CrashStore crashStore;
    private AnalyticsAttributeStore analyticsAttributeStore;
    private PayloadStore<Payload> payloadStore = new NullPayloadStore<Payload>();
    private AnalyticsEventStore eventStore;
    private ApplicationFramework applicationFramework = ApplicationFramework.Native;
    private String applicationFrameworkVersion = Agent.getVersion();
    private String deviceID;

    public String getApplicationToken() {
        return this.applicationToken;
    }

    public void setApplicationToken(String applicationToken) {
        this.applicationToken = applicationToken;
        this.region = this.parseRegionFromApplicationToken(applicationToken);
        if (FeatureFlag.featureEnabled(FeatureFlag.FedRampEnabled)) {
            this.collectorHost = DEFAULT_FED_RAMP_COLLECTOR_HOST;
            this.crashCollectorHost = DEFAULT_FED_RAMP_CRASH_COLLECTOR_HOST;
        } else if (this.region != null) {
            this.collectorHost = String.format(DEFAULT_REGION_COLLECTOR_HOST, this.region);
            this.crashCollectorHost = String.format(DEFAULT_REGION_CRASH_COLLECTOR_HOST, this.region);
        } else {
            this.collectorHost = DEFAULT_COLLECTOR_HOST;
            this.crashCollectorHost = DEFAULT_CRASH_COLLECTOR_HOST;
        }
    }

    public String getCollectorHost() {
        return this.collectorHost;
    }

    public void setCollectorHost(String collectorHost) {
        this.collectorHost = collectorHost;
    }

    public String getCrashCollectorHost() {
        return this.crashCollectorHost;
    }

    public void setCrashCollectorHost(String crashCollectorHost) {
        this.crashCollectorHost = crashCollectorHost;
    }

    public boolean useSsl() {
        return this.useSsl;
    }

    public void setUseSsl(boolean useSsl) {
        if (!useSsl) {
            log.error("Unencrypted http requests are no longer supported");
        }
        this.useSsl = true;
    }

    public boolean getReportCrashes() {
        return this.reportCrashes;
    }

    public void setReportCrashes(boolean reportCrashes) {
        this.reportCrashes = reportCrashes;
    }

    public CrashStore getCrashStore() {
        return this.crashStore;
    }

    public void setCrashStore(CrashStore crashStore) {
        this.crashStore = crashStore;
    }

    public AnalyticsEventStore getEventStore() {
        return this.eventStore;
    }

    public void setEventStore(AnalyticsEventStore eventStore) {
        this.eventStore = eventStore;
    }

    public boolean getReportHandledExceptions() {
        return this.reportHandledExceptions;
    }

    public void setReportHandledExceptions(boolean reportHandledExceptions) {
        this.reportHandledExceptions = reportHandledExceptions;
    }

    public AnalyticsAttributeStore getAnalyticsAttributeStore() {
        return this.analyticsAttributeStore;
    }

    public void setAnalyticsAttributeStore(AnalyticsAttributeStore analyticsAttributeStore) {
        this.analyticsAttributeStore = analyticsAttributeStore;
    }

    public boolean getEnableAnalyticsEvents() {
        return this.enableAnalyticsEvents;
    }

    public void setEnableAnalyticsEvents(boolean enableAnalyticsEvents) {
        this.enableAnalyticsEvents = enableAnalyticsEvents;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public String getCustomApplicationVersion() {
        return this.customApplicationVersion;
    }

    public void setCustomApplicationVersion(String customApplicationVersion) {
        this.customApplicationVersion = customApplicationVersion;
    }

    public String getCustomBuildIdentifier() {
        return this.customBuildId;
    }

    public void setCustomBuildIdentifier(String customBuildId) {
        this.customBuildId = customBuildId;
    }

    public ApplicationFramework getApplicationFramework() {
        return this.applicationFramework;
    }

    public void setApplicationFramework(ApplicationFramework ApplicationFramework2) {
        this.applicationFramework = ApplicationFramework2;
    }

    public String getApplicationFrameworkVersion() {
        return this.applicationFrameworkVersion;
    }

    public void setApplicationFrameworkVersion(String applicationFrameworkVersion) {
        this.applicationFrameworkVersion = applicationFrameworkVersion;
    }

    protected String provideSessionId() {
        this.sessionID = UUID.randomUUID().toString();
        return this.sessionID;
    }

    public String getHexCollectorPath() {
        return HEX_COLLECTOR_PATH;
    }

    public String getHexCollectorHost() {
        return this.getCollectorHost();
    }

    public int getHexCollectorTimeout() {
        return 5000;
    }

    public String getAppTokenHeader() {
        return "X-App-License-Key";
    }

    public String getAppVersionHeader() {
        return "X-NewRelic-App-Version";
    }

    public String getDeviceOsNameHeader() {
        return "X-NewRelic-OS-Name";
    }

    public int getIOThreadSize() {
        return 3;
    }

    public PayloadStore<Payload> getPayloadStore() {
        return this.payloadStore;
    }

    public void setPayloadStore(PayloadStore<Payload> payloadStore) {
        this.payloadStore = payloadStore;
    }

    public int getPayloadTTL() {
        return 172800000;
    }

    String getDefaultCollectorHost() {
        return DEFAULT_COLLECTOR_HOST;
    }

    String getDefaultCrashCollectorHost() {
        return DEFAULT_CRASH_COLLECTOR_HOST;
    }

    String getRegionalCollectorFromLicenseKey(String key) {
        String region = this.parseRegionFromApplicationToken(key);
        if (region != null && !"".equals(key)) {
            return String.format(DEFAULT_REGION_COLLECTOR_HOST, region);
        }
        return DEFAULT_COLLECTOR_HOST;
    }

    String getFedRampCollectorHost() {
        return DEFAULT_FED_RAMP_COLLECTOR_HOST;
    }

    String getFedRampCrashCollectorHost() {
        return DEFAULT_FED_RAMP_CRASH_COLLECTOR_HOST;
    }

    String parseRegionFromApplicationToken(String applicationToken) {
        if (null == applicationToken || "".equals(applicationToken)) {
            return null;
        }
        Pattern pattern = Pattern.compile("^(.+?)x{1,2}.*");
        Matcher matcher = pattern.matcher(applicationToken);
        if (matcher.matches()) {
            try {
                String prefix = matcher.group(1);
                if (prefix != null && !"".equals(prefix)) {
                    return prefix;
                }
                log.warn("Region prefix empty");
            }
            catch (Exception e) {
                log.error("getRegionalCollectorFromLicenseKey: " + e);
            }
        }
        return null;
    }

    public void setDeviceID(String deviceUUID) {
        if (deviceUUID == null) {
            this.deviceID = DEFAULT_DEVICE_UUID;
        } else if ((deviceUUID = deviceUUID.trim()).isEmpty()) {
            this.deviceID = DEFAULT_DEVICE_UUID;
        } else {
            if (deviceUUID.length() > 40) {
                StatsEngine.get().inc("Mobile/App/UUID/Truncated");
            }
            this.deviceID = deviceUUID.substring(0, Math.min(40, deviceUUID.length()));
        }
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    public String getLaunchActivityClassName() {
        return this.launchActivityClassName;
    }

    public void setLaunchActivityClassName(String launchActivityClassName) {
        this.launchActivityClassName = launchActivityClassName;
    }
}

