/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.analytics;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.analytics.AnalyticsAttribute;
import com.newrelic.agent.android.analytics.AnalyticsEventCategory;
import com.newrelic.agent.android.analytics.AnalyticsValidator;
import com.newrelic.agent.android.harvest.type.HarvestableObject;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.com.google.gson.Gson;
import com.newrelic.com.google.gson.JsonArray;
import com.newrelic.com.google.gson.JsonElement;
import com.newrelic.com.google.gson.JsonObject;
import com.newrelic.com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class AnalyticsEvent
extends HarvestableObject {
    protected static final AgentLog log = AgentLogManager.getAgentLog();
    public static final String EVENT_TYPE_MOBILE = "Mobile";
    public static final String EVENT_TYPE_MOBILE_REQUEST = "MobileRequest";
    public static final String EVENT_TYPE_MOBILE_REQUEST_ERROR = "MobileRequestError";
    public static final String EVENT_TYPE_MOBILE_BREADCRUMB = "MobileBreadcrumb";
    public static final String EVENT_TYPE_MOBILE_CRASH = "MobileCrash";
    public static final String EVENT_TYPE_MOBILE_USER_ACTION = "MobileUserAction";
    public static final int EVENT_NAME_MAX_LENGTH = 255;
    public static final int EVENT_TYPE_LIMIT = 250;
    public static final String EVENT_NAME_IS_TYPE = null;
    protected String uuid;
    protected String name;
    protected long timestamp;
    protected AnalyticsEventCategory category;
    protected String eventType;
    protected Set<AnalyticsAttribute> attributeSet = Collections.synchronizedSet(new HashSet());
    protected static final AnalyticsValidator validator = new AnalyticsValidator();

    public AnalyticsEvent(String name) {
        this(name, AnalyticsEventCategory.Custom, null, null);
    }

    protected AnalyticsEvent(String name, AnalyticsEventCategory category) {
        this(name, category, null, null);
    }

    protected AnalyticsEvent(String name, AnalyticsEventCategory category, String eventType, Set<AnalyticsAttribute> initialAttributeSet) {
        this(name, category, eventType, System.currentTimeMillis(), initialAttributeSet);
    }

    AnalyticsEvent(AnalyticsEvent analyticsEvent) {
        this(analyticsEvent.name, analyticsEvent.category, analyticsEvent.eventType, analyticsEvent.timestamp, analyticsEvent.attributeSet);
    }

    AnalyticsEvent(String name, AnalyticsEventCategory category, String eventType, long timeStamp, Set<AnalyticsAttribute> initialAttributeSet) {
        this.uuid = UUID.randomUUID().toString();
        this.name = name;
        this.timestamp = timeStamp;
        this.category = validator.toValidCategory(category);
        this.eventType = validator.toValidEventType(eventType);
        if (initialAttributeSet != null) {
            for (AnalyticsAttribute attribute : initialAttributeSet) {
                if (!validator.isValidKeyName(attribute.getName())) continue;
                this.attributeSet.add(new AnalyticsAttribute(attribute));
            }
        }
        if (validator.isValidEventName(name)) {
            this.attributeSet.add(new AnalyticsAttribute("name", this.name));
        }
        this.attributeSet.add(new AnalyticsAttribute("timestamp", String.valueOf(this.timestamp)));
        this.attributeSet.add(new AnalyticsAttribute("category", this.category.name()));
        this.attributeSet.add(new AnalyticsAttribute("eventType", this.eventType));
        if (FeatureFlag.featureEnabled(FeatureFlag.OfflineStorage) && !Agent.hasReachableNetworkConnection(null)) {
            this.attributeSet.add(new AnalyticsAttribute("offline", true));
        }
    }

    public void addAttributes(Set<AnalyticsAttribute> newAttributes) {
        if (newAttributes != null) {
            for (AnalyticsAttribute attribute : newAttributes) {
                if (validator.isValidAttribute(attribute) && this.attributeSet.add(attribute)) continue;
                log.error("Failed to add attribute " + attribute.getName() + " to event " + this.getName() + ": the attribute is invalid or the event already contains that attribute.");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public AnalyticsEventCategory getCategory() {
        return this.category;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getEventUUID() {
        return this.uuid;
    }

    public void setEventUUID(String uuid) {
        this.uuid = uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonObject asJsonObject() {
        JsonObject data = new JsonObject();
        AnalyticsEvent analyticsEvent = this;
        synchronized (analyticsEvent) {
            for (AnalyticsAttribute attribute : this.attributeSet) {
                data.add(attribute.getName(), attribute.asJsonElement());
            }
        }
        return data;
    }

    public Collection<AnalyticsAttribute> getAttributeSet() {
        return Collections.unmodifiableCollection(this.attributeSet);
    }

    Collection<AnalyticsAttribute> getMutableAttributeSet() {
        Set<AnalyticsAttribute> collection = Collections.checkedSet(this.attributeSet, AnalyticsAttribute.class);
        collection.add(new AnalyticsAttribute("mutable", true));
        return collection;
    }

    public static AnalyticsEvent newFromJson(JsonObject analyticsEventJson) {
        Iterator<Map.Entry<String, JsonElement>> entry = analyticsEventJson.entrySet().iterator();
        String name = null;
        String eventType = null;
        AnalyticsEventCategory category = null;
        long timestamp = 0L;
        HashSet<AnalyticsAttribute> attributeSet = new HashSet<AnalyticsAttribute>();
        while (entry.hasNext()) {
            Map.Entry<String, JsonElement> elem = entry.next();
            String key = elem.getKey();
            if (key.equalsIgnoreCase("name")) {
                name = elem.getValue().getAsString();
                continue;
            }
            if (key.equalsIgnoreCase("category")) {
                category = AnalyticsEventCategory.fromString(elem.getValue().getAsString());
                continue;
            }
            if (key.equalsIgnoreCase("eventType")) {
                eventType = elem.getValue().getAsString();
                continue;
            }
            if (key.equalsIgnoreCase("timestamp")) {
                timestamp = elem.getValue().getAsLong();
                continue;
            }
            JsonPrimitive value = elem.getValue().getAsJsonPrimitive();
            if (value.isString()) {
                attributeSet.add(new AnalyticsAttribute(key, value.getAsString(), false));
                continue;
            }
            if (value.isBoolean()) {
                attributeSet.add(new AnalyticsAttribute(key, value.getAsBoolean(), false));
                continue;
            }
            if (!value.isNumber()) continue;
            attributeSet.add(new AnalyticsAttribute(key, value.getAsFloat(), false));
        }
        return new AnalyticsEvent(name, category, eventType, timestamp, attributeSet);
    }

    public static AnalyticsEvent eventFromJsonString(String uuid, String eventString) {
        JsonObject eventObj = new Gson().fromJson(eventString, JsonObject.class);
        AnalyticsEvent event = AnalyticsEvent.newFromJson(eventObj);
        event.setEventUUID(uuid);
        return event;
    }

    public static Collection<AnalyticsEvent> newFromJson(JsonArray analyticsEventsJson) {
        ArrayList<AnalyticsEvent> events = new ArrayList<AnalyticsEvent>();
        for (JsonElement e : analyticsEventsJson) {
            events.add(AnalyticsEvent.newFromJson(e.getAsJsonObject()));
        }
        return events;
    }

    boolean isValid() {
        return AnalyticsEvent.isValid(this.name, this.eventType);
    }

    static boolean isValid(String eventName, String eventType) {
        return validator.isValidEventName(eventName) && validator.isValidEventType(eventType) && !validator.isReservedEventType(eventType);
    }
}

