/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.crash;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.crash.Crash;
import com.newrelic.agent.android.crash.CrashSender;
import com.newrelic.agent.android.crash.CrashStore;
import com.newrelic.agent.android.crash.UncaughtExceptionHandler;
import com.newrelic.agent.android.harvest.DeviceInformation;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.HarvestLifecycleAware;
import com.newrelic.agent.android.payload.PayloadController;
import com.newrelic.agent.android.payload.PayloadReporter;
import com.newrelic.agent.android.payload.PayloadSender;
import com.newrelic.agent.android.stats.StatsEngine;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;

public class CrashReporter
extends PayloadReporter
implements HarvestLifecycleAware {
    protected static AtomicReference<CrashReporter> instance = new AtomicReference<Object>(null);
    private static boolean jitCrashReporting = false;
    private final UncaughtExceptionHandler uncaughtExceptionHandler = new UncaughtExceptionHandler(this);
    protected final CrashStore crashStore;

    public static CrashReporter getInstance() {
        return instance.get();
    }

    public static CrashReporter initialize(AgentConfiguration agentConfiguration) {
        instance.compareAndSet(null, new CrashReporter(agentConfiguration));
        Harvest.addHarvestListener(instance.get());
        return instance.get();
    }

    public static void shutdown() {
        if (CrashReporter.isInitialized()) {
            instance.get().stop();
            instance.set(null);
        }
    }

    public static void setReportCrashes(boolean reportCrashes) {
        if (CrashReporter.isInitialized()) {
            jitCrashReporting = reportCrashes;
        }
    }

    public static boolean getReportCrashes() {
        return jitCrashReporting;
    }

    public static UncaughtExceptionHandler getUncaughtExceptionHandler() {
        if (CrashReporter.isInitialized()) {
            return CrashReporter.instance.get().uncaughtExceptionHandler;
        }
        return null;
    }

    protected static boolean isInitialized() {
        return instance.get() != null;
    }

    protected CrashReporter(AgentConfiguration agentConfiguration) {
        super(agentConfiguration);
        this.crashStore = agentConfiguration.getCrashStore();
        this.isEnabled.set(FeatureFlag.featureEnabled(FeatureFlag.CrashReporting));
    }

    @Override
    public void start() {
        if (CrashReporter.isInitialized()) {
            if (this.isEnabled()) {
                if (this.isStarted.compareAndSet(false, true)) {
                    this.uncaughtExceptionHandler.installExceptionHandler();
                    jitCrashReporting = this.agentConfiguration.getReportCrashes();
                }
            } else {
                log.warn("CrashReporter: Crash reporting feature is disabled.");
            }
        } else {
            log.error("CrashReporter: Must initialize PayloadController first.");
        }
    }

    @Override
    protected void stop() {
        if (CrashReporter.getUncaughtExceptionHandler() != null) {
            CrashReporter.getUncaughtExceptionHandler().resetExceptionHandler();
        }
    }

    protected void reportSavedCrashes() {
        if (this.crashStore != null) {
            for (Crash crash : this.crashStore.fetchAll()) {
                if (crash.isStale()) {
                    this.crashStore.delete(crash);
                    log.info("CrashReporter: Crash [" + crash.getUuid().toString() + "] has become stale, and has been removed");
                    StatsEngine.get().inc("Supportability/AgentHealth/Crash/Removed/Stale");
                    continue;
                }
                this.reportCrash(crash);
            }
        }
    }

    protected Future reportCrash(final Crash crash) {
        boolean hasValidDataToken = Harvest.getHarvestConfiguration().getDataToken().isValid();
        if (this.isEnabled()) {
            if (hasValidDataToken) {
                if (crash != null) {
                    CrashSender sender = new CrashSender(crash, this.agentConfiguration);
                    PayloadSender.CompletionHandler completionHandler = new PayloadSender.CompletionHandler(){

                        @Override
                        public void onResponse(PayloadSender payloadSender) {
                            if (payloadSender.isSuccessfulResponse()) {
                                if (CrashReporter.this.crashStore != null) {
                                    CrashReporter.this.crashStore.delete(crash);
                                }
                                DeviceInformation deviceInformation = Agent.getDeviceInformation();
                                String name = "Supportability/Mobile/Android/<framework>/<destination>/<subdestination>/Output/Bytes".replace("<framework>", deviceInformation.getApplicationFramework().name()).replace("<destination>", "Collector").replace("<subdestination>", "mobile_crash");
                                StatsEngine.get().sampleMetricDataUsage(name, crash.asJsonObject().toString().getBytes().length, 0.0f);
                            } else if (FeatureFlag.featureEnabled(FeatureFlag.OfflineStorage)) {
                                log.warn("CrashReporter didn't send due to lack of network connection");
                                StatsEngine.get().inc("OfflineStorage/Crashes");
                            }
                        }

                        @Override
                        public void onException(PayloadSender payloadSender, Exception e) {
                            log.error("CrashReporter: Crash upload failed: " + e);
                        }
                    };
                    if (!sender.shouldUploadOpportunistically()) {
                        log.warn("CrashReporter: network is unreachable. Crash will be uploaded on next app launch");
                    }
                    return PayloadController.submitPayload(sender, completionHandler);
                }
                log.warn("CrashReporter: attempted to report null crash.");
            } else {
                log.warn("CrashReporter: agent has not successfully connected and cannot report crashes.");
            }
        }
        return null;
    }

    public void storeAndReportCrash(Crash crash) {
        boolean stored = false;
        if (this.crashStore != null) {
            if (crash != null) {
                stored = this.crashStore.store(crash);
                if (!stored) {
                    log.warn("CrashReporter: failed to store passed crash.");
                }
            } else {
                log.warn("CrashReporter: attempted to store null crash.");
            }
        } else {
            log.warn("CrashReporter: attempted to store crash without a crash store.");
        }
        try {
            if (jitCrashReporting) {
                this.reportCrash(crash);
            } else if (stored) {
                log.debug("CrashReporter: Crash has been recorded and will be uploaded during the next app launch.");
            } else {
                log.error("CrashReporter: Crash was dropped (Crash not stored and Just-in-time crash reporting is disabled).");
            }
        }
        catch (Exception e) {
            log.warn("CrashReporter.storeAndReportCrash(Crash): " + e);
        }
    }

    @Override
    public void onHarvestStart() {
    }

    @Override
    public void onHarvestStop() {
    }

    @Override
    public void onHarvestBefore() {
    }

    @Override
    public void onHarvest() {
    }

    @Override
    public void onHarvestFinalize() {
    }

    @Override
    public void onHarvestError() {
    }

    @Override
    public void onHarvestSendFailed() {
    }

    @Override
    public void onHarvestComplete() {
    }

    @Override
    public void onHarvestConnected() {
        PayloadController.submitCallable(new Callable(){

            public Void call() {
                CrashReporter.this.reportSavedCrashes();
                return null;
            }
        });
    }

    @Override
    public void onHarvestDisconnected() {
    }

    @Override
    public void onHarvestDisabled() {
    }
}

