/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.harvest;

import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.activity.config.ActivityTraceConfiguration;
import com.newrelic.agent.android.analytics.AnalyticsControllerImpl;
import com.newrelic.agent.android.analytics.SessionEvent;
import com.newrelic.agent.android.harvest.ActivityTraces;
import com.newrelic.agent.android.harvest.AgentHealthException;
import com.newrelic.agent.android.harvest.ConnectInformation;
import com.newrelic.agent.android.harvest.HarvestConfiguration;
import com.newrelic.agent.android.harvest.HarvestConnection;
import com.newrelic.agent.android.harvest.HarvestData;
import com.newrelic.agent.android.harvest.HarvestDataValidator;
import com.newrelic.agent.android.harvest.HarvestLifecycleAware;
import com.newrelic.agent.android.harvest.HarvestTimer;
import com.newrelic.agent.android.harvest.HarvestableCache;
import com.newrelic.agent.android.harvest.Harvester;
import com.newrelic.agent.android.harvest.HttpTransaction;
import com.newrelic.agent.android.harvest.HttpTransactions;
import com.newrelic.agent.android.harvest.type.Harvestable;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.metric.Metric;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.tracing.ActivityTrace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public class Harvest {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private static final boolean DISABLE_ACTIVITY_TRACE_LIMITS_FOR_DEBUGGING = false;
    public static final long INVALID_SESSION_DURATION = 0L;
    protected static Harvest instance = new Harvest();
    private Harvester harvester;
    private HarvestConnection harvestConnection;
    private HarvestTimer harvestTimer;
    protected HarvestData harvestData;
    private HarvestDataValidator harvestDataValidator;
    private static final Collection<HarvestLifecycleAware> unregisteredLifecycleListeners = new ArrayList<HarvestLifecycleAware>();
    private static final HarvestableCache activityTraceCache = new HarvestableCache();
    private HarvestConfiguration configuration = HarvestConfiguration.getDefaultHarvestConfiguration();

    public static void initialize(AgentConfiguration agentConfiguration) {
        instance.initializeHarvester(agentConfiguration);
        Harvest.registerUnregisteredListeners();
        Harvest.addHarvestListener(StatsEngine.get());
    }

    public void initializeHarvester(AgentConfiguration agentConfiguration) {
        this.createHarvester();
        this.harvester.setAgentConfiguration(agentConfiguration);
        this.harvester.setConfiguration(instance.getConfiguration());
        this.flushHarvestableCaches();
    }

    public static void start() {
        if (instance.getHarvestTimer() != null) {
            instance.getHarvestTimer().start();
        } else {
            log.error("Harvest timer is null");
        }
    }

    public static void stop() {
        if (instance.getHarvestTimer() != null) {
            instance.getHarvestTimer().stop();
        } else {
            log.error("Harvest timer is null");
        }
    }

    public static void harvestNow(boolean finalizeSession) {
        HarvestTimer harvestTimer;
        if (!Harvest.isInitialized()) {
            return;
        }
        if (finalizeSession) {
            instance.finalizeSession();
            AnalyticsControllerImpl.getInstance().getEventManager().setTransmitRequired();
        }
        if ((harvestTimer = instance.getHarvestTimer()) != null) {
            harvestTimer.tickNow();
        }
    }

    public static void setInstance(Harvest harvestInstance) {
        if (harvestInstance == null) {
            log.error("Attempt to set Harvest instance to null value!");
        } else {
            instance = harvestInstance;
        }
    }

    public void createHarvester() {
        this.harvestConnection = new HarvestConnection();
        this.harvestData = new HarvestData();
        this.harvester = new Harvester();
        this.harvester.setHarvestConnection(this.harvestConnection);
        this.harvester.setHarvestData(this.harvestData);
        this.harvestTimer = new HarvestTimer(this.harvester);
        this.harvestDataValidator = new HarvestDataValidator();
        Harvest.addHarvestListener(this.harvestDataValidator);
    }

    public void shutdownHarvester() {
        this.harvestTimer.shutdown();
        this.harvestTimer = null;
        this.harvester = null;
        this.harvestConnection = null;
        this.harvestData = null;
    }

    public static void shutdown() {
        if (Harvest.isInitialized()) {
            Harvest.stop();
            instance.shutdownHarvester();
        }
    }

    public static void addHttpTransaction(HttpTransaction txn) {
        if (Harvest.isDisabled()) {
            return;
        }
        HttpTransactions transactions = instance.getHarvestData().getHttpTransactions();
        instance.getHarvester().expireHttpTransactions();
        int transactionLimit = instance.getConfiguration().getReport_max_transaction_count();
        if (transactions.count() >= transactionLimit) {
            StatsEngine.get().inc("Supportability/AgentHealth/TransactionsDropped");
            log.debug("Maximum number of transactions (" + transactionLimit + ") reached. HTTP Transaction dropped.");
            return;
        }
        transactions.add(txn);
        AnalyticsControllerImpl analyticsController = AnalyticsControllerImpl.getInstance();
        analyticsController.createNetworkRequestEvents(txn);
    }

    public static void addActivityTrace(ActivityTrace activityTrace) {
        boolean isBelowMinUtilization;
        if (Harvest.isDisabled()) {
            return;
        }
        if (!Harvest.isInitialized()) {
            activityTraceCache.add(activityTrace);
            return;
        }
        if (activityTrace.rootTrace == null) {
            log.error("Activity trace is lacking a root trace!");
            return;
        }
        if (activityTrace.rootTrace.childExclusiveTime == 0L) {
            log.error("Total trace exclusive time is zero. Ignoring trace " + activityTrace.rootTrace.displayName);
            return;
        }
        double traceUtilization = (double)activityTrace.rootTrace.childExclusiveTime / (double)activityTrace.rootTrace.getDurationAsMilliseconds();
        boolean bl = isBelowMinUtilization = traceUtilization < instance.getConfiguration().getActivity_trace_min_utilization();
        if (isBelowMinUtilization) {
            StatsEngine.get().inc("Supportability/AgentHealth/IgnoredTraces");
            log.debug("Exclusive trace time is too low (" + activityTrace.rootTrace.childExclusiveTime + "/" + activityTrace.rootTrace.getDurationAsMilliseconds() + "). Ignoring trace " + activityTrace.rootTrace.displayName);
            return;
        }
        ActivityTraces activityTraces = instance.getHarvestData().getActivityTraces();
        ActivityTraceConfiguration configurations = instance.getActivityTraceConfiguration();
        instance.getHarvester().expireActivityTraces();
        if (activityTraces.count() >= configurations.getMaxTotalTraceCount()) {
            log.debug("Activity trace limit of " + configurations.getMaxTotalTraceCount() + " exceeded. Ignoring trace: " + activityTrace.toJsonString());
            return;
        }
        log.debug("Adding activity trace: " + activityTrace.toJsonString());
        activityTraces.add(activityTrace);
    }

    public static void addMetric(Metric metric) {
        if (Harvest.isDisabled() || !Harvest.isInitialized()) {
            return;
        }
        instance.getHarvestData().getMetrics().addMetric(metric);
    }

    public static void addAgentHealthException(AgentHealthException exception) {
        if (Harvest.isDisabled() || !Harvest.isInitialized()) {
            return;
        }
        instance.getHarvestData().getAgentHealth().addException(exception);
    }

    public static void addHarvestListener(HarvestLifecycleAware harvestAware) {
        if (harvestAware == null) {
            log.error("Harvest: Argument to addHarvestListener cannot be null.");
            return;
        }
        if (!Harvest.isInitialized()) {
            if (!Harvest.isUnregisteredListener(harvestAware)) {
                Harvest.addUnregisteredListener(harvestAware);
            }
            return;
        }
        instance.getHarvester().addHarvestListener(harvestAware);
    }

    public static void removeHarvestListener(HarvestLifecycleAware harvestAware) {
        if (harvestAware == null) {
            log.error("Harvest: Argument to removeHarvestListener cannot be null.");
            return;
        }
        if (!Harvest.isInitialized()) {
            if (Harvest.isUnregisteredListener(harvestAware)) {
                Harvest.removeUnregisteredListener(harvestAware);
            }
            return;
        }
        instance.getHarvester().removeHarvestListener(harvestAware);
    }

    public static boolean isInitialized() {
        return instance != null && instance.getHarvester() != null;
    }

    public static int getActivityTraceCacheSize() {
        return activityTraceCache.getSize();
    }

    public static long getMillisSinceStart() {
        long lTime = 0L;
        Harvest harvest = Harvest.getInstance();
        if (harvest != null && harvest.getHarvestTimer() != null && (lTime = harvest.getHarvestTimer().timeSinceStart()) < 0L) {
            lTime = 0L;
        }
        return lTime;
    }

    public static boolean shouldCollectActivityTraces() {
        if (Harvest.isDisabled()) {
            return false;
        }
        if (!Harvest.isInitialized()) {
            return true;
        }
        ActivityTraceConfiguration configurations = instance.getActivityTraceConfiguration();
        if (configurations == null) {
            return true;
        }
        return configurations.getMaxTotalTraceCount() > 0;
    }

    private void flushHarvestableCaches() {
        try {
            this.flushActivityTraceCache();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void flushActivityTraceCache() {
        Collection<Harvestable> activityTraces = activityTraceCache.flush();
        for (Harvestable activityTrace : activityTraces) {
            Harvest.addActivityTrace((ActivityTrace)activityTrace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addUnregisteredListener(HarvestLifecycleAware harvestAware) {
        if (harvestAware == null) {
            return;
        }
        Collection<HarvestLifecycleAware> collection = unregisteredLifecycleListeners;
        synchronized (collection) {
            unregisteredLifecycleListeners.add(harvestAware);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeUnregisteredListener(HarvestLifecycleAware harvestAware) {
        if (harvestAware == null) {
            return;
        }
        Collection<HarvestLifecycleAware> collection = unregisteredLifecycleListeners;
        synchronized (collection) {
            unregisteredLifecycleListeners.remove(harvestAware);
        }
    }

    private static void registerUnregisteredListeners() {
        for (HarvestLifecycleAware harvestAware : unregisteredLifecycleListeners) {
            Harvest.addHarvestListener(harvestAware);
        }
        unregisteredLifecycleListeners.clear();
    }

    private static boolean isUnregisteredListener(HarvestLifecycleAware harvestAware) {
        if (harvestAware == null) {
            return false;
        }
        return unregisteredLifecycleListeners.contains(harvestAware);
    }

    protected HarvestTimer getHarvestTimer() {
        return this.harvestTimer;
    }

    public static Harvest getInstance() {
        return instance;
    }

    protected Harvester getHarvester() {
        return this.harvester;
    }

    public HarvestData getHarvestData() {
        return this.harvestData;
    }

    public HarvestConfiguration getConfiguration() {
        return this.configuration;
    }

    public HarvestConnection getHarvestConnection() {
        return this.harvestConnection;
    }

    public void setHarvestConnection(HarvestConnection connection) {
        this.harvestConnection = connection;
    }

    public boolean shouldCollectNetworkErrors() {
        return this.configuration.isCollect_network_errors();
    }

    public void setConfiguration(HarvestConfiguration newConfiguration) {
        this.configuration.reconfigure(newConfiguration);
        this.harvestTimer.setPeriod(TimeUnit.MILLISECONDS.convert(this.configuration.getData_report_period(), TimeUnit.SECONDS));
        this.harvestConnection.setServerTimestamp(this.configuration.getServer_timestamp());
        this.harvestData.setDataToken(this.configuration.getDataToken());
        this.harvester.setConfiguration(this.configuration);
    }

    public void setConnectInformation(ConnectInformation connectInformation) {
        this.harvestConnection.setConnectInformation(connectInformation);
        this.harvestData.setDeviceInformation(connectInformation.getDeviceInformation());
    }

    public static void setHarvestConfiguration(HarvestConfiguration configuration) {
        if (!Harvest.isInitialized()) {
            log.error("Cannot configure Harvester before initialization.");
            new Exception().printStackTrace();
            return;
        }
        log.debug("Harvest Configuration: " + configuration);
        instance.setConfiguration(configuration);
    }

    public static HarvestConfiguration getHarvestConfiguration() {
        if (!Harvest.isInitialized()) {
            return HarvestConfiguration.getDefaultHarvestConfiguration();
        }
        return instance.getConfiguration();
    }

    public static void setHarvestConnectInformation(ConnectInformation connectInformation) {
        if (!Harvest.isInitialized()) {
            log.error("Cannot configure Harvester before initialization.");
            new Exception().printStackTrace();
            return;
        }
        log.debug("Setting Harvest connect information: " + connectInformation);
        instance.setConnectInformation(connectInformation);
    }

    public static boolean isDisabled() {
        if (!Harvest.isInitialized()) {
            return false;
        }
        return instance.getHarvester().isDisabled();
    }

    protected ActivityTraceConfiguration getActivityTraceConfiguration() {
        return this.configuration.getAt_capture();
    }

    void finalizeSession() {
        long sessionDuration = Harvest.getMillisSinceStart();
        if (sessionDuration == 0L) {
            log.error("Session duration is invalid!");
            StatsEngine.get().inc("Supportability/AgentHealth/Session/InvalidDuration");
        }
        float sessionDurationAsSeconds = (float)sessionDuration / 1000.0f;
        StatsEngine.get().sample("Session/Duration", sessionDurationAsSeconds);
        log.debug("Harvest: Generating sessionDuration attribute with value " + sessionDurationAsSeconds);
        AnalyticsControllerImpl analyticsController = AnalyticsControllerImpl.getInstance();
        analyticsController.setAttribute("sessionDuration", sessionDurationAsSeconds, false);
        log.debug("Harvest: Generating session event.");
        SessionEvent sessionEvent = new SessionEvent();
        analyticsController.addEvent(sessionEvent);
    }
}

