/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.hybrid;

import com.newrelic.agent.android.hybrid.Stack;
import com.newrelic.agent.android.hybrid.StackFrame;
import com.newrelic.agent.android.hybrid.StackTraceException;
import com.newrelic.agent.android.hybrid.rninterface.IStack;
import com.newrelic.agent.android.hybrid.rninterface.IStackTrace;
import com.newrelic.agent.android.hybrid.rninterface.IStackTraceException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class StackTrace
extends Throwable
implements IStackTrace {
    private final UUID stackId;
    private final boolean isFatal;
    private final IStackTraceException rnStackTraceException;
    private final String buildId;
    private IStack[] rnStacks = null;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public StackTrace(String errorName, String errorMessage, String errorStack, boolean isFatal, String buildId) {
        this(errorName, errorMessage, errorStack, isFatal, buildId, null);
    }

    public StackTrace(String errorName, String errorMessage, String errorStack, boolean isFatal, String buildId, Map<String, Object> attributes) {
        if (errorStack == null || errorStack.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a RNStackTrace without a stack.");
        }
        this.stackId = UUID.randomUUID();
        this.isFatal = isFatal;
        this.buildId = buildId;
        if (attributes != null) {
            this.attributes = attributes;
        }
        String[] stringStackTrace = errorStack.split("\n");
        String exName = errorName;
        String exCause = errorMessage;
        if (errorName == null || errorName.isEmpty()) {
            exName = errorStack.split("\n")[0];
        }
        if (errorMessage == null || errorMessage.isEmpty()) {
            exCause = errorStack.split("\n")[0];
        }
        this.rnStackTraceException = new StackTraceException(exName, exCause);
        int stackLength = stringStackTrace.length - 1;
        if (stackLength > 0) {
            StackFrame[] rnStackFrames = new StackFrame[stackLength];
            for (int i = 1; i < stackLength + 1; ++i) {
                StackFrame frame;
                rnStackFrames[i - 1] = frame = new StackFrame(stringStackTrace[i]);
            }
            this.rnStacks = new Stack[1];
            this.rnStacks[0] = new Stack(rnStackFrames);
        }
    }

    @Override
    public String getStackId() {
        return this.stackId.toString();
    }

    @Override
    public String getStackType() {
        return "ReactNative";
    }

    @Override
    public boolean isFatal() {
        return this.isFatal;
    }

    @Override
    public IStack[] getStacks() {
        return this.rnStacks;
    }

    @Override
    public IStackTraceException getStackTraceException() {
        return this.rnStackTraceException;
    }

    @Override
    public String getBuildId() {
        return this.buildId;
    }

    @Override
    public Map<String, Object> getCustomAttributes() {
        return this.attributes;
    }
}

