/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.stores;

import android.content.Context;
import android.content.SharedPreferences;
import com.newrelic.agent.android.analytics.AnalyticsEvent;
import com.newrelic.agent.android.analytics.AnalyticsEventStore;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.stores.SharedPrefsStore;
import com.newrelic.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SharedPrefsEventStore
extends SharedPrefsStore
implements AnalyticsEventStore {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private static final String STORE_FILE = "NREventStore";

    public SharedPrefsEventStore(Context context) {
        this(context, STORE_FILE);
    }

    public SharedPrefsEventStore(Context context, String storeFilename) {
        super(context, storeFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean store(AnalyticsEvent event) {
        SharedPrefsEventStore sharedPrefsEventStore = this;
        synchronized (sharedPrefsEventStore) {
            try {
                JsonObject jsonObj = event.asJsonObject();
                String eventJson = jsonObj.toString();
                SharedPreferences.Editor editor = this.sharedPrefs.edit();
                editor.putString(event.getEventUUID(), eventJson);
                StatsEngine.SUPPORTABILITY.inc("Supportability/Events/Size/Uncompressed", eventJson.length());
                return editor.commit();
            }
            catch (Exception e) {
                log.error("SharedPrefsStore.store(String, String): ", e);
            }
        }
        return false;
    }

    @Override
    public List<AnalyticsEvent> fetchAll() {
        ArrayList<AnalyticsEvent> events = new ArrayList<AnalyticsEvent>();
        Map objectStrings = this.sharedPrefs.getAll();
        for (Map.Entry entry : objectStrings.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            try {
                events.add(AnalyticsEvent.eventFromJsonString(((String)entry.getKey()).toString(), (String)entry.getValue()));
            }
            catch (Exception e) {
                log.error("Exception encountered while deserializing event", e);
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(AnalyticsEvent event) {
        try {
            SharedPrefsEventStore sharedPrefsEventStore = this;
            synchronized (sharedPrefsEventStore) {
                SharedPreferences.Editor editor = this.sharedPrefs.edit();
                editor.remove(event.getEventUUID()).commit();
            }
        }
        catch (Exception e) {
            log.error("SharedPrefsEventStore.delete(): ", e);
        }
    }
}

