/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android;

import android.app.ActivityManager;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.os.Build;
import android.os.Environment;
import android.os.Looper;
import android.os.StatFs;
import android.text.TextUtils;
import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.AgentImpl;
import com.newrelic.agent.android.AgentInitializationException;
import com.newrelic.agent.android.ApplicationExitMonitor;
import com.newrelic.agent.android.ApplicationFramework;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.InstantApps;
import com.newrelic.agent.android.MeasurementEngine;
import com.newrelic.agent.android.Measurements;
import com.newrelic.agent.android.NewRelic;
import com.newrelic.agent.android.NullAgentImpl;
import com.newrelic.agent.android.SavedState;
import com.newrelic.agent.android.analytics.AnalyticsAttribute;
import com.newrelic.agent.android.analytics.AnalyticsControllerImpl;
import com.newrelic.agent.android.analytics.AnalyticsEvent;
import com.newrelic.agent.android.analytics.EventManager;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.api.v1.ConnectionEvent;
import com.newrelic.agent.android.api.v1.ConnectionListener;
import com.newrelic.agent.android.api.v1.DeviceForm;
import com.newrelic.agent.android.api.v2.TraceMachineInterface;
import com.newrelic.agent.android.background.ApplicationStateEvent;
import com.newrelic.agent.android.background.ApplicationStateListener;
import com.newrelic.agent.android.background.ApplicationStateMonitor;
import com.newrelic.agent.android.distributedtracing.UserActionFacade;
import com.newrelic.agent.android.distributedtracing.UserActionType;
import com.newrelic.agent.android.harvest.AgentHealth;
import com.newrelic.agent.android.harvest.ApplicationInformation;
import com.newrelic.agent.android.harvest.ConnectInformation;
import com.newrelic.agent.android.harvest.DeviceInformation;
import com.newrelic.agent.android.harvest.EnvironmentInformation;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.HarvestData;
import com.newrelic.agent.android.harvest.HarvestLifecycleAware;
import com.newrelic.agent.android.harvest.MachineMeasurements;
import com.newrelic.agent.android.instrumentation.MetricCategory;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.metric.Metric;
import com.newrelic.agent.android.metric.MetricUnit;
import com.newrelic.agent.android.ndk.NativeReporting;
import com.newrelic.agent.android.payload.PayloadController;
import com.newrelic.agent.android.sample.MachineMeasurementConsumer;
import com.newrelic.agent.android.sample.Sampler;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.stores.SharedPrefsAnalyticsAttributeStore;
import com.newrelic.agent.android.stores.SharedPrefsCrashStore;
import com.newrelic.agent.android.stores.SharedPrefsEventStore;
import com.newrelic.agent.android.stores.SharedPrefsPayloadStore;
import com.newrelic.agent.android.tracing.TraceMachine;
import com.newrelic.agent.android.util.ActivityLifecycleBackgroundListener;
import com.newrelic.agent.android.util.AndroidEncoder;
import com.newrelic.agent.android.util.Connectivity;
import com.newrelic.agent.android.util.Encoder;
import com.newrelic.agent.android.util.OfflineStorage;
import com.newrelic.agent.android.util.PersistentUUID;
import com.newrelic.agent.android.util.Reachability;
import com.newrelic.agent.android.util.UiBackgroundListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AndroidAgentImpl
implements AgentImpl,
ConnectionListener,
ApplicationStateListener,
TraceMachineInterface,
HarvestLifecycleAware {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private final Context context;
    private SavedState savedState;
    private final Lock lock = new ReentrantLock();
    private final Encoder encoder = new AndroidEncoder();
    DeviceInformation deviceInformation;
    private ApplicationInformation applicationInformation;
    private final AgentConfiguration agentConfiguration;
    private MachineMeasurementConsumer machineMeasurementConsumer;
    private OfflineStorage offlineStorageInstance;
    private static final Comparator<TransactionData> cmp = new Comparator<TransactionData>(){

        @Override
        public int compare(TransactionData lhs, TransactionData rhs) {
            if (lhs.getTimestamp() > rhs.getTimestamp()) {
                return -1;
            }
            if (lhs.getTimestamp() < rhs.getTimestamp()) {
                return 1;
            }
            return 0;
        }
    };

    public AndroidAgentImpl(Context context, AgentConfiguration agentConfiguration) throws AgentInitializationException {
        this.context = AndroidAgentImpl.appContext(context);
        this.agentConfiguration = agentConfiguration;
        this.savedState = new SavedState(this.context);
        this.offlineStorageInstance = new OfflineStorage(context);
        if (this.isDisabled()) {
            throw new AgentInitializationException("This version of the agent has been disabled");
        }
        this.initApplicationInformation();
        TraceMachine.setTraceMachineInterface(this);
        agentConfiguration.setCrashStore(new SharedPrefsCrashStore(context));
        agentConfiguration.setPayloadStore(new SharedPrefsPayloadStore(context));
        agentConfiguration.setAnalyticsAttributeStore(new SharedPrefsAnalyticsAttributeStore(context));
        agentConfiguration.setEventStore(new SharedPrefsEventStore(context));
        ApplicationStateMonitor.getInstance().addApplicationStateListener(this);
        if (Build.VERSION.SDK_INT >= 14) {
            UiBackgroundListener backgroundListener;
            if (Agent.getMonoInstrumentationFlag().equals("YES")) {
                backgroundListener = new ActivityLifecycleBackgroundListener();
                if (backgroundListener instanceof Application.ActivityLifecycleCallbacks) {
                    try {
                        if (context.getApplicationContext() instanceof Application) {
                            Application application = (Application)context.getApplicationContext();
                            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)backgroundListener);
                            if (agentConfiguration.getApplicationFramework() == ApplicationFramework.Xamarin || agentConfiguration.getApplicationFramework() == ApplicationFramework.MAUI) {
                                ApplicationStateMonitor.getInstance().activityStarted();
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
            } else {
                backgroundListener = new UiBackgroundListener();
            }
            context.registerComponentCallbacks((ComponentCallbacks)backgroundListener);
        }
        this.setupSession();
    }

    protected void initialize() {
        this.setupSession();
        AnalyticsControllerImpl.initialize(this.agentConfiguration, this);
        Harvest.addHarvestListener(this.savedState);
        Harvest.initialize(this.agentConfiguration);
        Harvest.setHarvestConfiguration(this.savedState.getHarvestConfiguration());
        Harvest.setHarvestConnectInformation(this.savedState.getConnectInformation());
        Harvest.addHarvestListener(this);
        Measurements.initialize();
        log.info(MessageFormat.format("New Relic Agent v{0}", Agent.getVersion()));
        log.verbose(MessageFormat.format("Application token: {0}", this.agentConfiguration.getApplicationToken()));
        this.machineMeasurementConsumer = new MachineMeasurementConsumer();
        Measurements.addMeasurementConsumer(this.machineMeasurementConsumer);
        StatsEngine.get().inc("Supportability/AgentHealth/UncaughtExceptionHandler/<name>".replace("<name>", this.getUnhandledExceptionHandlerName()));
        PayloadController.initialize(this.agentConfiguration);
        Sampler.init(this.context);
        if (this.isInstantApp()) {
            log.info("This appears to be an Instant App");
            AnalyticsAttribute attribute = new AnalyticsAttribute("instantApp", true);
            AnalyticsControllerImpl.getInstance().addAttributeUnchecked(attribute, false);
        }
        if (FeatureFlag.featureEnabled(FeatureFlag.NativeReporting)) {
            try {
                NativeReporting.initialize(this.context, this.agentConfiguration);
            }
            catch (NoClassDefFoundError e) {
                log.error("NativeReporting feature is enabled, but agent-ndk was not found (probably missing as a dependency).");
                log.error("Native reporting will not be enabled");
            }
        }
    }

    protected void setupSession() {
        TraceMachine.clearActivityHistory();
        this.agentConfiguration.provideSessionId();
    }

    protected void finalizeSession() {
    }

    @Override
    public boolean updateSavedConnectInformation() {
        ConnectInformation savedConnectInformation = this.savedState.getConnectInformation();
        ConnectInformation newConnectInformation = new ConnectInformation(this.getApplicationInformation(), this.getDeviceInformation());
        if (!newConnectInformation.equals(savedConnectInformation) || !this.savedState.hasConnectionToken(this.agentConfiguration.getApplicationToken())) {
            if (newConnectInformation.getApplicationInformation().isAppUpgrade(savedConnectInformation.getApplicationInformation())) {
                StatsEngine.get().inc("Mobile/App/Upgrade");
                AnalyticsAttribute attribute = new AnalyticsAttribute("upgradeFrom", savedConnectInformation.getApplicationInformation().getAppVersion());
                AnalyticsControllerImpl.getInstance().addAttributeUnchecked(attribute, false);
            }
            this.savedState.clear();
            this.savedState.saveConnectInformation(newConnectInformation);
            this.savedState.saveConnectionToken(this.agentConfiguration.getApplicationToken());
            return true;
        }
        return false;
    }

    @Override
    public DeviceInformation getDeviceInformation() {
        if (this.deviceInformation == null) {
            DeviceInformation info = new DeviceInformation();
            info.setOsName("Android");
            info.setOsVersion(Build.VERSION.RELEASE);
            info.setOsBuild(Build.VERSION.INCREMENTAL);
            info.setModel(Build.MODEL);
            info.setAgentName("AndroidAgent");
            info.setAgentVersion(Agent.getVersion());
            info.setManufacturer(Build.MANUFACTURER);
            info.setDeviceId(this.getUUID());
            info.setArchitecture(System.getProperty("os.arch"));
            info.setRunTime(System.getProperty("java.vm.version"));
            info.setSize(AndroidAgentImpl.deviceForm(this.context).name().toLowerCase(Locale.getDefault()));
            info.setApplicationFramework(this.agentConfiguration.getApplicationFramework());
            info.setApplicationFrameworkVersion(this.agentConfiguration.getApplicationFrameworkVersion());
            this.deviceInformation = info;
        }
        return this.deviceInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnvironmentInformation getEnvironmentInformation() {
        EnvironmentInformation envInfo = new EnvironmentInformation();
        ActivityManager activityManager = (ActivityManager)this.context.getSystemService("activity");
        long[] free = new long[2];
        try {
            StatFs rootStatFs = new StatFs(Environment.getRootDirectory().getAbsolutePath());
            StatFs externalStatFs = new StatFs(Environment.getExternalStorageDirectory().getAbsolutePath());
            if (Build.VERSION.SDK_INT >= 18) {
                free[0] = rootStatFs.getAvailableBlocksLong() * rootStatFs.getBlockSizeLong();
                free[1] = externalStatFs.getAvailableBlocksLong() * rootStatFs.getBlockSizeLong();
            } else {
                free[0] = rootStatFs.getAvailableBlocks() * rootStatFs.getBlockSize();
                free[1] = externalStatFs.getAvailableBlocks() * externalStatFs.getBlockSize();
            }
        }
        catch (Exception e) {
            AgentHealth.noticeException(e);
        }
        finally {
            if (free[0] < 0L) {
                free[0] = 0L;
            }
            if (free[1] < 0L) {
                free[1] = 0L;
            }
            envInfo.setDiskAvailable(free);
        }
        envInfo.setMemoryUsage(Sampler.sampleMemory(activityManager).getSampleValue().asLong());
        envInfo.setOrientation(this.context.getResources().getConfiguration().orientation);
        envInfo.setNetworkStatus(this.getNetworkCarrier());
        envInfo.setNetworkWanType(this.getNetworkWanType());
        return envInfo;
    }

    public void initApplicationInformation() throws AgentInitializationException {
        String appName;
        if (this.applicationInformation != null) {
            log.debug("attempted to reinitialize ApplicationInformation.");
            return;
        }
        String packageName = this.context.getPackageName();
        PackageManager packageManager = this.context.getPackageManager();
        PackageInfo packageInfo = null;
        try {
            packageInfo = packageManager.getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new AgentInitializationException("Could not determine package version: " + e.getMessage());
        }
        String appVersion = this.agentConfiguration.getCustomApplicationVersion();
        if (TextUtils.isEmpty((CharSequence)appVersion)) {
            if (packageInfo != null && packageInfo.versionName != null && packageInfo.versionName.length() > 0) {
                appVersion = packageInfo.versionName;
            } else {
                throw new AgentInitializationException("Your app doesn't appear to have a version defined. Ensure you have defined 'versionName' in your manifest.");
            }
        }
        log.debug("Using application version " + appVersion);
        try {
            ApplicationInfo info = packageManager.getApplicationInfo(packageName, 0);
            appName = info != null ? packageManager.getApplicationLabel(info).toString() : packageName;
        }
        catch (PackageManager.NameNotFoundException e) {
            log.warn(e.toString());
            appName = packageName;
        }
        catch (SecurityException e) {
            log.warn(e.toString());
            appName = packageName;
        }
        log.debug("Using application name " + appName);
        String build = this.agentConfiguration.getCustomBuildIdentifier();
        if (TextUtils.isEmpty((CharSequence)build)) {
            if (packageInfo != null) {
                build = String.valueOf(packageInfo.versionCode);
            } else {
                build = "";
                log.warn("Your app doesn't appear to have a version code defined. Ensure you have defined 'versionCode' in your manifest.");
            }
        }
        log.debug("Using build " + build);
        this.applicationInformation = new ApplicationInformation(appName, appVersion, packageName, build);
        this.applicationInformation.setVersionCode(packageInfo.versionCode);
    }

    @Override
    public ApplicationInformation getApplicationInformation() {
        return this.applicationInformation;
    }

    @Override
    public long getSessionDurationMillis() {
        return Harvest.getMillisSinceStart();
    }

    private static DeviceForm deviceForm(Context context) {
        int deviceSize = context.getResources().getConfiguration().screenLayout & 0xF;
        switch (deviceSize) {
            case 1: {
                return DeviceForm.SMALL;
            }
            case 2: {
                return DeviceForm.NORMAL;
            }
            case 3: {
                return DeviceForm.LARGE;
            }
        }
        if (deviceSize > 3) {
            return DeviceForm.XLARGE;
        }
        return DeviceForm.UNKNOWN;
    }

    private static Context appContext(Context context) {
        if (!(context instanceof Application)) {
            return context.getApplicationContext();
        }
        return context;
    }

    @Override
    @Deprecated
    public void addTransactionData(TransactionData transactionData) {
    }

    @Override
    @Deprecated
    public void mergeTransactionData(List<TransactionData> transactionDataList) {
    }

    @Override
    @Deprecated
    public List<TransactionData> getAndClearTransactionData() {
        return null;
    }

    @Override
    public String getCrossProcessId() {
        this.lock.lock();
        try {
            String string = this.savedState.getCrossProcessId();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getStackTraceLimit() {
        this.lock.lock();
        try {
            int n = this.savedState.getStackTraceLimit();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getResponseBodyLimit() {
        this.lock.lock();
        try {
            int n = this.savedState.getHarvestConfiguration().getResponse_body_limit();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void start() {
        if (!this.isDisabled()) {
            this.initialize();
            Harvest.start();
            if (FeatureFlag.featureEnabled(FeatureFlag.NativeReporting)) {
                try {
                    if (NativeReporting.isInitialized()) {
                        NativeReporting.getInstance().start();
                    }
                }
                catch (NoClassDefFoundError e) {
                    log.error("Native reporting is not enabled");
                }
            }
            if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
                UserActionFacade.getInstance().recordUserAction(UserActionType.AppLaunch);
            }
        } else {
            this.stop(false);
        }
    }

    @Override
    public void stop() {
        this.stop(true);
    }

    void stop(boolean finalSendData) {
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            UserActionFacade.getInstance().recordUserAction(UserActionType.AppBackground);
        }
        this.finalizeSession();
        Sampler.shutdown();
        TraceMachine.haltTracing();
        AnalyticsControllerImpl analyticsController = AnalyticsControllerImpl.getInstance();
        EventManager eventManager = analyticsController.getEventManager();
        if (!NewRelic.isShutdown) {
            int eventsRecorded = eventManager.getEventsRecorded();
            int eventsEjected = eventManager.getEventsEjected();
            Measurements.addCustomMetric("Supportability/Events/Recorded", MetricCategory.NONE.name(), eventsRecorded, eventsEjected, eventsEjected, MetricUnit.OPERATIONS, MetricUnit.OPERATIONS);
        }
        if (finalSendData) {
            if (this.isUIThread()) {
                StatsEngine.get().inc("Supportability/AgentHealth/HarvestOnMainThread");
            }
            try {
                if (NewRelic.isStarted() && NewRelic.isShutdown) {
                    this.clearExistingData();
                    HarvestData harvestData = Harvest.getInstance().getHarvestData();
                    if (harvestData != null && harvestData.getMetrics() != null) {
                        MachineMeasurements metrics = Harvest.getInstance().getHarvestData().getMetrics();
                        for (Map.Entry<String, Metric> entry : StatsEngine.notice().getStatsMap().entrySet()) {
                            metrics.addMetric(entry.getValue());
                        }
                    }
                }
            }
            catch (Exception ex) {
                log.error("There is an error during shutdown process: " + ex.getLocalizedMessage());
            }
            Harvest.harvestNow(true, true);
            HarvestData harvestData = Harvest.getInstance().getHarvestData();
            log.debug("EventManager: recorded[" + eventManager.getEventsRecorded() + "] ejected[" + eventManager.getEventsEjected() + "]");
            if (harvestData != null && harvestData.isValid()) {
                Collection<AnalyticsEvent> events = harvestData.getAnalyticsEvents();
                if (!events.isEmpty()) {
                    log.warn("Agent stopped with " + events.size() + " events dropped from failed harvest.");
                }
                if (0 < eventManager.size()) {
                    log.warn("Agent stopped with " + eventManager.size() + " events left in event pool.");
                }
            }
        }
        if (FeatureFlag.featureEnabled(FeatureFlag.NativeReporting)) {
            try {
                NativeReporting.shutdown();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        AnalyticsControllerImpl.shutdown();
        TraceMachine.clearActivityHistory();
        Harvest.shutdown();
        Measurements.shutdown();
        PayloadController.shutdown();
    }

    @Override
    public void disable() {
        log.warn("PERMANENTLY DISABLING AGENT v" + Agent.getVersion());
        try {
            this.savedState.saveDisabledVersion(Agent.getVersion());
        }
        finally {
            try {
                this.stop(false);
            }
            finally {
                Agent.setImpl(NullAgentImpl.instance);
            }
        }
    }

    @Override
    public boolean isDisabled() {
        return Agent.getVersion().equals(this.savedState.getDisabledVersion());
    }

    @Override
    public String getNetworkCarrier() {
        return Connectivity.carrierNameFromContext(this.context);
    }

    @Override
    public String getNetworkWanType() {
        return Connectivity.wanType(this.context);
    }

    public static void init(Context context, AgentConfiguration agentConfiguration) {
        try {
            Agent.setImpl(new AndroidAgentImpl(context, agentConfiguration));
            Agent.start();
        }
        catch (AgentInitializationException e) {
            log.error("Failed to initialize the agent: " + e.toString());
        }
    }

    @Override
    @Deprecated
    public void connected(ConnectionEvent e) {
        log.error("AndroidAgentImpl: connected ");
    }

    @Override
    @Deprecated
    public void disconnected(ConnectionEvent e) {
        this.savedState.clear();
    }

    @Override
    public void applicationForegrounded(ApplicationStateEvent e) {
        log.info("AndroidAgentImpl: application foregrounded");
        if (!FeatureFlag.featureEnabled(FeatureFlag.BackgroundReporting) && !NewRelic.isShutdown) {
            this.start();
        }
    }

    @Override
    public void applicationBackgrounded(ApplicationStateEvent e) {
        log.info("AndroidAgentImpl: application backgrounded");
        if (!FeatureFlag.featureEnabled(FeatureFlag.BackgroundReporting)) {
            this.stop();
        }
    }

    @Override
    public void setLocation(String countryCode, String adminRegion) {
        if (countryCode == null || adminRegion == null) {
            throw new IllegalArgumentException("Country code and administrative region are required.");
        }
    }

    public void setLocation(Location location) {
        if (location == null) {
            throw new IllegalArgumentException("Location must not be null.");
        }
        Geocoder coder = new Geocoder(this.context);
        List addresses = null;
        try {
            addresses = coder.getFromLocation(location.getLatitude(), location.getLongitude(), 1);
        }
        catch (IOException e) {
            log.error("Unable to geocode location: " + e.toString());
        }
        if (addresses == null || addresses.size() == 0) {
            return;
        }
        Address address = (Address)addresses.get(0);
        if (address == null) {
            return;
        }
        String countryCode = address.getCountryCode();
        String adminArea = address.getAdminArea();
        if (countryCode != null && adminArea != null) {
            this.setLocation(countryCode, adminArea);
        }
    }

    String getUUID() {
        String configuredUUID;
        String uuid = this.savedState.getConnectInformation().getDeviceInformation().getDeviceId();
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            PersistentUUID persistentUUID = new PersistentUUID(this.context);
            uuid = persistentUUID.getPersistentUUID();
            this.savedState.saveDeviceId(uuid);
            StatsEngine.get().inc("Mobile/App/UUID/Created");
        }
        if ((configuredUUID = this.agentConfiguration.getDeviceID()) != null) {
            uuid = configuredUUID;
            StatsEngine.get().inc("Mobile/App/UUID/Overridden");
        }
        return uuid;
    }

    private String getUnhandledExceptionHandlerName() {
        try {
            return Thread.getDefaultUncaughtExceptionHandler().getClass().getName();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    private void clearExistingData() {
        try {
            MeasurementEngine measurementEngine;
            if (Harvest.getInstance() != null && Harvest.getInstance().getHarvestData() != null) {
                HarvestData harvestData = Harvest.getInstance().getHarvestData();
                harvestData.reset();
            }
            TraceMachine.clearActivityHistory();
            AnalyticsControllerImpl analyticsController = AnalyticsControllerImpl.getInstance();
            if (analyticsController != null) {
                analyticsController.clear();
            }
            if ((measurementEngine = new MeasurementEngine()) != null) {
                measurementEngine.clear();
            }
        }
        catch (Exception ex) {
            log.error("There is an error while clean data during shutdown process: " + ex.getLocalizedMessage());
        }
    }

    @Override
    public Encoder getEncoder() {
        return this.encoder;
    }

    @Override
    public long getCurrentThreadId() {
        return Thread.currentThread().getId();
    }

    @Override
    public boolean isUIThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    @Override
    public String getCurrentThreadName() {
        return Thread.currentThread().getName();
    }

    protected SavedState getSavedState() {
        return this.savedState;
    }

    protected void setSavedState(SavedState savedState) {
        this.savedState = savedState;
    }

    @Override
    public boolean hasReachableNetworkConnection(String reachableHost) {
        return Reachability.hasReachableNetworkConnection(this.context, reachableHost);
    }

    @Override
    public boolean isInstantApp() {
        return InstantApps.isInstantApp(this.context);
    }

    @Override
    public void persistHarvestDataToDisk(String data) {
        this.offlineStorageInstance.persistHarvestDataToDisk(data);
    }

    @Override
    public Map<String, String> getAllOfflineData() {
        return this.offlineStorageInstance.getAllOfflineData();
    }

    @Override
    public void onHarvestConnected() {
        if (FeatureFlag.featureEnabled(FeatureFlag.ApplicationExitReporting)) {
            if (this.agentConfiguration.getApplicationExitConfiguration().isEnabled()) {
                new ApplicationExitMonitor(this.context).harvestApplicationExitInfo();
            } else {
                log.debug("ApplicationExitReporting feature is enabled locally, but disabled in remote configuration.");
            }
        }
        this.agentConfiguration.updateConfiguration(this.savedState.getHarvestConfiguration());
    }

    @Override
    public void onHarvestConfigurationChanged() {
        this.agentConfiguration.updateConfiguration(this.savedState.getHarvestConfiguration());
    }
}

