/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android;

import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.com.google.gson.annotations.SerializedName;

public class ApplicationExitConfiguration {
    @SerializedName(value="enabled")
    boolean enabled;

    public ApplicationExitConfiguration(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled && FeatureFlag.featureEnabled(FeatureFlag.ApplicationExitReporting);
    }

    public void setConfiguration(ApplicationExitConfiguration applicationExitConfiguration) {
        if (!applicationExitConfiguration.equals(this)) {
            if (!this.enabled && applicationExitConfiguration.enabled) {
                StatsEngine.SUPPORTABILITY.inc("Supportability/AgentHealth/ApplicationExitInfo/remoteConfiguration/enabled");
            } else if (this.enabled && !applicationExitConfiguration.enabled) {
                StatsEngine.SUPPORTABILITY.inc("Supportability/AgentHealth/ApplicationExitInfo/remoteConfiguration/disabled");
            }
            this.enabled = applicationExitConfiguration.enabled;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ApplicationExitConfiguration) {
            ApplicationExitConfiguration rhs = (ApplicationExitConfiguration)obj;
            return this.enabled == rhs.enabled;
        }
        return false;
    }

    public String toString() {
        return "{\"enabled\"=" + this.enabled + "}";
    }
}

