/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android;

import com.newrelic.agent.android.logging.AgentLogManager;
import java.util.HashSet;
import java.util.Set;

public enum FeatureFlag {
    HttpResponseBodyCapture,
    CrashReporting,
    AnalyticsEvents,
    InteractionTracing,
    DefaultInteractions,
    NetworkRequests,
    NetworkErrorRequests,
    HandledExceptions,
    DistributedTracing,
    NativeReporting,
    AppStartMetrics,
    FedRampEnabled,
    Jetpack,
    OfflineStorage,
    LogReporting,
    ApplicationExitReporting,
    BackgroundReporting;

    public static final Set<FeatureFlag> enabledFeatures;

    public static void enableFeature(FeatureFlag featureFlag) {
        switch (featureFlag) {
            case LogReporting: {
                AgentLogManager.getAgentLog().error("LogReporting feature is disabled in this release");
                break;
            }
            default: {
                enabledFeatures.add(featureFlag);
            }
        }
    }

    public static void disableFeature(FeatureFlag featureFlag) {
        enabledFeatures.remove((Object)featureFlag);
    }

    public static boolean featureEnabled(FeatureFlag featureFlag) {
        return enabledFeatures.contains((Object)featureFlag);
    }

    public static void resetFeatures() {
        enabledFeatures.clear();
        FeatureFlag.enableFeature(HttpResponseBodyCapture);
        FeatureFlag.enableFeature(CrashReporting);
        FeatureFlag.enableFeature(AnalyticsEvents);
        FeatureFlag.enableFeature(InteractionTracing);
        FeatureFlag.enableFeature(DefaultInteractions);
        FeatureFlag.enableFeature(NetworkRequests);
        FeatureFlag.enableFeature(NetworkErrorRequests);
        FeatureFlag.enableFeature(HandledExceptions);
        FeatureFlag.enableFeature(DistributedTracing);
        FeatureFlag.enableFeature(AppStartMetrics);
        FeatureFlag.enableFeature(ApplicationExitReporting);
    }

    static {
        enabledFeatures = new HashSet<FeatureFlag>();
        FeatureFlag.resetFeatures();
    }
}

