/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.analytics;

import com.newrelic.agent.android.analytics.AnalyticsValidator;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.util.SafeJsonPrimitive;
import com.newrelic.com.google.gson.JsonElement;
import com.newrelic.com.google.gson.JsonObject;
import com.newrelic.com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AnalyticsAttribute {
    public static final String USER_ID_ATTRIBUTE = "userId";
    public static final String ACCOUNT_ID_ATTRIBUTE = "accountId";
    public static final String APP_ID_ATTRIBUTE = "appId";
    public static final String APP_BUILD_ATTRIBUTE = "appBuild";
    public static final String APP_NAME_ATTRIBUTE = "appName";
    public static final String APPLICATION_PLATFORM_ATTRIBUTE = "platform";
    public static final String APPLICATION_PLATFORM_VERSION_ATTRIBUTE = "platformVersion";
    public static final String UUID_ATTRIBUTE = "uuid";
    public static final String OS_NAME_ATTRIBUTE = "osName";
    public static final String OS_VERSION_ATTRIBUTE = "osVersion";
    public static final String OS_MAJOR_VERSION_ATTRIBUTE = "osMajorVersion";
    public static final String OS_BUILD_ATTRIBUTE = "osBuild";
    public static final String ARCHITECTURE_ATTRIBUTE = "architecture";
    public static final String RUNTIME_ATTRIBUTE = "runTime";
    public static final String DEVICE_MANUFACTURER_ATTRIBUTE = "deviceManufacturer";
    public static final String DEVICE_MODEL_ATTRIBUTE = "deviceModel";
    public static final String CARRIER_ATTRIBUTE = "carrier";
    public static final String NEW_RELIC_VERSION_ATTRIBUTE = "newRelicVersion";
    public static final String MEM_USAGE_MB_ATTRIBUTE = "memUsageMb";
    public static final String SESSION_ID_ATTRIBUTE = "sessionId";
    public static final String SESSION_DURATION_ATTRIBUTE = "sessionDuration";
    public static final String SESSION_TIME_SINCE_LOAD_ATTRIBUTE = "timeSinceLoad";
    public static final String INTERACTION_DURATION_ATTRIBUTE = "interactionDuration";
    public static final String LAST_INTERACTION_ATTRIBUTE = "lastInteraction";
    public static final String MUTABLE = "mutable";
    public static final String UNHANDLED_NATIVE_EXCEPTION = "unhandledNativeException";
    public static final String NATIVE_CRASH = "nativeCrash";
    public static final String ANR = "ANR";
    public static final String EVENT_CATEGORY_ATTRIBUTE = "category";
    public static final String EVENT_NAME_ATTRIBUTE = "name";
    public static final String EVENT_TIMESTAMP_ATTRIBUTE = "timestamp";
    public static final String EVENT_TYPE_ATTRIBUTE = "eventType";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String APP_INSTALL_ATTRIBUTE = "install";
    public static final String APP_UPGRADE_ATTRIBUTE = "upgradeFrom";
    public static final String REQUEST_URL_ATTRIBUTE = "requestUrl";
    public static final String REQUEST_DOMAIN_ATTRIBUTE = "requestDomain";
    public static final String REQUEST_PATH_ATTRIBUTE = "requestPath";
    public static final String REQUEST_METHOD_ATTRIBUTE = "requestMethod";
    public static final String CONNECTION_TYPE_ATTRIBUTE = "connectionType";
    public static final String STATUS_CODE_ATTRIBUTE = "statusCode";
    public static final String BYTES_RECEIVED_ATTRIBUTE = "bytesReceived";
    public static final String BYTES_SENT_ATTRIBUTE = "bytesSent";
    public static final String RESPONSE_TIME_ATTRIBUTE = "responseTime";
    public static final String NETWORK_ERROR_CODE_ATTRIBUTE = "networkErrorCode";
    public static final String CONTENT_TYPE_ATTRIBUTE = "contentType";
    public static final String RESPONSE_BODY_ATTRIBUTE = "nr.responseBody";
    public static final String APP_DATA_ATTRIBUTE = "nr.X-NewRelic-App-Data";
    public static final String INSTANT_APP_ATTRIBUTE = "instantApp";
    public static final String ACTION_TYPE_ATTRIBUTE = "actionType";
    public static final String OFFLINE_NAME_ATTRIBUTE = "offline";
    public static final String BACKGROUND_ATTRIBUTE_NAME = "background";
    public static final String APP_EXIT_TIMESTAMP_ATTRIBUTE = "exitTimestamp";
    public static final String APP_EXIT_DESCRIPTION_ATTRIBUTE = "description";
    public static final String APP_EXIT_REASON_ATTRIBUTE = "reason";
    public static final String APP_EXIT_IMPORTANCE_ATTRIBUTE = "importance";
    public static final String APP_EXIT_IMPORTANCE_STRING_ATTRIBUTE = "importanceAsString";
    public static final String APP_EXIT_PROCESS_NAME_ATTRIBUTE = "processName";
    public static final String APP_EXIT_APP_STATE_ATTRIBUTE = "appState";
    public static final int ATTRIBUTE_NAME_MAX_LENGTH = 255;
    public static final int ATTRIBUTE_VALUE_MAX_LENGTH = 4096;
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private static final AnalyticsValidator validator = new AnalyticsValidator();
    private String name;
    private String stringValue;
    private double doubleValue;
    private boolean isPersistent;
    private AttributeDataType attributeDataType;

    protected AnalyticsAttribute() {
        this.stringValue = null;
        this.doubleValue = Double.NaN;
        this.isPersistent = false;
        this.attributeDataType = AttributeDataType.VOID;
    }

    public AnalyticsAttribute(String name, String stringValue) {
        this(name, stringValue, true);
    }

    public AnalyticsAttribute(String name, String stringValue, boolean isPersistent) {
        this.name = name;
        this.setStringValue(stringValue);
        this.isPersistent = isPersistent;
    }

    public AnalyticsAttribute(String name, double doubleValue) {
        this(name, doubleValue, true);
    }

    public AnalyticsAttribute(String name, double doubleValue, boolean isPersistent) {
        this.name = name;
        this.setDoubleValue(doubleValue);
        this.isPersistent = isPersistent;
    }

    public AnalyticsAttribute(String name, boolean boolValue) {
        this(name, boolValue, true);
    }

    public AnalyticsAttribute(String name, boolean boolValue, boolean isPersistent) {
        this.name = name;
        this.setBooleanValue(boolValue);
        this.isPersistent = isPersistent;
    }

    public AnalyticsAttribute(AnalyticsAttribute clone) {
        this.name = clone.name;
        this.doubleValue = clone.doubleValue;
        this.stringValue = clone.stringValue;
        this.isPersistent = clone.isPersistent;
        this.attributeDataType = clone.attributeDataType;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStringAttribute() {
        return this.attributeDataType == AttributeDataType.STRING;
    }

    public boolean isDoubleAttribute() {
        return this.attributeDataType == AttributeDataType.DOUBLE;
    }

    public boolean isBooleanAttribute() {
        return this.attributeDataType == AttributeDataType.BOOLEAN;
    }

    public String getStringValue() {
        return this.attributeDataType == AttributeDataType.STRING ? this.stringValue : null;
    }

    public AnalyticsAttribute setStringValue(String stringValue) {
        this.doubleValue = Double.NaN;
        this.stringValue = stringValue;
        this.attributeDataType = AttributeDataType.STRING;
        return this;
    }

    public double getDoubleValue() {
        return this.attributeDataType == AttributeDataType.DOUBLE ? this.doubleValue : Double.NaN;
    }

    public AnalyticsAttribute setDoubleValue(double doubleValue) {
        this.doubleValue = doubleValue;
        this.stringValue = null;
        this.attributeDataType = AttributeDataType.DOUBLE;
        return this;
    }

    public boolean getBooleanValue() {
        return this.attributeDataType == AttributeDataType.BOOLEAN ? Boolean.valueOf(this.stringValue) : false;
    }

    public AnalyticsAttribute setBooleanValue(boolean boolValue) {
        this.stringValue = Boolean.toString(boolValue);
        this.doubleValue = Double.NaN;
        this.attributeDataType = AttributeDataType.BOOLEAN;
        return this;
    }

    public boolean isPersistent() {
        return this.isPersistent && !validator.isExcludedAttributeName(this.name);
    }

    public AnalyticsAttribute setPersistent(boolean isPersistent) {
        this.isPersistent = isPersistent;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsAttribute attribute = (AnalyticsAttribute)o;
        return this.name.equals(attribute.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("AnalyticsAttribute{");
        stringBuilder.append("name='" + this.name + "'");
        switch (this.attributeDataType) {
            case VOID: {
                break;
            }
            case STRING: {
                stringBuilder.append(",stringValue='" + this.stringValue + "'");
                break;
            }
            case DOUBLE: {
                stringBuilder.append(",doubleValue='" + this.doubleValue + "'");
                break;
            }
            case BOOLEAN: {
                stringBuilder.append(",booleanValue=" + Boolean.valueOf(this.stringValue).toString());
            }
        }
        stringBuilder.append(",isPersistent=" + this.isPersistent);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public AttributeDataType getAttributeDataType() {
        return this.attributeDataType;
    }

    public String valueAsString() {
        String value;
        switch (this.attributeDataType) {
            case STRING: {
                value = this.stringValue;
                break;
            }
            case DOUBLE: {
                value = Double.toString(this.doubleValue);
                break;
            }
            case BOOLEAN: {
                value = Boolean.valueOf(this.getBooleanValue()).toString();
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    public JsonElement asJsonElement() {
        JsonPrimitive jsonPrimitive;
        switch (this.attributeDataType) {
            case STRING: {
                jsonPrimitive = SafeJsonPrimitive.factory(this.getStringValue());
                break;
            }
            case DOUBLE: {
                jsonPrimitive = SafeJsonPrimitive.factory(this.getDoubleValue());
                break;
            }
            case BOOLEAN: {
                jsonPrimitive = SafeJsonPrimitive.factory(this.getBooleanValue());
                break;
            }
            default: {
                jsonPrimitive = null;
            }
        }
        return jsonPrimitive;
    }

    public static Set<AnalyticsAttribute> newFromJson(JsonObject attributesJson) {
        HashSet<AnalyticsAttribute> attributeSet = new HashSet<AnalyticsAttribute>();
        for (Map.Entry<String, JsonElement> elem : attributesJson.entrySet()) {
            String key = elem.getKey();
            if (elem.getValue().isJsonPrimitive()) {
                JsonPrimitive value = elem.getValue().getAsJsonPrimitive();
                if (value.isString()) {
                    attributeSet.add(new AnalyticsAttribute(key, value.getAsString(), false));
                    continue;
                }
                if (value.isBoolean()) {
                    attributeSet.add(new AnalyticsAttribute(key, value.getAsBoolean(), false));
                    continue;
                }
                if (!value.isNumber()) continue;
                attributeSet.add(new AnalyticsAttribute(key, value.getAsDouble(), false));
                continue;
            }
            attributeSet.add(new AnalyticsAttribute(key, elem.getValue().getAsString(), false));
        }
        return attributeSet;
    }

    boolean isValid() {
        return validator.isValidAttribute(this);
    }

    static AnalyticsAttribute createAttribute(String key, Object value) {
        try {
            if (null != value && validator.isValidAttributeName(key)) {
                if (value instanceof String) {
                    if (validator.isValidAttributeValue(key, (String)value)) {
                        return new AnalyticsAttribute(key, String.valueOf(value));
                    }
                } else {
                    if (value instanceof Float) {
                        return new AnalyticsAttribute(key, ((Float)value).floatValue());
                    }
                    if (value instanceof Double) {
                        return new AnalyticsAttribute(key, (Double)value);
                    }
                    if (value instanceof Integer) {
                        return new AnalyticsAttribute(key, ((Integer)value).intValue());
                    }
                    if (value instanceof Short) {
                        return new AnalyticsAttribute(key, ((Short)value).shortValue());
                    }
                    if (value instanceof Long) {
                        return new AnalyticsAttribute(key, ((Long)value).longValue());
                    }
                    if (value instanceof BigDecimal) {
                        return new AnalyticsAttribute(key, ((BigDecimal)value).doubleValue());
                    }
                    if (value instanceof BigInteger) {
                        return new AnalyticsAttribute(key, ((BigInteger)value).doubleValue());
                    }
                    if (value instanceof Boolean) {
                        return new AnalyticsAttribute(key, (Boolean)value);
                    }
                    log.error("Unsupported event attribute type for key [" + key + "]: " + value.getClass().getName());
                }
            }
        }
        catch (ClassCastException e) {
            log.error(String.format("Error casting attribute [%s] to String or Float: ", key), e);
        }
        return null;
    }

    public static enum AttributeDataType {
        VOID,
        STRING,
        DOUBLE,
        BOOLEAN;

    }
}

