/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.analytics;

import com.newrelic.agent.android.analytics.AnalyticsAttribute;
import com.newrelic.agent.android.analytics.AnalyticsEventCategory;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AnalyticsValidator {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private static final String NEW_RELIC_PREFIX = "newRelic";
    private static final String NR_PREFIX = "nr.";
    private static final String PUBLIC_PREFIX = "Public_";
    static final Set<String> reservedAttributeNames = new HashSet<String>(){
        {
            this.add("eventType");
            this.add("type");
            this.add("timestamp");
            this.add("category");
            this.add("accountId");
            this.add("appId");
            this.add("appName");
            this.add("uuid");
            this.add("sessionId");
            this.add("osName");
            this.add("osVersion");
            this.add("osMajorVersion");
            this.add("deviceManufacturer");
            this.add("deviceModel");
            this.add("memUsageMb");
            this.add("carrier");
            this.add("newRelicVersion");
            this.add("interactionDuration");
            this.add("install");
            this.add("upgradeFrom");
            this.add("platform");
            this.add("platformVersion");
            this.add("lastInteraction");
            this.add("osBuild");
            this.add("runTime");
            this.add("architecture");
            this.add("appBuild");
        }
    };
    protected static Set<String> excludedAttributeNames = new HashSet<String>(){
        {
            this.add("install");
            this.add("upgradeFrom");
            this.add("sessionDuration");
        }
    };
    private static final String ALLOWABLE_EVENT_TYPE_CHARS = "^[\\p{L}\\p{Nd} _:.]+$";
    static final Set<String> reservedEventTypes = new HashSet<String>(){
        {
            this.add("Mobile");
            this.add("MobileRequest");
            this.add("MobileRequestError");
            this.add("MobileBreadcrumb");
            this.add("MobileCrash");
            this.add("MobileUserAction");
            this.add("MobileApplicationExit");
        }
    };

    boolean isValidKeyName(String keyName) {
        boolean valid;
        boolean bl = valid = keyName != null && !keyName.isEmpty() && keyName.length() < 255;
        if (!valid) {
            log.error("Attribute name [" + keyName + "] is null, empty, or exceeds the maximum length of 255 characters.");
        }
        return valid;
    }

    public boolean isValidAttributeName(String attributeName) {
        boolean valid = this.isValidKeyName(attributeName);
        if (valid) {
            boolean bl = valid = !this.isReservedAttributeName(attributeName);
            if (!valid) {
                log.error("Attribute name [" + attributeName + "] is reserved for internal use and will be ignored.");
            }
        }
        return valid;
    }

    public boolean isReservedAttributeName(String attributeName) {
        if (reservedAttributeNames.contains(attributeName)) {
            log.error("Attribute name [" + attributeName + "] is in the reserved names list.");
            return true;
        }
        if (attributeName.startsWith(NEW_RELIC_PREFIX)) {
            log.error("Attribute name [" + attributeName + "] starts with reserved prefix [newRelic]");
            return true;
        }
        if (attributeName.startsWith(NR_PREFIX)) {
            log.error("Attribute name [" + attributeName + "] starts with reserved prefix [nr.]");
            return true;
        }
        if (attributeName.startsWith(PUBLIC_PREFIX)) {
            log.error("Attribute name [" + attributeName + "] starts with reserved prefix [Public_]");
            return true;
        }
        return false;
    }

    public boolean isExcludedAttributeName(String attributeName) {
        return excludedAttributeNames.contains(attributeName);
    }

    public boolean isValidAttributeValue(String name, String value) {
        boolean valid;
        boolean bl = valid = value != null && !value.isEmpty() && value.getBytes().length < 4096;
        if (!valid) {
            log.error("Attribute value for name [" + name + "] is null, empty, or exceeds the maximum length of 4096 bytes.");
        }
        return valid;
    }

    public boolean isValidAttribute(AnalyticsAttribute attribute) {
        return attribute != null && this.isValidAttributeName(attribute.getName()) && this.isValidAttributeValue(attribute.getName(), attribute.valueAsString());
    }

    public Set<AnalyticsAttribute> toValidatedAnalyticsAttributes(Map<String, Object> attributeMap) {
        try {
            HashSet<AnalyticsAttribute> filteredAttributes = new HashSet<AnalyticsAttribute>();
            for (String key : attributeMap.keySet()) {
                Object value;
                AnalyticsAttribute attr = AnalyticsAttribute.createAttribute(key, value = attributeMap.get(key));
                if (this.isValidAttribute(attr)) {
                    filteredAttributes.add(attr);
                    continue;
                }
                log.warn(String.format("Attribute [" + key + "] ignored: value is null, empty or exceeds the maximum name length", new Object[0]));
            }
            return filteredAttributes;
        }
        catch (Exception e) {
            log.error("Error occurred filtering attribute map: ", e);
            return Collections.emptySet();
        }
    }

    public Set<AnalyticsAttribute> toValidatedAnalyticsAttributes(Set<AnalyticsAttribute> attributeSet) {
        try {
            HashSet<AnalyticsAttribute> filteredAttributes = new HashSet<AnalyticsAttribute>();
            for (AnalyticsAttribute attribute : attributeSet) {
                if (this.isValidAttribute(attribute)) {
                    filteredAttributes.add(new AnalyticsAttribute(attribute));
                    continue;
                }
                log.warn(String.format("Attribute [" + attribute.getName() + "] ignored: value is null, empty or exceeds the maximum name length", new Object[0]));
            }
            return filteredAttributes;
        }
        catch (Exception e) {
            log.error("Error occurred filtering attribute set: ", e);
            return Collections.emptySet();
        }
    }

    public boolean isValidEventName(String eventName) {
        return eventName != null && !eventName.isEmpty() && eventName.length() < 255;
    }

    public boolean isValidEventType(String eventType) {
        boolean valid;
        boolean bl = valid = eventType != null;
        if (valid) {
            valid = eventType.matches(ALLOWABLE_EVENT_TYPE_CHARS);
        }
        if (!valid) {
            log.error("Event type [" + eventType + "] is invalid and will be ignored. Custom event types may only include alphanumeric, ' ', '.', ':' or '_' characters.");
        }
        return valid;
    }

    public boolean isReservedEventType(String eventType) {
        boolean reserved;
        boolean bl = reserved = this.isValidEventType(eventType) && reservedEventTypes.contains(eventType);
        if (reserved) {
            log.error("Event type [" + eventType + "] is reserved and will be ignored.");
        }
        return reserved;
    }

    public String toValidEventType(String eventType) {
        return eventType == null || eventType.isEmpty() ? "Mobile" : eventType;
    }

    public AnalyticsEventCategory toValidCategory(AnalyticsEventCategory category) {
        return category == null ? AnalyticsEventCategory.Custom : category;
    }
}

