/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation;

import android.util.Log;
import com.newrelic.agent.android.instrumentation.ReplaceCallSite;
import com.newrelic.agent.android.logging.LogLevel;
import com.newrelic.agent.android.logging.LogReporting;
import java.util.HashMap;
import java.util.Map;

public class LogInstrumentation {
    @ReplaceCallSite(isStatic=true)
    public static int d(String tag, String message) {
        Log.d((String)tag, (String)message);
        LogReporting.getLogger().logAttributes(LogInstrumentation.asAttributes(LogLevel.DEBUG, tag, message));
        return LogReporting.isLevelEnabled(LogLevel.DEBUG) ? 1 : 0;
    }

    @ReplaceCallSite(isStatic=true)
    public static int w(String tag, String message) {
        Log.w((String)tag, (String)message);
        LogReporting.getLogger().logAttributes(LogInstrumentation.asAttributes(LogLevel.WARN, tag, message));
        return LogReporting.isLevelEnabled(LogLevel.WARN) ? 1 : 0;
    }

    @ReplaceCallSite(isStatic=true)
    public static int i(String tag, String message) {
        Log.i((String)tag, (String)message);
        LogReporting.getLogger().logAttributes(LogInstrumentation.asAttributes(LogLevel.INFO, tag, message));
        return LogReporting.isLevelEnabled(LogLevel.INFO) ? 1 : 0;
    }

    @ReplaceCallSite(isStatic=true)
    public static int v(String tag, String message) {
        Log.v((String)tag, (String)message);
        LogReporting.getLogger().logAttributes(LogInstrumentation.asAttributes(LogLevel.VERBOSE, tag, message));
        return LogReporting.isLevelEnabled(LogLevel.VERBOSE) ? 1 : 0;
    }

    @ReplaceCallSite(isStatic=true)
    public static int e(String tag, String message) {
        Log.e((String)tag, (String)message);
        LogReporting.getLogger().logAttributes(LogInstrumentation.asAttributes(LogLevel.ERROR, tag, message));
        return LogReporting.isLevelEnabled(LogLevel.ERROR) ? 1 : 0;
    }

    @ReplaceCallSite(isStatic=true)
    public static int e(String tag, String message, Throwable throwable) {
        Log.e((String)tag, (String)message, (Throwable)throwable);
        LogReporting.getLogger().logAll(throwable, LogInstrumentation.asAttributes(LogLevel.ERROR, tag, message));
        return LogReporting.isLevelEnabled(LogLevel.ERROR) ? 1 : 0;
    }

    @ReplaceCallSite(isStatic=true)
    public static int d(String tag, String message, Throwable throwable) {
        Log.d((String)tag, (String)message, (Throwable)throwable);
        LogReporting.getLogger().logAll(throwable, LogInstrumentation.asAttributes(LogLevel.DEBUG, tag, message));
        return LogReporting.isLevelEnabled(LogLevel.DEBUG) ? 1 : 0;
    }

    @ReplaceCallSite(isStatic=true)
    public static int w(String tag, String message, Throwable throwable) {
        Log.w((String)tag, (String)message, (Throwable)throwable);
        LogReporting.getLogger().logAll(throwable, LogInstrumentation.asAttributes(LogLevel.WARN, tag, message));
        return LogReporting.isLevelEnabled(LogLevel.WARN) ? 1 : 0;
    }

    @ReplaceCallSite(isStatic=true)
    public static int i(String tag, String message, Throwable throwable) {
        Log.i((String)tag, (String)message, (Throwable)throwable);
        LogReporting.getLogger().logAll(throwable, LogInstrumentation.asAttributes(LogLevel.INFO, tag, message));
        return LogReporting.isLevelEnabled(LogLevel.DEBUG) ? 1 : 0;
    }

    @ReplaceCallSite(isStatic=true)
    public static int v(String tag, String message, Throwable throwable) {
        Log.v((String)tag, (String)message, (Throwable)throwable);
        LogReporting.getLogger().logAll(throwable, LogInstrumentation.asAttributes(LogLevel.VERBOSE, tag, message));
        return LogReporting.isLevelEnabled(LogLevel.VERBOSE) ? 1 : 0;
    }

    private static Map<String, Object> asAttributes(LogLevel logLevel, String tag, String message) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("tag", tag);
        attrs.put("message", message);
        attrs.put("level", logLevel.name().toUpperCase());
        return attrs;
    }
}

